/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A private fare for a specific airline. One of `corporate_code` or `tracking_reference` must be provided")
@JsonPropertyOrder(value={"corporate_code", "tracking_reference"})
@JsonTypeName(value="Offer_Request_Body_Private_Fare")
public class OfferRequestBodyPrivateFare {
    public static final String JSON_PROPERTY_CORPORATE_CODE = "corporate_code";
    private String corporateCode;
    public static final String JSON_PROPERTY_TRACKING_REFERENCE = "tracking_reference";
    private String trackingReference;

    public OfferRequestBodyPrivateFare corporateCode(String corporateCode) {
        this.corporateCode = corporateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="FLX53", value="The corporate code provided to you by the airline.")
    @JsonProperty(value="corporate_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCorporateCode() {
        return this.corporateCode;
    }

    @JsonProperty(value="corporate_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorporateCode(String corporateCode) {
        this.corporateCode = corporateCode;
    }

    public OfferRequestBodyPrivateFare trackingReference(String trackingReference) {
        this.trackingReference = trackingReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABN:2345678", value="Tracking reference agreed with the airline. This value is to identify your business and is usually business number or agency id.")
    @JsonProperty(value="tracking_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTrackingReference() {
        return this.trackingReference;
    }

    @JsonProperty(value="tracking_reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrackingReference(String trackingReference) {
        this.trackingReference = trackingReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestBodyPrivateFare offerRequestBodyPrivateFare = (OfferRequestBodyPrivateFare)o;
        return Objects.equals(this.corporateCode, offerRequestBodyPrivateFare.corporateCode) && Objects.equals(this.trackingReference, offerRequestBodyPrivateFare.trackingReference);
    }

    public int hashCode() {
        return Objects.hash(this.corporateCode, this.trackingReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestBodyPrivateFare {\n");
        sb.append("    corporateCode: ").append(this.toIndentedString(this.corporateCode)).append("\n");
        sb.append("    trackingReference: ").append(this.toIndentedString(this.trackingReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

