/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.ArrivalTime;
import com.duffel.sdk.model.DepartureTime;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"arrival_time", "departure_date", "departure_time", "destination", "origin"})
@JsonTypeName(value="Offer_Request_Body_Slice")
public class OfferRequestBodySlice {
    public static final String JSON_PROPERTY_ARRIVAL_TIME = "arrival_time";
    private JsonNullable<ArrivalTime> arrivalTime = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
    private LocalDate departureDate;
    public static final String JSON_PROPERTY_DEPARTURE_TIME = "departure_time";
    private JsonNullable<DepartureTime> departureTime = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;

    public OfferRequestBodySlice arrivalTime(ArrivalTime arrivalTime) {
        this.arrivalTime = JsonNullable.of((Object)arrivalTime);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public ArrivalTime getArrivalTime() {
        return (ArrivalTime)this.arrivalTime.orElse(null);
    }

    @JsonProperty(value="arrival_time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ArrivalTime> getArrivalTime_JsonNullable() {
        return this.arrivalTime;
    }

    @JsonProperty(value="arrival_time")
    public void setArrivalTime_JsonNullable(JsonNullable<ArrivalTime> arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public void setArrivalTime(ArrivalTime arrivalTime) {
        this.arrivalTime = JsonNullable.of((Object)arrivalTime);
    }

    public OfferRequestBodySlice departureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Fri Apr 24 07:00:00 ICT 2020", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDepartureDate() {
        return this.departureDate;
    }

    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDepartureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
    }

    public OfferRequestBodySlice departureTime(DepartureTime departureTime) {
        this.departureTime = JsonNullable.of((Object)departureTime);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public DepartureTime getDepartureTime() {
        return (DepartureTime)this.departureTime.orElse(null);
    }

    @JsonProperty(value="departure_time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<DepartureTime> getDepartureTime_JsonNullable() {
        return this.departureTime;
    }

    @JsonProperty(value="departure_time")
    public void setDepartureTime_JsonNullable(JsonNullable<DepartureTime> departureTime) {
        this.departureTime = departureTime;
    }

    public void setDepartureTime(DepartureTime departureTime) {
        this.departureTime = JsonNullable.of((Object)departureTime);
    }

    public OfferRequestBodySlice destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="JFK", required=true, value="The 3-letter IATA code for the city or airport where this slice ends")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public OfferRequestBodySlice origin(String origin) {
        this.origin = origin;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LHR", required=true, value="The 3-letter IATA code for the city or airport where this slice starts")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestBodySlice offerRequestBodySlice = (OfferRequestBodySlice)o;
        return OfferRequestBodySlice.equalsNullable(this.arrivalTime, offerRequestBodySlice.arrivalTime) && Objects.equals(this.departureDate, offerRequestBodySlice.departureDate) && OfferRequestBodySlice.equalsNullable(this.departureTime, offerRequestBodySlice.departureTime) && Objects.equals(this.destination, offerRequestBodySlice.destination) && Objects.equals(this.origin, offerRequestBodySlice.origin);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(OfferRequestBodySlice.hashCodeNullable(this.arrivalTime), this.departureDate, OfferRequestBodySlice.hashCodeNullable(this.departureTime), this.destination, this.origin);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestBodySlice {\n");
        sb.append("    arrivalTime: ").append(this.toIndentedString(this.arrivalTime)).append("\n");
        sb.append("    departureDate: ").append(this.toIndentedString(this.departureDate)).append("\n");
        sb.append("    departureTime: ").append(this.toIndentedString(this.departureTime)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

