/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"age", "family_name", "given_name", "id", "loyalty_programme_accounts", "type"})
@JsonTypeName(value="Offer_Request_Passenger")
public class OfferRequestPassenger {
    public static final String JSON_PROPERTY_AGE = "age";
    private Integer age;
    public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
    private JsonNullable<String> familyName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
    private JsonNullable<String> givenName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
    private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public OfferRequestPassenger age(Integer age) {
        this.age = age;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=130L)
    @ApiModelProperty(example="14", value="The age of the passenger on the `departure_date` of the final slice")
    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=130L) Integer getAge() {
        return this.age;
    }

    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAge(Integer age) {
        this.age = age;
    }

    public OfferRequestPassenger familyName(String familyName) {
        this.familyName = JsonNullable.of((Object)familyName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Earhart", value="The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonIgnore
    public String getFamilyName() {
        return (String)this.familyName.orElse(null);
    }

    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFamilyName_JsonNullable() {
        return this.familyName;
    }

    @JsonProperty(value="family_name")
    public void setFamilyName_JsonNullable(JsonNullable<String> familyName) {
        this.familyName = familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = JsonNullable.of((Object)familyName);
    }

    public OfferRequestPassenger givenName(String givenName) {
        this.givenName = JsonNullable.of((Object)givenName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Amelia", value="The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonIgnore
    public String getGivenName() {
        return (String)this.givenName.orElse(null);
    }

    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getGivenName_JsonNullable() {
        return this.givenName;
    }

    @JsonProperty(value="given_name")
    public void setGivenName_JsonNullable(JsonNullable<String> givenName) {
        this.givenName = givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = JsonNullable.of((Object)givenName);
    }

    public OfferRequestPassenger id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pas_00009hj8USM7Ncg31cBCL", value="The identifier for the passenger, unique within this Offer Request and across all Offer Requests. This ID will be generated by Duffel. Optionally providing an ID has been deprecated.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OfferRequestPassenger loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
        return this;
    }

    public OfferRequestPassenger addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
        if (this.loyaltyProgrammeAccounts == null) {
            this.loyaltyProgrammeAccounts = new ArrayList<LoyaltyProgrammeAccount>();
        }
        this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The __Loyalty Programme Accounts__ for this passenger")
    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
        return this.loyaltyProgrammeAccounts;
    }

    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    }

    public OfferRequestPassenger type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="adult", value="The type of the passenger")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestPassenger offerRequestPassenger = (OfferRequestPassenger)o;
        return Objects.equals(this.age, offerRequestPassenger.age) && OfferRequestPassenger.equalsNullable(this.familyName, offerRequestPassenger.familyName) && OfferRequestPassenger.equalsNullable(this.givenName, offerRequestPassenger.givenName) && Objects.equals(this.id, offerRequestPassenger.id) && Objects.equals(this.loyaltyProgrammeAccounts, offerRequestPassenger.loyaltyProgrammeAccounts) && Objects.equals((Object)this.type, (Object)offerRequestPassenger.type);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.age, OfferRequestPassenger.hashCodeNullable(this.familyName), OfferRequestPassenger.hashCodeNullable(this.givenName), this.id, this.loyaltyProgrammeAccounts, this.type});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestPassenger {\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    loyaltyProgrammeAccounts: ").append(this.toIndentedString(this.loyaltyProgrammeAccounts)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ADULT("adult"),
        CHILD("child"),
        INFANT_WITHOUT_SEAT("infant_without_seat");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

