/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OrderChangeSlicesSliceSegmentsInner;
import com.duffel.sdk.model.Place3;
import com.duffel.sdk.model.Place4;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A slice that is being removed or added")
@JsonPropertyOrder(value={"destination", "destination_type", "duration", "id", "origin", "origin_type", "segments"})
@JsonTypeName(value="Order_Change_Slices_Slice")
public class OrderChangeSlicesSlice {
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private Place3 destination;
    public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
    private DestinationTypeEnum destinationType;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private JsonNullable<String> duration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private Place4 origin;
    public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
    private OriginTypeEnum originType;
    public static final String JSON_PROPERTY_SEGMENTS = "segments";
    private List<OrderChangeSlicesSliceSegmentsInner> segments = null;

    public OrderChangeSlicesSlice destination(Place3 destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Place3 getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(Place3 destination) {
        this.destination = destination;
    }

    public OrderChangeSlicesSlice destinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="airport", value="The type of the destination")
    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DestinationTypeEnum getDestinationType() {
        return this.destinationType;
    }

    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
    }

    public OrderChangeSlicesSlice duration(String duration) {
        this.duration = JsonNullable.of((Object)duration);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PT02H26M", value="The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
    @JsonIgnore
    public String getDuration() {
        return (String)this.duration.orElse(null);
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDuration_JsonNullable() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration_JsonNullable(JsonNullable<String> duration) {
        this.duration = duration;
    }

    public void setDuration(String duration) {
        this.duration = JsonNullable.of((Object)duration);
    }

    public OrderChangeSlicesSlice id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sli_00009htYpSCXrwaB9Dn123", value="Duffel's unique identifier for the slice. It identifies the slice of an order (i.e. the same slice across orders will have different `id`s.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderChangeSlicesSlice origin(Place4 origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Place4 getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(Place4 origin) {
        this.origin = origin;
    }

    public OrderChangeSlicesSlice originType(OriginTypeEnum originType) {
        this.originType = originType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="airport", value="The type of the origin")
    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OriginTypeEnum getOriginType() {
        return this.originType;
    }

    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginType(OriginTypeEnum originType) {
        this.originType = originType;
    }

    public OrderChangeSlicesSlice segments(List<OrderChangeSlicesSliceSegmentsInner> segments) {
        this.segments = segments;
        return this;
    }

    public OrderChangeSlicesSlice addSegmentsItem(OrderChangeSlicesSliceSegmentsInner segmentsItem) {
        if (this.segments == null) {
            this.segments = new ArrayList<OrderChangeSlicesSliceSegmentsInner>();
        }
        this.segments.add(segmentsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The segments - that is, specific flights - that the airline is offering to get the passengers from the `origin` to the `destination`")
    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OrderChangeSlicesSliceSegmentsInner> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegments(List<OrderChangeSlicesSliceSegmentsInner> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderChangeSlicesSlice orderChangeSlicesSlice = (OrderChangeSlicesSlice)o;
        return Objects.equals(this.destination, orderChangeSlicesSlice.destination) && Objects.equals((Object)this.destinationType, (Object)orderChangeSlicesSlice.destinationType) && OrderChangeSlicesSlice.equalsNullable(this.duration, orderChangeSlicesSlice.duration) && Objects.equals(this.id, orderChangeSlicesSlice.id) && Objects.equals(this.origin, orderChangeSlicesSlice.origin) && Objects.equals((Object)this.originType, (Object)orderChangeSlicesSlice.originType) && Objects.equals(this.segments, orderChangeSlicesSlice.segments);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destination, this.destinationType, OrderChangeSlicesSlice.hashCodeNullable(this.duration), this.id, this.origin, this.originType, this.segments});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderChangeSlicesSlice {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinationType: ").append(this.toIndentedString((Object)this.destinationType)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originType: ").append(this.toIndentedString((Object)this.originType)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private DestinationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DestinationTypeEnum fromValue(String value) {
            for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OriginTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private OriginTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OriginTypeEnum fromValue(String value) {
            for (OriginTypeEnum b : OriginTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

