/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OrderSliceConditions1;
import com.duffel.sdk.model.OrderSliceSegment;
import com.duffel.sdk.model.Place3;
import com.duffel.sdk.model.Place4;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"changeable", "conditions", "destination", "destination_type", "duration", "id", "origin", "origin_type", "segments"})
@JsonTypeName(value="Order_Slice")
public class OrderSlice {
    public static final String JSON_PROPERTY_CHANGEABLE = "changeable";
    private Boolean changeable;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private OrderSliceConditions1 conditions;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private Place3 destination;
    public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
    private DestinationTypeEnum destinationType;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private String duration;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private Place4 origin;
    public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
    private OriginTypeEnum originType;
    public static final String JSON_PROPERTY_SEGMENTS = "segments";
    private List<OrderSliceSegment> segments = new ArrayList<OrderSliceSegment>();

    public OrderSlice changeable(Boolean changeable) {
        this.changeable = changeable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Whether this slice can be changed. This can only be `true` for paid orders. This field is deprecated and has been replaced with the [new `available_actions` field](https://duffel.com/docs/api/orders#orders-schema-available-actions) at the top-level __Order__ schema.")
    @JsonProperty(value="changeable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getChangeable() {
        return this.changeable;
    }

    @JsonProperty(value="changeable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChangeable(Boolean changeable) {
        this.changeable = changeable;
    }

    public OrderSlice conditions(OrderSliceConditions1 conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrderSliceConditions1 getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConditions(OrderSliceConditions1 conditions) {
        this.conditions = conditions;
    }

    public OrderSlice destination(Place3 destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Place3 getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestination(Place3 destination) {
        this.destination = destination;
    }

    public OrderSlice destinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="airport", required=true, value="The type of the destination")
    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DestinationTypeEnum getDestinationType() {
        return this.destinationType;
    }

    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
    }

    public OrderSlice duration(String duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="PT02H26M", required=true, value="The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDuration(String duration) {
        this.duration = duration;
    }

    public OrderSlice id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="sli_00009htYpSCXrwaB9Dn123", required=true, value="Duffel's unique identifier for the slice. It identifies the slice of an order (i.e. the same slice across orders will have different `id`s.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderSlice origin(Place4 origin) {
        this.origin = origin;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Place4 getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrigin(Place4 origin) {
        this.origin = origin;
    }

    public OrderSlice originType(OriginTypeEnum originType) {
        this.originType = originType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="airport", required=true, value="The type of the origin")
    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OriginTypeEnum getOriginType() {
        return this.originType;
    }

    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOriginType(OriginTypeEnum originType) {
        this.originType = originType;
    }

    public OrderSlice segments(List<OrderSliceSegment> segments) {
        this.segments = segments;
        return this;
    }

    public OrderSlice addSegmentsItem(OrderSliceSegment segmentsItem) {
        this.segments.add(segmentsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The segments - that is, specific flights - that the airline is offering to get the passengers from the `origin` to the `destination`")
    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderSliceSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSegments(List<OrderSliceSegment> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderSlice orderSlice = (OrderSlice)o;
        return Objects.equals(this.changeable, orderSlice.changeable) && Objects.equals(this.conditions, orderSlice.conditions) && Objects.equals(this.destination, orderSlice.destination) && Objects.equals((Object)this.destinationType, (Object)orderSlice.destinationType) && Objects.equals(this.duration, orderSlice.duration) && Objects.equals(this.id, orderSlice.id) && Objects.equals(this.origin, orderSlice.origin) && Objects.equals((Object)this.originType, (Object)orderSlice.originType) && Objects.equals(this.segments, orderSlice.segments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeable, this.conditions, this.destination, this.destinationType, this.duration, this.id, this.origin, this.originType, this.segments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderSlice {\n");
        sb.append("    changeable: ").append(this.toIndentedString(this.changeable)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinationType: ").append(this.toIndentedString((Object)this.destinationType)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originType: ").append(this.toIndentedString((Object)this.originType)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private DestinationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DestinationTypeEnum fromValue(String value) {
            for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OriginTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private OriginTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OriginTypeEnum fromValue(String value) {
            for (OriginTypeEnum b : OriginTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

