/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="An object containing metadata about the service, like the designator of the  seat. ")
@JsonPropertyOrder(value={"designator", "disclosures", "name"})
public class ServiceMetadataSeat {
    public static final String JSON_PROPERTY_DESIGNATOR = "designator";
    private String designator;
    public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
    private List<String> disclosures = new ArrayList<String>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public ServiceMetadataSeat designator(String designator) {
        this.designator = designator;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="14B", required=true, value="The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
    @JsonProperty(value="designator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDesignator() {
        return this.designator;
    }

    @JsonProperty(value="designator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDesignator(String designator) {
        this.designator = designator;
    }

    public ServiceMetadataSeat disclosures(List<String> disclosures) {
        this.disclosures = disclosures;
        return this;
    }

    public ServiceMetadataSeat addDisclosuresItem(String disclosuresItem) {
        this.disclosures.add(disclosuresItem);
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", required=true, value="Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
    @JsonProperty(value="disclosures")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getDisclosures() {
        return this.disclosures;
    }

    @JsonProperty(value="disclosures")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisclosures(List<String> disclosures) {
        this.disclosures = disclosures;
    }

    public ServiceMetadataSeat name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="Exit row seat", required=true, value="A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMetadataSeat serviceMetadataSeat = (ServiceMetadataSeat)o;
        return Objects.equals(this.designator, serviceMetadataSeat.designator) && Objects.equals(this.disclosures, serviceMetadataSeat.disclosures) && Objects.equals(this.name, serviceMetadataSeat.name);
    }

    public int hashCode() {
        return Objects.hash(this.designator, this.disclosures, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceMetadataSeat {\n");
        sb.append("    designator: ").append(this.toIndentedString(this.designator)).append("\n");
        sb.append("    disclosures: ").append(this.toIndentedString(this.disclosures)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

