package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.ConfirmOrderChange200Response;
import com.duffel.sdk.model.ConfirmOrderChangeRequest;
import com.duffel.sdk.model.CreateOfferRequestRequest;
import com.duffel.sdk.model.CreateOrderCancellation201Response;
import com.duffel.sdk.model.CreateOrderCancellationRequest;
import com.duffel.sdk.model.CreateOrderChangeRequest;
import com.duffel.sdk.model.CreateOrderChangeRequestRequest;
import com.duffel.sdk.model.CreateOrderRequest;
import com.duffel.sdk.model.CreatePayment201Response;
import com.duffel.sdk.model.CreatePaymentRequest;
import com.duffel.sdk.model.GetAirlineInitiatedChanges200Response;
import com.duffel.sdk.model.GetOfferById200Response;
import com.duffel.sdk.model.GetOfferRequestById200Response;
import com.duffel.sdk.model.GetOfferRequests200Response;
import com.duffel.sdk.model.GetOffers200Response;
import com.duffel.sdk.model.GetOrderById200Response;
import com.duffel.sdk.model.GetOrderCancellations200Response;
import com.duffel.sdk.model.GetOrderChangeOfferById200Response;
import com.duffel.sdk.model.GetOrderChangeOffersByOrderChangeRequestId200Response;
import com.duffel.sdk.model.GetOrderChangeRequestById200Response;
import com.duffel.sdk.model.GetOrders200Response;
import com.duffel.sdk.model.GetOrdersArrivingAtParameter;
import com.duffel.sdk.model.GetOrdersCreatedAtParameter;
import com.duffel.sdk.model.GetOrdersDepartingAtParameter;
import com.duffel.sdk.model.GetSeatMaps200Response;
import com.duffel.sdk.model.UpdateAirlineInitiatedChanges200Response;
import com.duffel.sdk.model.UpdateAirlineInitiatedChangesRequest;
import com.duffel.sdk.model.UpdateOfferPassengerById200Response;
import com.duffel.sdk.model.UpdateOfferPassengerByIdRequest;
import com.duffel.sdk.model.UpdateOrderByIdRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Accept the airline-initiated change
     * Once there is an airline-initiated change you can choose to accept it.
     * <p><b>200</b> - Airline-initiated Change has been accepted with airline
     * <p><b>202</b> - Airline-initiated Change acceptance is in progress
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec acceptAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling acceptAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes/{id}/actions/accept", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Accept the airline-initiated change
     * Once there is an airline-initiated change you can choose to accept it.
     * <p><b>200</b> - Airline-initiated Change has been accepted with airline
     * <p><b>202</b> - Airline-initiated Change acceptance is in progress
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateAirlineInitiatedChanges200Response> acceptAirlineInitiatedChanges(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return acceptAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateAirlineInitiatedChanges200Response>> acceptAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return acceptAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Confirm an order cancellation
     * Once you&#39;ve created a pending order cancellation, you&#39;ll know the &#x60;refund_amount&#x60; you&#39;re due to get back.  To actually cancel the order, you&#39;ll need to confirm the cancellation. The booking with the airline will be cancelled, and the &#x60;refund_amount&#x60; will be returned to the original payment method (i.e. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order cancellation object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order cancellation
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec confirmOrderCancellationRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling confirmOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling confirmOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling confirmOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return apiClient.invokeAPI("/air/order_cancellations/{id}/actions/confirm", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Confirm an order cancellation
     * Once you&#39;ve created a pending order cancellation, you&#39;ll know the &#x60;refund_amount&#x60; you&#39;re due to get back.  To actually cancel the order, you&#39;ll need to confirm the cancellation. The booking with the airline will be cancelled, and the &#x60;refund_amount&#x60; will be returned to the original payment method (i.e. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order cancellation object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order cancellation
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateOrderCancellation201Response> confirmOrderCancellation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return confirmOrderCancellationRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreateOrderCancellation201Response>> confirmOrderCancellationWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return confirmOrderCancellationRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Confirm an order change
     * Once you&#39;ve created a pending order change, you&#39;ll know the &#x60;change_total_amount&#x60; due for the change.  To actually change the order, you&#39;ll need to confirm the change. The booking with the airline will be updated with the new slice you previously chose, and the &#x60;change_total_amount&#x60; will be charged to your specific payment type.  If the amount of &#x60;change_total_amount&#x60; is negative, then this will be returned to the &#x60;refund_to&#x60; method (e.g. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order change object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param confirmOrderChangeRequest The confirmOrderChangeRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec confirmOrderChangeRequestCreation(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        Object postBody = confirmOrderChangeRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'confirmOrderChangeRequest' is set
        if (confirmOrderChangeRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'confirmOrderChangeRequest' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes/{id}/actions/confirm", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Confirm an order change
     * Once you&#39;ve created a pending order change, you&#39;ll know the &#x60;change_total_amount&#x60; due for the change.  To actually change the order, you&#39;ll need to confirm the change. The booking with the airline will be updated with the new slice you previously chose, and the &#x60;change_total_amount&#x60; will be charged to your specific payment type.  If the amount of &#x60;change_total_amount&#x60; is negative, then this will be returned to the &#x60;refund_to&#x60; method (e.g. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order change object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param confirmOrderChangeRequest The confirmOrderChangeRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> confirmOrderChange(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return confirmOrderChangeRequestCreation(accept, duffelVersion, id, confirmOrderChangeRequest, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> confirmOrderChangeWithHttpInfo(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return confirmOrderChangeRequestCreation(accept, duffelVersion, id, confirmOrderChangeRequest, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOfferRequestRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        Object postBody = createOfferRequestRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "return_offers", returnOffers));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "supplier_timeout", supplierTimeout));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> createOfferRequest(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, returnOffers, supplierTimeout, createOfferRequestRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> createOfferRequestWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, returnOffers, supplierTimeout, createOfferRequestRequest).toEntity(localVarReturnType);
    }
    /**
     * Create an order
     * Creates a booking with an airline based on an offer.  Orders are usually paid at the time of creation, but can be held and paid for at a later date if the offer supports it (see &#x60;offer.payment_requirements.requires_instant_payment&#x60;). To create an order and pay for it at the same time, specify a &#x60;payments&#x60; key. To hold the order and pay for it later, specify the type as &#x60;hold&#x60;, omit the &#x60;payments&#x60; and &#x60;services&#x60; keys, and complete payment after creating the order through the [Create a payment endpoint](/docs/api/payments/create-payment).  When presenting an order confirmation to your customers (e.g. on screen or in an email), you should include  the &#x60;booking_reference&#x60; and details of the full itinerary and show the full name of the operating carrier  of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;) in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5).  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                | | ---------- | ------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | | &#x60;payments&#x60; | &#x60;payments_not_allowed_for_order_type&#x60;            | You’ve included a &#x60;payments&#x60; key for a &#x60;hold&#x60; order, but the key should be omitted.                                                        | | &#x60;services&#x60; | &#x60;services_not_allowed_for_order_type&#x60;            | You’ve included &#x60;services&#x60; for a &#x60;hold&#x60; order, but they’re not currently supported.                                                        | | &#x60;type&#x60;     | &#x60;not_valid_with_selected_offer&#x60;                  | The type is not valid with selected offer because either &#x60;requires_instant_payment&#x60; is &#x60;true&#x60; or the &#x60;payment_required_by&#x60; is in the past. | 
     * <p><b>201</b> - An order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderRequest The createOrderRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderRequestCreation(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        Object postBody = createOrderRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createOrderRequest' is set
        if (createOrderRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createOrderRequest' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an order
     * Creates a booking with an airline based on an offer.  Orders are usually paid at the time of creation, but can be held and paid for at a later date if the offer supports it (see &#x60;offer.payment_requirements.requires_instant_payment&#x60;). To create an order and pay for it at the same time, specify a &#x60;payments&#x60; key. To hold the order and pay for it later, specify the type as &#x60;hold&#x60;, omit the &#x60;payments&#x60; and &#x60;services&#x60; keys, and complete payment after creating the order through the [Create a payment endpoint](/docs/api/payments/create-payment).  When presenting an order confirmation to your customers (e.g. on screen or in an email), you should include  the &#x60;booking_reference&#x60; and details of the full itinerary and show the full name of the operating carrier  of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;) in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5).  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                | | ---------- | ------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------ | | &#x60;payments&#x60; | &#x60;payments_not_allowed_for_order_type&#x60;            | You’ve included a &#x60;payments&#x60; key for a &#x60;hold&#x60; order, but the key should be omitted.                                                        | | &#x60;services&#x60; | &#x60;services_not_allowed_for_order_type&#x60;            | You’ve included &#x60;services&#x60; for a &#x60;hold&#x60; order, but they’re not currently supported.                                                        | | &#x60;type&#x60;     | &#x60;not_valid_with_selected_offer&#x60;                  | The type is not valid with selected offer because either &#x60;requires_instant_payment&#x60; is &#x60;true&#x60; or the &#x60;payment_required_by&#x60; is in the past. | 
     * <p><b>201</b> - An order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderRequest The createOrderRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> createOrder(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> createOrderWithHttpInfo(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).toEntity(localVarReturnType);
    }
    /**
     * Create a pending order cancellation
     * To begin the process of cancelling an order you need to create an order cancellation. The OrderCancellation will contain the &#x60;refund_amount&#x60; due from the Airline.  To proceed, you must confirm the cancellation using the [Confirm an order cancellation](/docs/api/order-cancellations/confirm-order-cancellation) endpoint.  
     * <p><b>201</b> - A pending order cancellation to be confirmed
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderCancellationRequest The createOrderCancellationRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderCancellationRequestCreation(String accept, String duffelVersion, CreateOrderCancellationRequest createOrderCancellationRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        Object postBody = createOrderCancellationRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createOrderCancellationRequest' is set
        if (createOrderCancellationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createOrderCancellationRequest' when calling createOrderCancellation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return apiClient.invokeAPI("/air/order_cancellations", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a pending order cancellation
     * To begin the process of cancelling an order you need to create an order cancellation. The OrderCancellation will contain the &#x60;refund_amount&#x60; due from the Airline.  To proceed, you must confirm the cancellation using the [Confirm an order cancellation](/docs/api/order-cancellations/confirm-order-cancellation) endpoint.  
     * <p><b>201</b> - A pending order cancellation to be confirmed
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createOrderCancellationRequest The createOrderCancellationRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateOrderCancellation201Response> createOrderCancellation(String accept, String duffelVersion, CreateOrderCancellationRequest createOrderCancellationRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return createOrderCancellationRequestCreation(accept, duffelVersion, createOrderCancellationRequest, acceptEncoding, contentType).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreateOrderCancellation201Response>> createOrderCancellationWithHttpInfo(String accept, String duffelVersion, CreateOrderCancellationRequest createOrderCancellationRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return createOrderCancellationRequestCreation(accept, duffelVersion, createOrderCancellationRequest, acceptEncoding, contentType).toEntity(localVarReturnType);
    }
    /**
     * Create a pending order change
     * To begin the process of changing an order you need to create an order change. The OrderChange will contain the &#x60;selected_order_change_offer&#x60; reference of the change you wish to make to your order.  To proceed, you must confirm the change using the [Confirm an order change](/docs/api/order-changes/confirm-order-change) endpoint.  
     * <p><b>201</b> - An order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequest The createOrderChangeRequest parameter
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderChangeRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        Object postBody = createOrderChangeRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a pending order change
     * To begin the process of changing an order you need to create an order change. The OrderChange will contain the &#x60;selected_order_change_offer&#x60; reference of the change you wish to make to your order.  To proceed, you must confirm the change using the [Confirm an order change](/docs/api/order-changes/confirm-order-change) endpoint.  
     * <p><b>201</b> - An order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequest The createOrderChangeRequest parameter
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> createOrderChange(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return createOrderChangeRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> createOrderChangeWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return createOrderChangeRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequest).toEntity(localVarReturnType);
    }
    /**
     * Create an order change request
     * To change flights on an existing paid order, you&#39;ll need to create an __order change request__. An order change request describes the slices you want to change and the details of where and when they want to travel (in the form of a list of __slices__). Any new slices will all need to use the same cabin class.  We&#39;ll send your search to the airline you originally booked with to search for __order_change_offers__. This list will be empty if no offers are available.   These can be viewed through the [Get a single order change offer](docs/api/order-change-offers/get-order-change-offer-by-id) endpoint.  Each offer represents a set of flights you can buy from the airline to add to your order at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>201</b> - An order change request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequestRequest The createOrderChangeRequestRequest parameter
     * @return GetOrderChangeRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderChangeRequestRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequestRequest createOrderChangeRequestRequest) throws WebClientResponseException {
        Object postBody = createOrderChangeRequestRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrderChangeRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrderChangeRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return apiClient.invokeAPI("/air/order_change_requests", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an order change request
     * To change flights on an existing paid order, you&#39;ll need to create an __order change request__. An order change request describes the slices you want to change and the details of where and when they want to travel (in the form of a list of __slices__). Any new slices will all need to use the same cabin class.  We&#39;ll send your search to the airline you originally booked with to search for __order_change_offers__. This list will be empty if no offers are available.   These can be viewed through the [Get a single order change offer](docs/api/order-change-offers/get-order-change-offer-by-id) endpoint.  Each offer represents a set of flights you can buy from the airline to add to your order at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>201</b> - An order change request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequestRequest The createOrderChangeRequestRequest parameter
     * @return GetOrderChangeRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeRequestById200Response> createOrderChangeRequest(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequestRequest createOrderChangeRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return createOrderChangeRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequestRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderChangeRequestById200Response>> createOrderChangeRequestWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequestRequest createOrderChangeRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return createOrderChangeRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequestRequest).toEntity(localVarReturnType);
    }
    /**
     * Create a partial offer request
     * To search for and select flights separately for each slice of the journey, you&#39;ll need to create a __partial offer request__. A partial offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__ for the first slice in your journey. Offers returned from a partial offer request will have the __partial__ flag set to &#x60;true&#x60;.  Each partial offer represents a set of flights you can buy from an airline at a particular price that meet the criteria of a slice in your search.  Inside the partial offer you&#39;ll see the slice it pertains to, and each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting partial offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPartialOfferRequestRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        Object postBody = createOfferRequestRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createPartialOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createPartialOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "supplier_timeout", supplierTimeout));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a partial offer request
     * To search for and select flights separately for each slice of the journey, you&#39;ll need to create a __partial offer request__. A partial offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__ for the first slice in your journey. Offers returned from a partial offer request will have the __partial__ flag set to &#x60;true&#x60;.  Each partial offer represents a set of flights you can buy from an airline at a particular price that meet the criteria of a slice in your search.  Inside the partial offer you&#39;ll see the slice it pertains to, and each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting partial offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> createPartialOfferRequest(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createPartialOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, supplierTimeout, createOfferRequestRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> createPartialOfferRequestWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createPartialOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, supplierTimeout, createOfferRequestRequest).toEntity(localVarReturnType);
    }
    /**
     * Create a payment
     * Creates a payment for a &#x60;hold&#x60; order. A &#x60;hold&#x60; order can be paid for up to the time limit indicated in &#x60;payment_required_by&#x60;, after which the space held for the order will be released and you will have to create a new order.  Before paying, you should always get the latest price by [retrieving the order](/docs/api/orders/get-order-by-id) to minimise the risk that the price you have is different from the latest price.  If the price for an order has changed from the time of booking and you pass in the old price, then you will get a validation error on the &#x60;amount&#x60; field with a &#x60;price_changed&#x60; code. The price of an order should only change if the order has no price guarantee or the price guarantee has expired (ie. &#x60;price_guaranteed_expires_at&#x60; is &#x60;null&#x60; or in the past).  If you receive a &#x60;500 Internal Server Error&#x60; when trying to create a payment for a &#x60;hold&#x60; order, it may have still been created on the airline’s side. Please contact Duffel support before trying the request again.  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                                    | | ---------- | ------------------------------------------       | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | | &#x60;order_id&#x60; | &#x60;order_type_not_eligible_for_payment&#x60;            | This order can&#39;t be paid for because it isn&#39;t a &#x60;hold&#x60; order. | &#x60;amount&#x60;   | &#x60;payment_amount_does_not_match_order_amount&#x60;     | The &#x60;amount&#x60; provided in the payment doesn&#39;t match the &#x60;total_amount&#x60; of the order.                                                                            | | &#x60;currency&#x60; | &#x60;payment_currency_does_not_match_order_currency&#x60; | The &#x60;currency&#x60; provided in the payment doesn&#39;t match the &#x60;total_currency&#x60; of the order.                                                                        |  ### Invalid states   This endpoint can return the following errors with a &#x60;type&#x60; of &#x60;invalid_state&#x60;, to indicate a reason that the order can&#39;t be paid for:  * &#x60;already_paid&#x60;: The order you’re paying for has already been paid for. * &#x60;already_cancelled&#x60;: The order you’re attempting to pay for has been cancelled. * &#x60;past_payment_required_by_date&#x60;: The order’s &#x60;payment_required_by&#x60; date has elapsed. * &#x60;schedule_changed&#x60;: You can&#39;t pay for this order because it has been changed in some way on the airline&#39;s side. You should start again, creating a new order. 
     * <p><b>201</b> - A payment
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createPaymentRequest The createPaymentRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreatePayment201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPaymentRequestCreation(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        Object postBody = createPaymentRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createPaymentRequest' is set
        if (createPaymentRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createPaymentRequest' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return apiClient.invokeAPI("/air/payments", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a payment
     * Creates a payment for a &#x60;hold&#x60; order. A &#x60;hold&#x60; order can be paid for up to the time limit indicated in &#x60;payment_required_by&#x60;, after which the space held for the order will be released and you will have to create a new order.  Before paying, you should always get the latest price by [retrieving the order](/docs/api/orders/get-order-by-id) to minimise the risk that the price you have is different from the latest price.  If the price for an order has changed from the time of booking and you pass in the old price, then you will get a validation error on the &#x60;amount&#x60; field with a &#x60;price_changed&#x60; code. The price of an order should only change if the order has no price guarantee or the price guarantee has expired (ie. &#x60;price_guaranteed_expires_at&#x60; is &#x60;null&#x60; or in the past).  If you receive a &#x60;500 Internal Server Error&#x60; when trying to create a payment for a &#x60;hold&#x60; order, it may have still been created on the airline’s side. Please contact Duffel support before trying the request again.  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                                    | | ---------- | ------------------------------------------       | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | | &#x60;order_id&#x60; | &#x60;order_type_not_eligible_for_payment&#x60;            | This order can&#39;t be paid for because it isn&#39;t a &#x60;hold&#x60; order. | &#x60;amount&#x60;   | &#x60;payment_amount_does_not_match_order_amount&#x60;     | The &#x60;amount&#x60; provided in the payment doesn&#39;t match the &#x60;total_amount&#x60; of the order.                                                                            | | &#x60;currency&#x60; | &#x60;payment_currency_does_not_match_order_currency&#x60; | The &#x60;currency&#x60; provided in the payment doesn&#39;t match the &#x60;total_currency&#x60; of the order.                                                                        |  ### Invalid states   This endpoint can return the following errors with a &#x60;type&#x60; of &#x60;invalid_state&#x60;, to indicate a reason that the order can&#39;t be paid for:  * &#x60;already_paid&#x60;: The order you’re paying for has already been paid for. * &#x60;already_cancelled&#x60;: The order you’re attempting to pay for has been cancelled. * &#x60;past_payment_required_by_date&#x60;: The order’s &#x60;payment_required_by&#x60; date has elapsed. * &#x60;schedule_changed&#x60;: You can&#39;t pay for this order because it has been changed in some way on the airline&#39;s side. You should start again, creating a new order. 
     * <p><b>201</b> - A payment
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createPaymentRequest The createPaymentRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreatePayment201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreatePayment201Response> createPayment(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return createPaymentRequestCreation(accept, duffelVersion, createPaymentRequest, acceptEncoding, contentType).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreatePayment201Response>> createPaymentWithHttpInfo(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return createPaymentRequestCreation(accept, duffelVersion, createPaymentRequest, acceptEncoding, contentType).toEntity(localVarReturnType);
    }
    /**
     * List airline-initiated changes
     * Retrieves a list of all airline-initiated changes.
     * <p><b>200</b> - A list of airline-initiated changes
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param orderId Filters airline-initiated changes by their order ID. Value must be a valid order ID. Check the [Order schema](/docs/api/orders/schema#orders-schema-id) for details. 
     * @return GetAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "order_id", orderId));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List airline-initiated changes
     * Retrieves a list of all airline-initiated changes.
     * <p><b>200</b> - A list of airline-initiated changes
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param orderId Filters airline-initiated changes by their order ID. Value must be a valid order ID. Check the [Order schema](/docs/api/orders/schema#orders-schema-id) for details. 
     * @return GetAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetAirlineInitiatedChanges200Response> getAirlineInitiatedChanges(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return getAirlineInitiatedChangesRequestCreation(accept, duffelVersion, acceptEncoding, orderId).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirlineInitiatedChanges200Response>> getAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineInitiatedChanges200Response>() {};
        return getAirlineInitiatedChangesRequestCreation(accept, duffelVersion, acceptEncoding, orderId).toEntity(localVarReturnType);
    }
    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return GetOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "return_available_services", returnAvailableServices));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return apiClient.invokeAPI("/air/offers/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return GetOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferById200Response> getOfferById(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferById200Response>> getOfferByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).toEntity(localVarReturnType);
    }
    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferRequestByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getOfferRequestById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> getOfferRequestByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetOfferRequests200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferRequestsRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetOfferRequests200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequests200Response> getOfferRequests(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return getOfferRequestsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequests200Response>> getOfferRequestsWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return getOfferRequestsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).toEntity(localVarReturnType);
    }
    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOffers200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOffersRequestCreation(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerRequestId' is set
        if (offerRequestId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerRequestId' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offer_request_id", offerRequestId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "max_connections", maxConnections));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return apiClient.invokeAPI("/air/offers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOffers200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOffers200Response> getOffers(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOffers200Response>> getOffersWithHttpInfo(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).toEntity(localVarReturnType);
    }
    /**
     * Get a single order
     * Retrieves an order by its ID
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order
     * Retrieves an order by its ID
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> getOrderById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> getOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Get a single order cancellation
     * Retrieves an order cancellation by its ID. 
     * <p><b>200</b> - An order cancellation object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order cancellation
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderCancellationByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderCancellationById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderCancellationById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderCancellationById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return apiClient.invokeAPI("/air/order_cancellations/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order cancellation
     * Retrieves an order cancellation by its ID. 
     * <p><b>200</b> - An order cancellation object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order cancellation
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return CreateOrderCancellation201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateOrderCancellation201Response> getOrderCancellationById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return getOrderCancellationByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreateOrderCancellation201Response>> getOrderCancellationByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<CreateOrderCancellation201Response> localVarReturnType = new ParameterizedTypeReference<CreateOrderCancellation201Response>() {};
        return getOrderCancellationByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List order cancellations
     * Retrieves a paginated list of order cancellations
     * <p><b>200</b> - A paginated list of order cancellations
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param orderId Filters the returned order cancellations by a specific order&#39;s unique identifier.
     * @return GetOrderCancellations200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderCancellationsRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String orderId) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderCancellations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderCancellations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "order_id", orderId));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderCancellations200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderCancellations200Response>() {};
        return apiClient.invokeAPI("/air/order_cancellations", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List order cancellations
     * Retrieves a paginated list of order cancellations
     * <p><b>200</b> - A paginated list of order cancellations
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param orderId Filters the returned order cancellations by a specific order&#39;s unique identifier.
     * @return GetOrderCancellations200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderCancellations200Response> getOrderCancellations(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderCancellations200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderCancellations200Response>() {};
        return getOrderCancellationsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, orderId).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderCancellations200Response>> getOrderCancellationsWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String orderId) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderCancellations200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderCancellations200Response>() {};
        return getOrderCancellationsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, orderId).toEntity(localVarReturnType);
    }
    /**
     * Get a single order change
     * Retrieves an order change by its ID
     * <p><b>200</b> - A single order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order change
     * Retrieves an order change by its ID
     * <p><b>200</b> - A single order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> getOrderChangeById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return getOrderChangeByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> getOrderChangeByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return getOrderChangeByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeOfferByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return apiClient.invokeAPI("/air/order_change_offers/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeOfferById200Response> getOrderChangeOfferById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return getOrderChangeOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderChangeOfferById200Response>> getOrderChangeOfferByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return getOrderChangeOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOrderChangeOffersByOrderChangeRequestId200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeOffersByOrderChangeRequestIdRequestCreation(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'orderChangeRequestId' is set
        if (orderChangeRequestId == null) {
            throw new WebClientResponseException("Missing the required parameter 'orderChangeRequestId' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "order_change_request_id", orderChangeRequestId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "max_connections", maxConnections));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return apiClient.invokeAPI("/air/order_change_offers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOrderChangeOffersByOrderChangeRequestId200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeOffersByOrderChangeRequestId200Response> getOrderChangeOffersByOrderChangeRequestId(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return getOrderChangeOffersByOrderChangeRequestIdRequestCreation(accept, duffelVersion, orderChangeRequestId, acceptEncoding, after, before, limit, sort, maxConnections).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderChangeOffersByOrderChangeRequestId200Response>> getOrderChangeOffersByOrderChangeRequestIdWithHttpInfo(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return getOrderChangeOffersByOrderChangeRequestIdRequestCreation(accept, duffelVersion, orderChangeRequestId, acceptEncoding, after, before, limit, sort, maxConnections).toEntity(localVarReturnType);
    }
    /**
     * Get a single order change request
     * Retrieves an order change request by its ID
     * <p><b>200</b> - A single order change request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeRequestByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderChangeRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return apiClient.invokeAPI("/air/order_change_requests/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order change request
     * Retrieves an order change request by its ID
     * <p><b>200</b> - A single order change request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeRequestById200Response> getOrderChangeRequestById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return getOrderChangeRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderChangeRequestById200Response>> getOrderChangeRequestByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeRequestById200Response>() {};
        return getOrderChangeRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * List orders
     * Retrieves a paginated list of all orders. The results may be returned in  any order, unless a sorting parameter is provided. 
     * <p><b>200</b> - A paginated list of orders
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param bookingReference Filters orders by their &#x60;booking reference&#x60;.  The filter requires an exact match but is case insensitive. 
     * @param awaitingPayment Whether to filter orders that are awaiting payment or not. If not specified, all orders regardless of their payment state will be returned. 
     * @param sort By default, orders aren&#39;t returned in any specific order. This parameter allows you to sort the list of orders by the &#x60;payment_required_by&#x60;, &#x60;total_amount&#x60;, &#x60;created_at&#x60;, or &#x60;next_departure&#x60;. If you wish to sort in descending order, a &#x60;-&#x60; prefix will be needed (e.g. &#x60;-payment_required_by&#x60;). When sorting by next departure (&#x60;next_departure&#x60;), flown orders will be last. 
     * @param ownerId Filters the returned orders by &#x60;owner.id&#x60;. Values must be valid &#x60;airline.id&#x60;s. Check the [Airline schema](/docs/api/airlines/schema#id) for details. 
     * @param originId Filters the returned orders by &#x60;origin&#x60;. Values must be valid origin identifiers. Check the [Order schema](/docs/api/orders#slices-origin-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param destinationId Filters the returned orders by &#x60;destination&#x60;. Values must be valid destination identifiers. Check the [Order schema](/docs/api/orders#slices-destination-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param departingAt Filters the returned orders by [departure datetime](/docs/api/orders/schema#slices-segments-departing_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param arrivingAt Filters the returned orders by [arrival datetime](/docs/api/orders/schema#slices-segments-arriving_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param createdAt Filters the returned orders by [creation datetime](docs/api/orders#created_at). 
     * @param passengerName Filters the returned orders by passengers&#39; &#x60;family_name&#x60; and &#x60;given_name&#x60;.  Orders will be included if **any** of their passengers matches **any** of the given names. Matches are case insensitive, and include partial matches.  For example, &#x60;?passenger_name[]&#x3D;roger&#x60; will return orders for both &#x60;Anna Rogers&#x60; and &#x60;Roger Smith&#x60;. 
     * @param requiresAction Orders will be included if they have any Airline-Inititated Changes that are unactioned. 
     * @return GetOrders200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrdersRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "booking_reference", bookingReference));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "awaiting_payment", awaitingPayment));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "owner_id[]", ownerId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "origin_id[]", originId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "destination_id[]", destinationId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "departing_at", departingAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "arriving_at", arrivingAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "created_at", createdAt));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "passenger_name[]", passengerName));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "requires_action", requiresAction));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return apiClient.invokeAPI("/air/orders", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List orders
     * Retrieves a paginated list of all orders. The results may be returned in  any order, unless a sorting parameter is provided. 
     * <p><b>200</b> - A paginated list of orders
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param bookingReference Filters orders by their &#x60;booking reference&#x60;.  The filter requires an exact match but is case insensitive. 
     * @param awaitingPayment Whether to filter orders that are awaiting payment or not. If not specified, all orders regardless of their payment state will be returned. 
     * @param sort By default, orders aren&#39;t returned in any specific order. This parameter allows you to sort the list of orders by the &#x60;payment_required_by&#x60;, &#x60;total_amount&#x60;, &#x60;created_at&#x60;, or &#x60;next_departure&#x60;. If you wish to sort in descending order, a &#x60;-&#x60; prefix will be needed (e.g. &#x60;-payment_required_by&#x60;). When sorting by next departure (&#x60;next_departure&#x60;), flown orders will be last. 
     * @param ownerId Filters the returned orders by &#x60;owner.id&#x60;. Values must be valid &#x60;airline.id&#x60;s. Check the [Airline schema](/docs/api/airlines/schema#id) for details. 
     * @param originId Filters the returned orders by &#x60;origin&#x60;. Values must be valid origin identifiers. Check the [Order schema](/docs/api/orders#slices-origin-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param destinationId Filters the returned orders by &#x60;destination&#x60;. Values must be valid destination identifiers. Check the [Order schema](/docs/api/orders#slices-destination-id) for details.  Orders will be included if **any** of their slices matches the given criteria. 
     * @param departingAt Filters the returned orders by [departure datetime](/docs/api/orders/schema#slices-segments-departing_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param arrivingAt Filters the returned orders by [arrival datetime](/docs/api/orders/schema#slices-segments-arriving_at). Orders will be included if **any** of their segments matches the given criteria. 
     * @param createdAt Filters the returned orders by [creation datetime](docs/api/orders#created_at). 
     * @param passengerName Filters the returned orders by passengers&#39; &#x60;family_name&#x60; and &#x60;given_name&#x60;.  Orders will be included if **any** of their passengers matches **any** of the given names. Matches are case insensitive, and include partial matches.  For example, &#x60;?passenger_name[]&#x3D;roger&#x60; will return orders for both &#x60;Anna Rogers&#x60; and &#x60;Roger Smith&#x60;. 
     * @param requiresAction Orders will be included if they have any Airline-Inititated Changes that are unactioned. 
     * @return GetOrders200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrders200Response> getOrders(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrders200Response>> getOrdersWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>() {};
        return getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).toEntity(localVarReturnType);
    }
    /**
     * Get a single partial offer request
     * Retrieves a partial offers request by its ID, only including partial offers for the current slice of multi-step search flow. 
     * <p><b>200</b> - A single partial offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected for previous slices. This parameter should be repeated for each selected partial offer.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getPartialOfferRequestByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getPartialOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "selected_partial_offer[]", selectedPartialOffer));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single partial offer request
     * Retrieves a partial offers request by its ID, only including partial offers for the current slice of multi-step search flow. 
     * <p><b>200</b> - A single partial offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected for previous slices. This parameter should be repeated for each selected partial offer.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getPartialOfferRequestById(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, selectedPartialOffer).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> getPartialOfferRequestByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, String selectedPartialOffer) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, selectedPartialOffer).toEntity(localVarReturnType);
    }
    /**
     * Get full offer fares for selected partial offers
     * Retrieves an offer request with offers for fares matching selected partial offers.
     * <p><b>200</b> - A single offer request with full offers for different fares matching selected itinerary in multi-step search flow.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected. This parameter should be repeated for each slice in the journey.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getPartialOfferRequestFaresByIdRequestCreation(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'selectedPartialOffer' is set
        if (selectedPartialOffer == null) {
            throw new WebClientResponseException("Missing the required parameter 'selectedPartialOffer' when calling getPartialOfferRequestFaresById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "selected_partial_offer[]", selectedPartialOffer));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/partial_offer_requests/{id}/fares", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get full offer fares for selected partial offers
     * Retrieves an offer request with offers for fares matching selected partial offers.
     * <p><b>200</b> - A single offer request with full offers for different fares matching selected itinerary in multi-step search flow.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the partial offer request
     * @param selectedPartialOffer Duffel&#39;s unqiue identifier for the partial offer selected. This parameter should be repeated for each slice in the journey.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getPartialOfferRequestFaresById(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestFaresByIdRequestCreation(accept, duffelVersion, id, selectedPartialOffer, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOfferRequestById200Response>> getPartialOfferRequestFaresByIdWithHttpInfo(String accept, String duffelVersion, String id, String selectedPartialOffer, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getPartialOfferRequestFaresByIdRequestCreation(accept, duffelVersion, id, selectedPartialOffer, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Get seat maps
     * Gets seat maps by specific parameters. At the moment we only  support querying by an offer ID.  A list of seat maps, one per segment, will be returned, which you can use  to build a seat selection UI for your customers. This is not available  for all airlines or flights, so seat maps will not always be returned.  If there are one or more passengers, you do not have to select a seat for  each one. Each passenger can only select one seat per segment. Two passengers  cannot select the same seat.  As with other services when creating an order, the total amount charged will be the cost of the offer and any selected services. 
     * <p><b>200</b> - A list of seat maps.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId The offer ID which you want to get seat maps for
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetSeatMaps200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getSeatMapsRequestCreation(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerId' is set
        if (offerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerId' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offer_id", offerId));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return apiClient.invokeAPI("/air/seat_maps", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get seat maps
     * Gets seat maps by specific parameters. At the moment we only  support querying by an offer ID.  A list of seat maps, one per segment, will be returned, which you can use  to build a seat selection UI for your customers. This is not available  for all airlines or flights, so seat maps will not always be returned.  If there are one or more passengers, you do not have to select a seat for  each one. Each passenger can only select one seat per segment. Two passengers  cannot select the same seat.  As with other services when creating an order, the total amount charged will be the cost of the offer and any selected services. 
     * <p><b>200</b> - A list of seat maps.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId The offer ID which you want to get seat maps for
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetSeatMaps200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetSeatMaps200Response> getSeatMaps(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return getSeatMapsRequestCreation(accept, duffelVersion, offerId, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetSeatMaps200Response>> getSeatMapsWithHttpInfo(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return getSeatMapsRequestCreation(accept, duffelVersion, offerId, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Update an airline-initiated change
     * This endpoint is only available to those airline-initiated changes that Duffel cannot accept on behalf of the customer. Duffel is unable to accept an airline-initiated change when these two conditions aretrue: the order was booked with the merchant&#39;s IATA number and Duffel is unable to accept the airline-initiated change programatically. In this case you, the customer, are responsible to resolve airline-initiated changes concerning this order (e.g. by contacting the airline directly). Once these have been resolved, you need to inform us of the action taken so we can mark it accordingly in our system.  
     * <p><b>200</b> - A single airline-initiated change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateAirlineInitiatedChangesRequest The updateAirlineInitiatedChangesRequest parameter
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAirlineInitiatedChangesRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        Object postBody = updateAirlineInitiatedChangesRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateAirlineInitiatedChanges", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return apiClient.invokeAPI("/air/airline_initiated_changes/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update an airline-initiated change
     * This endpoint is only available to those airline-initiated changes that Duffel cannot accept on behalf of the customer. Duffel is unable to accept an airline-initiated change when these two conditions aretrue: the order was booked with the merchant&#39;s IATA number and Duffel is unable to accept the airline-initiated change programatically. In this case you, the customer, are responsible to resolve airline-initiated changes concerning this order (e.g. by contacting the airline directly). Once these have been resolved, you need to inform us of the action taken so we can mark it accordingly in our system.  
     * <p><b>200</b> - A single airline-initiated change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the airline-initiated change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateAirlineInitiatedChangesRequest The updateAirlineInitiatedChangesRequest parameter
     * @return UpdateAirlineInitiatedChanges200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateAirlineInitiatedChanges200Response> updateAirlineInitiatedChanges(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return updateAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding, updateAirlineInitiatedChangesRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateAirlineInitiatedChanges200Response>> updateAirlineInitiatedChangesWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateAirlineInitiatedChangesRequest updateAirlineInitiatedChangesRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response> localVarReturnType = new ParameterizedTypeReference<UpdateAirlineInitiatedChanges200Response>() {};
        return updateAirlineInitiatedChangesRequestCreation(accept, duffelVersion, id, acceptEncoding, updateAirlineInitiatedChangesRequest).toEntity(localVarReturnType);
    }
    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return UpdateOfferPassengerById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateOfferPassengerByIdRequestCreation(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        Object postBody = updateOfferPassengerByIdRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerId' is set
        if (offerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerPassengerId' is set
        if (offerPassengerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerPassengerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("offer_id", offerId);
        pathParams.put("offer_passenger_id", offerPassengerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return apiClient.invokeAPI("/air/offers/{offer_id}/passengers/{offer_passenger_id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return UpdateOfferPassengerById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateOfferPassengerById200Response> updateOfferPassengerById(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateOfferPassengerById200Response>> updateOfferPassengerByIdWithHttpInfo(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).toEntity(localVarReturnType);
    }
    /**
     * Update a single order
     * Some order fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOrderByIdRequest The updateOrderByIdRequest parameter
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        Object postBody = updateOrderByIdRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return apiClient.invokeAPI("/air/orders/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a single order
     * Some order fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single order
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOrderByIdRequest The updateOrderByIdRequest parameter
     * @return GetOrderById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderById200Response> updateOrderById(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> updateOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>() {};
        return updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).toEntity(localVarReturnType);
    }
}
