package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.CreateWebhook201Response;
import com.duffel.sdk.model.CreateWebhookRequest;
import com.duffel.sdk.model.GetWebhook200Response;
import com.duffel.sdk.model.UpdateWebhook200Response;
import com.duffel.sdk.model.UpdateWebhookRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class NotificationsApi {
    private ApiClient apiClient;

    public NotificationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a webhook
     * To start receiving notifications of events, you&#39;ll need to create a webhook that details the  server that will receive the notifications. The webhook will be created in live mode or test mode based on the access token you&#39;re using. If you&#39;re using a test mode access token, the webhook will be created in test mode and will receive events related to test mode resources. If you&#39;re using a live mode access token, it&#39;ll receive events related to live mode.   Duffel only allows one webhook to be defined per live mode  value, basically your organisation can only have one url with &#x60;live_mode: true&#x60; and another with &#x60;live_mode: false&#x60;.  To ensure the highest level of security we run some checks on the URL we receive, the URL must be  for an https server, we do not accept IP addresses and some URLs are blacklisted (e.g. https://localhost).  By default, the webhook will be active. 
     * <p><b>201</b> - A webhook object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createWebhookRequest The createWebhookRequest parameter
     * @return CreateWebhook201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createWebhookRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateWebhookRequest createWebhookRequest) throws WebClientResponseException {
        Object postBody = createWebhookRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreateWebhook201Response> localVarReturnType = new ParameterizedTypeReference<CreateWebhook201Response>() {};
        return apiClient.invokeAPI("/air/webhooks", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a webhook
     * To start receiving notifications of events, you&#39;ll need to create a webhook that details the  server that will receive the notifications. The webhook will be created in live mode or test mode based on the access token you&#39;re using. If you&#39;re using a test mode access token, the webhook will be created in test mode and will receive events related to test mode resources. If you&#39;re using a live mode access token, it&#39;ll receive events related to live mode.   Duffel only allows one webhook to be defined per live mode  value, basically your organisation can only have one url with &#x60;live_mode: true&#x60; and another with &#x60;live_mode: false&#x60;.  To ensure the highest level of security we run some checks on the URL we receive, the URL must be  for an https server, we do not accept IP addresses and some URLs are blacklisted (e.g. https://localhost).  By default, the webhook will be active. 
     * <p><b>201</b> - A webhook object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createWebhookRequest The createWebhookRequest parameter
     * @return CreateWebhook201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateWebhook201Response> createWebhook(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateWebhookRequest createWebhookRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreateWebhook201Response> localVarReturnType = new ParameterizedTypeReference<CreateWebhook201Response>() {};
        return createWebhookRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createWebhookRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreateWebhook201Response>> createWebhookWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateWebhookRequest createWebhookRequest) throws WebClientResponseException {
        ParameterizedTypeReference<CreateWebhook201Response> localVarReturnType = new ParameterizedTypeReference<CreateWebhook201Response>() {};
        return createWebhookRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createWebhookRequest).toEntity(localVarReturnType);
    }
    /**
     * List webhooks
     * Retrieve a paginated list of webhooks
     * <p><b>200</b> - A paginated list of webhooks
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetWebhook200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getWebhookRequestCreation(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetWebhook200Response> localVarReturnType = new ParameterizedTypeReference<GetWebhook200Response>() {};
        return apiClient.invokeAPI("/air/webhooks", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List webhooks
     * Retrieve a paginated list of webhooks
     * <p><b>200</b> - A paginated list of webhooks
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetWebhook200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetWebhook200Response> getWebhook(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetWebhook200Response> localVarReturnType = new ParameterizedTypeReference<GetWebhook200Response>() {};
        return getWebhookRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetWebhook200Response>> getWebhookWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetWebhook200Response> localVarReturnType = new ParameterizedTypeReference<GetWebhook200Response>() {};
        return getWebhookRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).toEntity(localVarReturnType);
    }
    /**
     * Ping a webhook
     * Send a ping, a \&quot;fake event\&quot; notification, to a webhook
     * <p><b>204</b> - Ping sent to webhook
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the webhook
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec pingWebhookRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling pingWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling pingWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling pingWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/air/webhooks/{id}/actions/ping", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ping a webhook
     * Send a ping, a \&quot;fake event\&quot; notification, to a webhook
     * <p><b>204</b> - Ping sent to webhook
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the webhook
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> pingWebhook(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return pingWebhookRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> pingWebhookWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return pingWebhookRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Update a webhook
     * Update a webhook
     * <p><b>200</b> - A webhook object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the webhook
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateWebhookRequest The updateWebhookRequest parameter
     * @return UpdateWebhook200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateWebhookRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateWebhookRequest updateWebhookRequest) throws WebClientResponseException {
        Object postBody = updateWebhookRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<UpdateWebhook200Response> localVarReturnType = new ParameterizedTypeReference<UpdateWebhook200Response>() {};
        return apiClient.invokeAPI("/air/webhooks/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a webhook
     * Update a webhook
     * <p><b>200</b> - A webhook object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the webhook
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateWebhookRequest The updateWebhookRequest parameter
     * @return UpdateWebhook200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateWebhook200Response> updateWebhook(String accept, String duffelVersion, String id, String acceptEncoding, UpdateWebhookRequest updateWebhookRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateWebhook200Response> localVarReturnType = new ParameterizedTypeReference<UpdateWebhook200Response>() {};
        return updateWebhookRequestCreation(accept, duffelVersion, id, acceptEncoding, updateWebhookRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateWebhook200Response>> updateWebhookWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateWebhookRequest updateWebhookRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateWebhook200Response> localVarReturnType = new ParameterizedTypeReference<UpdateWebhook200Response>() {};
        return updateWebhookRequestCreation(accept, duffelVersion, id, acceptEncoding, updateWebhookRequest).toEntity(localVarReturnType);
    }
}
