package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.CreatePayment201Response;
import com.duffel.sdk.model.CreatePaymentRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class PaymentsApi {
    private ApiClient apiClient;

    public PaymentsApi() {
        this(new ApiClient());
    }

    @Autowired
    public PaymentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a payment
     * Creates a payment for a &#x60;hold&#x60; order. A &#x60;hold&#x60; order can be paid for up to the time limit indicated in &#x60;payment_required_by&#x60;, after which the space held for the order will be released and you will have to create a new order.  Before paying, you should always get the latest price by [retrieving the order](/docs/api/orders/get-order-by-id) to minimise the risk that the price you have is different from the latest price.  If the price for an order has changed from the time of booking and you pass in the old price, then you will get a validation error on the &#x60;amount&#x60; field with a &#x60;price_changed&#x60; code. The price of an order should only change if the order has no price guarantee or the price guarantee has expired (ie. &#x60;price_guaranteed_expires_at&#x60; is &#x60;null&#x60; or in the past).  If you receive a &#x60;500 Internal Server Error&#x60; when trying to create a payment for a &#x60;hold&#x60; order, it may have still been created on the airline’s side. Please contact Duffel support before trying the request again.  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                                    | | ---------- | ------------------------------------------       | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | | &#x60;order_id&#x60; | &#x60;order_type_not_eligible_for_payment&#x60;            | This order can&#39;t be paid for because it isn&#39;t a &#x60;hold&#x60; order. | &#x60;amount&#x60;   | &#x60;payment_amount_does_not_match_order_amount&#x60;     | The &#x60;amount&#x60; provided in the payment doesn&#39;t match the &#x60;total_amount&#x60; of the order.                                                                            | | &#x60;currency&#x60; | &#x60;payment_currency_does_not_match_order_currency&#x60; | The &#x60;currency&#x60; provided in the payment doesn&#39;t match the &#x60;total_currency&#x60; of the order.                                                                        |  ### Invalid states   This endpoint can return the following errors with a &#x60;type&#x60; of &#x60;invalid_state&#x60;, to indicate a reason that the order can&#39;t be paid for:  * &#x60;already_paid&#x60;: The order you’re paying for has already been paid for. * &#x60;already_cancelled&#x60;: The order you’re attempting to pay for has been cancelled. * &#x60;past_payment_required_by_date&#x60;: The order’s &#x60;payment_required_by&#x60; date has elapsed. * &#x60;schedule_changed&#x60;: You can&#39;t pay for this order because it has been changed in some way on the airline&#39;s side. You should start again, creating a new order. 
     * <p><b>201</b> - A payment
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createPaymentRequest The createPaymentRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreatePayment201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPaymentRequestCreation(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        Object postBody = createPaymentRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createPaymentRequest' is set
        if (createPaymentRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createPaymentRequest' when calling createPayment", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return apiClient.invokeAPI("/air/payments", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a payment
     * Creates a payment for a &#x60;hold&#x60; order. A &#x60;hold&#x60; order can be paid for up to the time limit indicated in &#x60;payment_required_by&#x60;, after which the space held for the order will be released and you will have to create a new order.  Before paying, you should always get the latest price by [retrieving the order](/docs/api/orders/get-order-by-id) to minimise the risk that the price you have is different from the latest price.  If the price for an order has changed from the time of booking and you pass in the old price, then you will get a validation error on the &#x60;amount&#x60; field with a &#x60;price_changed&#x60; code. The price of an order should only change if the order has no price guarantee or the price guarantee has expired (ie. &#x60;price_guaranteed_expires_at&#x60; is &#x60;null&#x60; or in the past).  If you receive a &#x60;500 Internal Server Error&#x60; when trying to create a payment for a &#x60;hold&#x60; order, it may have still been created on the airline’s side. Please contact Duffel support before trying the request again.  ### Validation errors  | Field      | Code                                             | Description                                                                                                                                                    | | ---------- | ------------------------------------------       | -------------------------------------------------------------------------------------------------------------------------------------------------------------- | | &#x60;order_id&#x60; | &#x60;order_type_not_eligible_for_payment&#x60;            | This order can&#39;t be paid for because it isn&#39;t a &#x60;hold&#x60; order. | &#x60;amount&#x60;   | &#x60;payment_amount_does_not_match_order_amount&#x60;     | The &#x60;amount&#x60; provided in the payment doesn&#39;t match the &#x60;total_amount&#x60; of the order.                                                                            | | &#x60;currency&#x60; | &#x60;payment_currency_does_not_match_order_currency&#x60; | The &#x60;currency&#x60; provided in the payment doesn&#39;t match the &#x60;total_currency&#x60; of the order.                                                                        |  ### Invalid states   This endpoint can return the following errors with a &#x60;type&#x60; of &#x60;invalid_state&#x60;, to indicate a reason that the order can&#39;t be paid for:  * &#x60;already_paid&#x60;: The order you’re paying for has already been paid for. * &#x60;already_cancelled&#x60;: The order you’re attempting to pay for has been cancelled. * &#x60;past_payment_required_by_date&#x60;: The order’s &#x60;payment_required_by&#x60; date has elapsed. * &#x60;schedule_changed&#x60;: You can&#39;t pay for this order because it has been changed in some way on the airline&#39;s side. You should start again, creating a new order. 
     * <p><b>201</b> - A payment
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param createPaymentRequest The createPaymentRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @return CreatePayment201Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreatePayment201Response> createPayment(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return createPaymentRequestCreation(accept, duffelVersion, createPaymentRequest, acceptEncoding, contentType).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CreatePayment201Response>> createPaymentWithHttpInfo(String accept, String duffelVersion, CreatePaymentRequest createPaymentRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<CreatePayment201Response> localVarReturnType = new ParameterizedTypeReference<CreatePayment201Response>() {};
        return createPaymentRequestCreation(accept, duffelVersion, createPaymentRequest, acceptEncoding, contentType).toEntity(localVarReturnType);
    }
}
