/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The metropolitan area where the airport is located. Only present for airports which are registered with IATA as belonging to a [metropolitan area](https://portal.iata.org/faq/articles/en_US/FAQ/How-do-I-create-a-new-Metropolitan-Area).
 */
@ApiModel(description = "The metropolitan area where the airport is located. Only present for airports which are registered with IATA as belonging to a [metropolitan area](https://portal.iata.org/faq/articles/en_US/FAQ/How-do-I-create-a-new-Metropolitan-Area).")
@JsonPropertyOrder({
  City.JSON_PROPERTY_IATA_CODE,
  City.JSON_PROPERTY_IATA_COUNTRY_CODE,
  City.JSON_PROPERTY_ID,
  City.JSON_PROPERTY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class City {
  public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
  private String iataCode;

  public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
  private String iataCountryCode;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public City() { 
  }

  public City iataCode(String iataCode) {
    
    this.iataCode = iataCode;
    return this;
  }

   /**
   * The three-character IATA code for the city
   * @return iataCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LON", value = "The three-character IATA code for the city")
  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCode() {
    return iataCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCode(String iataCode) {
    this.iataCode = iataCode;
  }


  public City iataCountryCode(String iataCountryCode) {
    
    this.iataCountryCode = iataCountryCode;
    return this;
  }

   /**
   * The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the city is located
   * @return iataCountryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GB", value = "The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the city is located")
  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCountryCode() {
    return iataCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCountryCode(String iataCountryCode) {
    this.iataCountryCode = iataCountryCode;
  }


  public City id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the city
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cit_lon_gb", value = "Duffel's unique identifier for the city")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public City name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the city
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "London", value = "The name of the city")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    City city = (City) o;
    return Objects.equals(this.iataCode, city.iataCode) &&
        Objects.equals(this.iataCountryCode, city.iataCountryCode) &&
        Objects.equals(this.id, city.id) &&
        Objects.equals(this.name, city.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(iataCode, iataCountryCode, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class City {\n");
    sb.append("    iataCode: ").append(toIndentedString(iataCode)).append("\n");
    sb.append("    iataCountryCode: ").append(toIndentedString(iataCountryCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

