/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The inclusive time range for the departure of the slice
 */
@ApiModel(description = "The inclusive time range for the departure of the slice")
@JsonPropertyOrder({
  DepartureTime.JSON_PROPERTY_FROM,
  DepartureTime.JSON_PROPERTY_TO
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class DepartureTime {
  public static final String JSON_PROPERTY_FROM = "from";
  private JsonNullable<String> from = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TO = "to";
  private JsonNullable<String> to = JsonNullable.<String>undefined();

  public DepartureTime() { 
  }

  public DepartureTime from(String from) {
    this.from = JsonNullable.<String>of(from);
    
    return this;
  }

   /**
   * The local time in the format &#x60;hh:mm&#x60; of the origin airport at or after which the slice should depart. Defaults to current time at airport when only &#x60;to&#x60; is provided or &#x60;from&#x60; value is in the past
   * @return from
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "09:45", value = "The local time in the format `hh:mm` of the origin airport at or after which the slice should depart. Defaults to current time at airport when only `to` is provided or `from` value is in the past")
  @JsonIgnore

  public String getFrom() {
        return from.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFrom_JsonNullable() {
    return from;
  }
  
  @JsonProperty(JSON_PROPERTY_FROM)
  public void setFrom_JsonNullable(JsonNullable<String> from) {
    this.from = from;
  }

  public void setFrom(String from) {
    this.from = JsonNullable.<String>of(from);
  }


  public DepartureTime to(String to) {
    this.to = JsonNullable.<String>of(to);
    
    return this;
  }

   /**
   * The local time in the format &#x60;hh:mm&#x60; of the origin airport at or before which the slice should depart. Defaults to &#x60;23:59&#x60; when only &#x60;from&#x60; is provided
   * @return to
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "17:00", value = "The local time in the format `hh:mm` of the origin airport at or before which the slice should depart. Defaults to `23:59` when only `from` is provided")
  @JsonIgnore

  public String getTo() {
        return to.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTo_JsonNullable() {
    return to;
  }
  
  @JsonProperty(JSON_PROPERTY_TO)
  public void setTo_JsonNullable(JsonNullable<String> to) {
    this.to = to;
  }

  public void setTo(String to) {
    this.to = JsonNullable.<String>of(to);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DepartureTime departureTime = (DepartureTime) o;
    return equalsNullable(this.from, departureTime.from) &&
        equalsNullable(this.to, departureTime.to);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(from), hashCodeNullable(to));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DepartureTime {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

