/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A passenger specified by their type
 */
@ApiModel(description = "A passenger specified by their type")
@JsonPropertyOrder({
  OfferRequestBodyPassengerWithType.JSON_PROPERTY_FAMILY_NAME,
  OfferRequestBodyPassengerWithType.JSON_PROPERTY_GIVEN_NAME,
  OfferRequestBodyPassengerWithType.JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS,
  OfferRequestBodyPassengerWithType.JSON_PROPERTY_TYPE
})
@JsonTypeName("Offer_Request_Body_Passenger_With_Type")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OfferRequestBodyPassengerWithType {
  public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
  private String familyName;

  public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
  private String givenName;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
  private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = null;

  /**
   * The type of the passenger. If the passenger is aged 18 or over, you should specify a &#x60;type&#x60; of &#x60;adult&#x60;. If a passenger is aged under 18, you should specify their &#x60;age&#x60; instead of a &#x60;type&#x60;. A passenger can have only a type or an age, but not both.
   */
  public enum TypeEnum {
    ADULT("adult"),
    
    CHILD("child"),
    
    INFANT_WITHOUT_SEAT("infant_without_seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OfferRequestBodyPassengerWithType() { 
  }

  public OfferRequestBodyPassengerWithType familyName(String familyName) {
    
    this.familyName = familyName;
    return this;
  }

   /**
   * The passenger&#39;s family name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you&#39;re also including __Loyalty Programme Accounts__. 
   * @return familyName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Earhart", value = "The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFamilyName() {
    return familyName;
  }


  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFamilyName(String familyName) {
    this.familyName = familyName;
  }


  public OfferRequestBodyPassengerWithType givenName(String givenName) {
    
    this.givenName = givenName;
    return this;
  }

   /**
   * The passenger&#39;s given name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you&#39;re also including __Loyalty Programme Accounts__. 
   * @return givenName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Amelia", value = "The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGivenName() {
    return givenName;
  }


  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGivenName(String givenName) {
    this.givenName = givenName;
  }


  public OfferRequestBodyPassengerWithType loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    return this;
  }

  public OfferRequestBodyPassengerWithType addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
    if (this.loyaltyProgrammeAccounts == null) {
      this.loyaltyProgrammeAccounts = new ArrayList<>();
    }
    this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
    return this;
  }

   /**
   * The __Loyalty Programme Accounts__ for this passenger
   * @return loyaltyProgrammeAccounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The __Loyalty Programme Accounts__ for this passenger")
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
    return loyaltyProgrammeAccounts;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
  }


  public OfferRequestBodyPassengerWithType type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the passenger. If the passenger is aged 18 or over, you should specify a &#x60;type&#x60; of &#x60;adult&#x60;. If a passenger is aged under 18, you should specify their &#x60;age&#x60; instead of a &#x60;type&#x60;. A passenger can have only a type or an age, but not both.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "adult", required = true, value = "The type of the passenger. If the passenger is aged 18 or over, you should specify a `type` of `adult`. If a passenger is aged under 18, you should specify their `age` instead of a `type`. A passenger can have only a type or an age, but not both.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestBodyPassengerWithType offerRequestBodyPassengerWithType = (OfferRequestBodyPassengerWithType) o;
    return Objects.equals(this.familyName, offerRequestBodyPassengerWithType.familyName) &&
        Objects.equals(this.givenName, offerRequestBodyPassengerWithType.givenName) &&
        Objects.equals(this.loyaltyProgrammeAccounts, offerRequestBodyPassengerWithType.loyaltyProgrammeAccounts) &&
        Objects.equals(this.type, offerRequestBodyPassengerWithType.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(familyName, givenName, loyaltyProgrammeAccounts, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestBodyPassengerWithType {\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    loyaltyProgrammeAccounts: ").append(toIndentedString(loyaltyProgrammeAccounts)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

