/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.ArrivalTime;
import com.duffel.sdk.model.DepartureTime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferRequestBodySlice
 */
@JsonPropertyOrder({
  OfferRequestBodySlice.JSON_PROPERTY_ARRIVAL_TIME,
  OfferRequestBodySlice.JSON_PROPERTY_DEPARTURE_DATE,
  OfferRequestBodySlice.JSON_PROPERTY_DEPARTURE_TIME,
  OfferRequestBodySlice.JSON_PROPERTY_DESTINATION,
  OfferRequestBodySlice.JSON_PROPERTY_ORIGIN
})
@JsonTypeName("Offer_Request_Body_Slice")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OfferRequestBodySlice {
  public static final String JSON_PROPERTY_ARRIVAL_TIME = "arrival_time";
  private JsonNullable<ArrivalTime> arrivalTime = JsonNullable.<ArrivalTime>undefined();

  public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
  private LocalDate departureDate;

  public static final String JSON_PROPERTY_DEPARTURE_TIME = "departure_time";
  private JsonNullable<DepartureTime> departureTime = JsonNullable.<DepartureTime>undefined();

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private String destination;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private String origin;

  public OfferRequestBodySlice() { 
  }

  public OfferRequestBodySlice arrivalTime(ArrivalTime arrivalTime) {
    this.arrivalTime = JsonNullable.<ArrivalTime>of(arrivalTime);
    
    return this;
  }

   /**
   * Get arrivalTime
   * @return arrivalTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public ArrivalTime getArrivalTime() {
        return arrivalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ARRIVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<ArrivalTime> getArrivalTime_JsonNullable() {
    return arrivalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_ARRIVAL_TIME)
  public void setArrivalTime_JsonNullable(JsonNullable<ArrivalTime> arrivalTime) {
    this.arrivalTime = arrivalTime;
  }

  public void setArrivalTime(ArrivalTime arrivalTime) {
    this.arrivalTime = JsonNullable.<ArrivalTime>of(arrivalTime);
  }


  public OfferRequestBodySlice departureDate(LocalDate departureDate) {
    
    this.departureDate = departureDate;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart
   * @return departureDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "Fri Apr 24 07:00:00 ICT 2020", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getDepartureDate() {
    return departureDate;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDepartureDate(LocalDate departureDate) {
    this.departureDate = departureDate;
  }


  public OfferRequestBodySlice departureTime(DepartureTime departureTime) {
    this.departureTime = JsonNullable.<DepartureTime>of(departureTime);
    
    return this;
  }

   /**
   * Get departureTime
   * @return departureTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public DepartureTime getDepartureTime() {
        return departureTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPARTURE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<DepartureTime> getDepartureTime_JsonNullable() {
    return departureTime;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPARTURE_TIME)
  public void setDepartureTime_JsonNullable(JsonNullable<DepartureTime> departureTime) {
    this.departureTime = departureTime;
  }

  public void setDepartureTime(DepartureTime departureTime) {
    this.departureTime = JsonNullable.<DepartureTime>of(departureTime);
  }


  public OfferRequestBodySlice destination(String destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * The 3-letter IATA code for the city or airport where this slice ends
   * @return destination
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "JFK", required = true, value = "The 3-letter IATA code for the city or airport where this slice ends")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestination(String destination) {
    this.destination = destination;
  }


  public OfferRequestBodySlice origin(String origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * The 3-letter IATA code for the city or airport where this slice starts
   * @return origin
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "LHR", required = true, value = "The 3-letter IATA code for the city or airport where this slice starts")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrigin(String origin) {
    this.origin = origin;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestBodySlice offerRequestBodySlice = (OfferRequestBodySlice) o;
    return equalsNullable(this.arrivalTime, offerRequestBodySlice.arrivalTime) &&
        Objects.equals(this.departureDate, offerRequestBodySlice.departureDate) &&
        equalsNullable(this.departureTime, offerRequestBodySlice.departureTime) &&
        Objects.equals(this.destination, offerRequestBodySlice.destination) &&
        Objects.equals(this.origin, offerRequestBodySlice.origin);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(arrivalTime), departureDate, hashCodeNullable(departureTime), destination, origin);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestBodySlice {\n");
    sb.append("    arrivalTime: ").append(toIndentedString(arrivalTime)).append("\n");
    sb.append("    departureDate: ").append(toIndentedString(departureDate)).append("\n");
    sb.append("    departureTime: ").append(toIndentedString(departureTime)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

