/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferRequestSliceDestination;
import com.duffel.sdk.model.OfferRequestSliceOrigin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferRequestSlice
 */
@JsonPropertyOrder({
  OfferRequestSlice.JSON_PROPERTY_DEPARTURE_DATE,
  OfferRequestSlice.JSON_PROPERTY_DESTINATION,
  OfferRequestSlice.JSON_PROPERTY_DESTINATION_TYPE,
  OfferRequestSlice.JSON_PROPERTY_ORIGIN,
  OfferRequestSlice.JSON_PROPERTY_ORIGIN_TYPE
})
@JsonTypeName("Offer_Request_Slice")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OfferRequestSlice {
  public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
  private LocalDate departureDate;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private OfferRequestSliceDestination destination;

  /**
   * The type of the destination
   */
  public enum DestinationTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    DestinationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DestinationTypeEnum fromValue(String value) {
      for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
  private DestinationTypeEnum destinationType;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private OfferRequestSliceOrigin origin;

  /**
   * The type of the origin
   */
  public enum OriginTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    OriginTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OriginTypeEnum fromValue(String value) {
      for (OriginTypeEnum b : OriginTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
  private OriginTypeEnum originType;

  public OfferRequestSlice() { 
  }

  public OfferRequestSlice departureDate(LocalDate departureDate) {
    
    this.departureDate = departureDate;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart
   * @return departureDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Apr 24 07:00:00 ICT 2020", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDepartureDate() {
    return departureDate;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDate(LocalDate departureDate) {
    this.departureDate = departureDate;
  }


  public OfferRequestSlice destination(OfferRequestSliceDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferRequestSliceDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(OfferRequestSliceDestination destination) {
    this.destination = destination;
  }


  public OfferRequestSlice destinationType(DestinationTypeEnum destinationType) {
    
    this.destinationType = destinationType;
    return this;
  }

   /**
   * The type of the destination
   * @return destinationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "airport", value = "The type of the destination")
  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DestinationTypeEnum getDestinationType() {
    return destinationType;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationType(DestinationTypeEnum destinationType) {
    this.destinationType = destinationType;
  }


  public OfferRequestSlice origin(OfferRequestSliceOrigin origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferRequestSliceOrigin getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(OfferRequestSliceOrigin origin) {
    this.origin = origin;
  }


  public OfferRequestSlice originType(OriginTypeEnum originType) {
    
    this.originType = originType;
    return this;
  }

   /**
   * The type of the origin
   * @return originType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "airport", value = "The type of the origin")
  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OriginTypeEnum getOriginType() {
    return originType;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginType(OriginTypeEnum originType) {
    this.originType = originType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestSlice offerRequestSlice = (OfferRequestSlice) o;
    return Objects.equals(this.departureDate, offerRequestSlice.departureDate) &&
        Objects.equals(this.destination, offerRequestSlice.destination) &&
        Objects.equals(this.destinationType, offerRequestSlice.destinationType) &&
        Objects.equals(this.origin, offerRequestSlice.origin) &&
        Objects.equals(this.originType, offerRequestSlice.originType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(departureDate, destination, destinationType, origin, originType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestSlice {\n");
    sb.append("    departureDate: ").append(toIndentedString(departureDate)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationType: ").append(toIndentedString(destinationType)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originType: ").append(toIndentedString(originType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

