/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The search criteria for a slice to be added
 */
@ApiModel(description = "The search criteria for a slice to be added")
@JsonPropertyOrder({
  OrderChangeRequestBodySlicesAddInner.JSON_PROPERTY_CABIN_CLASS,
  OrderChangeRequestBodySlicesAddInner.JSON_PROPERTY_DEPARTURE_DATE,
  OrderChangeRequestBodySlicesAddInner.JSON_PROPERTY_DESTINATION,
  OrderChangeRequestBodySlicesAddInner.JSON_PROPERTY_ORIGIN
})
@JsonTypeName("Order_Change_Request_Body_slices_add_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OrderChangeRequestBodySlicesAddInner {
  /**
   * The cabin that the passengers want to travel in
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private CabinClassEnum cabinClass;

  public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
  private LocalDate departureDate;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private String destination;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private String origin;

  public OrderChangeRequestBodySlicesAddInner() { 
  }

  public OrderChangeRequestBodySlicesAddInner cabinClass(CabinClassEnum cabinClass) {
    
    this.cabinClass = cabinClass;
    return this;
  }

   /**
   * The cabin that the passengers want to travel in
   * @return cabinClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "economy", value = "The cabin that the passengers want to travel in")
  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CabinClassEnum getCabinClass() {
    return cabinClass;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = cabinClass;
  }


  public OrderChangeRequestBodySlicesAddInner departureDate(LocalDate departureDate) {
    
    this.departureDate = departureDate;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart
   * @return departureDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Apr 24 07:00:00 ICT 2020", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDepartureDate() {
    return departureDate;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDate(LocalDate departureDate) {
    this.departureDate = departureDate;
  }


  public OrderChangeRequestBodySlicesAddInner destination(String destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * The 3-letter IATA code for the city or airport where this slice ends
   * @return destination
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "JFK", value = "The 3-letter IATA code for the city or airport where this slice ends")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(String destination) {
    this.destination = destination;
  }


  public OrderChangeRequestBodySlicesAddInner origin(String origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * The 3-letter IATA code for the city or airport where this slice starts
   * @return origin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LHR", value = "The 3-letter IATA code for the city or airport where this slice starts")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(String origin) {
    this.origin = origin;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChangeRequestBodySlicesAddInner orderChangeRequestBodySlicesAddInner = (OrderChangeRequestBodySlicesAddInner) o;
    return Objects.equals(this.cabinClass, orderChangeRequestBodySlicesAddInner.cabinClass) &&
        Objects.equals(this.departureDate, orderChangeRequestBodySlicesAddInner.departureDate) &&
        Objects.equals(this.destination, orderChangeRequestBodySlicesAddInner.destination) &&
        Objects.equals(this.origin, orderChangeRequestBodySlicesAddInner.origin);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cabinClass, departureDate, destination, origin);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChangeRequestBodySlicesAddInner {\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    departureDate: ").append(toIndentedString(departureDate)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

