/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderServiceMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderService
 */
@JsonPropertyOrder({
  OrderService.JSON_PROPERTY_ID,
  OrderService.JSON_PROPERTY_METADATA,
  OrderService.JSON_PROPERTY_PASSENGER_IDS,
  OrderService.JSON_PROPERTY_QUANTITY,
  OrderService.JSON_PROPERTY_SEGMENT_IDS,
  OrderService.JSON_PROPERTY_TOTAL_AMOUNT,
  OrderService.JSON_PROPERTY_TOTAL_CURRENCY,
  OrderService.JSON_PROPERTY_TYPE
})
@JsonTypeName("Order_Service")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OrderService {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private OrderServiceMetadata metadata;

  public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
  private List<String> passengerIds = new ArrayList<>();

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_SEGMENT_IDS = "segment_ids";
  private List<String> segmentIds = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  /**
   * The type of the service. For now we only return services of type  &#x60;baggage&#x60; and &#x60;seat&#x60; but we will return other types in the future. We  won&#39;t consider adding new service types a breaking change. 
   */
  public enum TypeEnum {
    BAGGAGE("baggage"),
    
    SEAT("seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OrderService() { 
  }

  public OrderService id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the booked service
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ser_00009UhD4ongolulWd9123", required = true, value = "Duffel's unique identifier for the booked service")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderService metadata(OrderServiceMetadata metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderServiceMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMetadata(OrderServiceMetadata metadata) {
    this.metadata = metadata;
  }


  public OrderService passengerIds(List<String> passengerIds) {
    
    this.passengerIds = passengerIds;
    return this;
  }

  public OrderService addPassengerIdsItem(String passengerIdsItem) {
    this.passengerIds.add(passengerIdsItem);
    return this;
  }

   /**
   * List of passenger &#x60;id&#x60;s the service applies to. The service applies to all the passengers in this list.
   * @return passengerIds
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"pas_00009hj8USM7Ncg31cBCLL\"]", required = true, value = "List of passenger `id`s the service applies to. The service applies to all the passengers in this list.")
  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getPassengerIds() {
    return passengerIds;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengerIds(List<String> passengerIds) {
    this.passengerIds = passengerIds;
  }


  public OrderService quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * The quantity of the service that was booked
   * minimum: 1
   * @return quantity
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1)  @ApiModelProperty(example = "1", required = true, value = "The quantity of the service that was booked")
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public OrderService segmentIds(List<String> segmentIds) {
    
    this.segmentIds = segmentIds;
    return this;
  }

  public OrderService addSegmentIdsItem(String segmentIdsItem) {
    this.segmentIds.add(segmentIdsItem);
    return this;
  }

   /**
   * List of segment &#x60;id&#x60;s the service applies to. The service applies to all the segments in this list.
   * @return segmentIds
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"seg_00009hj8USM7Ncg31cB456\"]", required = true, value = "List of segment `id`s the service applies to. The service applies to all the segments in this list.")
  @JsonProperty(JSON_PROPERTY_SEGMENT_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getSegmentIds() {
    return segmentIds;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_IDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSegmentIds(List<String> segmentIds) {
    this.segmentIds = segmentIds;
  }


  public OrderService totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the service for all passengers and segments it applies to, accounting for quantity and including taxes
   * @return totalAmount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "15.00", required = true, value = "The total price of the service for all passengers and segments it applies to, accounting for quantity and including taxes")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public OrderService totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `total_amount`, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  public OrderService type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the service. For now we only return services of type  &#x60;baggage&#x60; and &#x60;seat&#x60; but we will return other types in the future. We  won&#39;t consider adding new service types a breaking change. 
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "seat", required = true, value = "The type of the service. For now we only return services of type  `baggage` and `seat` but we will return other types in the future. We  won't consider adding new service types a breaking change. ")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderService orderService = (OrderService) o;
    return Objects.equals(this.id, orderService.id) &&
        Objects.equals(this.metadata, orderService.metadata) &&
        Objects.equals(this.passengerIds, orderService.passengerIds) &&
        Objects.equals(this.quantity, orderService.quantity) &&
        Objects.equals(this.segmentIds, orderService.segmentIds) &&
        Objects.equals(this.totalAmount, orderService.totalAmount) &&
        Objects.equals(this.totalCurrency, orderService.totalCurrency) &&
        Objects.equals(this.type, orderService.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, metadata, passengerIds, quantity, segmentIds, totalAmount, totalCurrency, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderService {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    passengerIds: ").append(toIndentedString(passengerIds)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    segmentIds: ").append(toIndentedString(segmentIds)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

