/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.ServiceMetadataForABaggage;
import com.duffel.sdk.model.ServiceMetadataForASeat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The metadata varies by the type of service. It includes further data about the service. For example, for baggages, it may have data about size and weight restrictions. 
 */
@ApiModel(description = "The metadata varies by the type of service. It includes further data about the service. For example, for baggages, it may have data about size and weight restrictions. ")
@JsonPropertyOrder({
  OrderServiceMetadata.JSON_PROPERTY_MAXIMUM_DEPTH_CM,
  OrderServiceMetadata.JSON_PROPERTY_MAXIMUM_HEIGHT_CM,
  OrderServiceMetadata.JSON_PROPERTY_MAXIMUM_LENGTH_CM,
  OrderServiceMetadata.JSON_PROPERTY_MAXIMUM_WEIGHT_KG,
  OrderServiceMetadata.JSON_PROPERTY_TYPE,
  OrderServiceMetadata.JSON_PROPERTY_DESIGNATOR,
  OrderServiceMetadata.JSON_PROPERTY_DISCLOSURES,
  OrderServiceMetadata.JSON_PROPERTY_NAME
})
@JsonTypeName("Order_Service_metadata")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class OrderServiceMetadata {
  public static final String JSON_PROPERTY_MAXIMUM_DEPTH_CM = "maximum_depth_cm";
  private BigDecimal maximumDepthCm;

  public static final String JSON_PROPERTY_MAXIMUM_HEIGHT_CM = "maximum_height_cm";
  private BigDecimal maximumHeightCm;

  public static final String JSON_PROPERTY_MAXIMUM_LENGTH_CM = "maximum_length_cm";
  private BigDecimal maximumLengthCm;

  public static final String JSON_PROPERTY_MAXIMUM_WEIGHT_KG = "maximum_weight_kg";
  private BigDecimal maximumWeightKg;

  /**
   * The type of the baggage
   */
  public enum TypeEnum {
    CHECKED("checked"),
    
    CARRY_ON("carry_on");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_DESIGNATOR = "designator";
  private String designator;

  public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
  private List<String> disclosures = new ArrayList<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public OrderServiceMetadata() { 
  }

  public OrderServiceMetadata maximumDepthCm(BigDecimal maximumDepthCm) {
    
    this.maximumDepthCm = maximumDepthCm;
    return this;
  }

   /**
   * The maximum depth that the baggage can have in centimetres
   * @return maximumDepthCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "75", required = true, value = "The maximum depth that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_DEPTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumDepthCm() {
    return maximumDepthCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_DEPTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumDepthCm(BigDecimal maximumDepthCm) {
    this.maximumDepthCm = maximumDepthCm;
  }


  public OrderServiceMetadata maximumHeightCm(BigDecimal maximumHeightCm) {
    
    this.maximumHeightCm = maximumHeightCm;
    return this;
  }

   /**
   * The maximum height that the baggage can have in centimetres
   * @return maximumHeightCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "90", required = true, value = "The maximum height that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_HEIGHT_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumHeightCm() {
    return maximumHeightCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_HEIGHT_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumHeightCm(BigDecimal maximumHeightCm) {
    this.maximumHeightCm = maximumHeightCm;
  }


  public OrderServiceMetadata maximumLengthCm(BigDecimal maximumLengthCm) {
    
    this.maximumLengthCm = maximumLengthCm;
    return this;
  }

   /**
   * The maximum length that the baggage can have in centimetres
   * @return maximumLengthCm
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "90", required = true, value = "The maximum length that the baggage can have in centimetres")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_LENGTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumLengthCm() {
    return maximumLengthCm;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_LENGTH_CM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumLengthCm(BigDecimal maximumLengthCm) {
    this.maximumLengthCm = maximumLengthCm;
  }


  public OrderServiceMetadata maximumWeightKg(BigDecimal maximumWeightKg) {
    
    this.maximumWeightKg = maximumWeightKg;
    return this;
  }

   /**
   * The maximum weight that the baggage can have in kilograms
   * @return maximumWeightKg
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "23", required = true, value = "The maximum weight that the baggage can have in kilograms")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_WEIGHT_KG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getMaximumWeightKg() {
    return maximumWeightKg;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_WEIGHT_KG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaximumWeightKg(BigDecimal maximumWeightKg) {
    this.maximumWeightKg = maximumWeightKg;
  }


  public OrderServiceMetadata type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the baggage
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "checked", required = true, value = "The type of the baggage")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public OrderServiceMetadata designator(String designator) {
    
    this.designator = designator;
    return this;
  }

   /**
   * The designator used to uniquely identify the seat, usually made up of a  row number and a column letter 
   * @return designator
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "14B", required = true, value = "The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDesignator() {
    return designator;
  }


  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDesignator(String designator) {
    this.designator = designator;
  }


  public OrderServiceMetadata disclosures(List<String> disclosures) {
    
    this.disclosures = disclosures;
    return this;
  }

  public OrderServiceMetadata addDisclosuresItem(String disclosuresItem) {
    this.disclosures.add(disclosuresItem);
    return this;
  }

   /**
   * Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. 
   * @return disclosures
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", required = true, value = "Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getDisclosures() {
    return disclosures;
  }


  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisclosures(List<String> disclosures) {
    this.disclosures = disclosures;
  }


  public OrderServiceMetadata name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features 
   * @return name
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "Exit row seat", required = true, value = "A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderServiceMetadata orderServiceMetadata = (OrderServiceMetadata) o;
    return Objects.equals(this.maximumDepthCm, orderServiceMetadata.maximumDepthCm) &&
        Objects.equals(this.maximumHeightCm, orderServiceMetadata.maximumHeightCm) &&
        Objects.equals(this.maximumLengthCm, orderServiceMetadata.maximumLengthCm) &&
        Objects.equals(this.maximumWeightKg, orderServiceMetadata.maximumWeightKg) &&
        Objects.equals(this.type, orderServiceMetadata.type) &&
        Objects.equals(this.designator, orderServiceMetadata.designator) &&
        Objects.equals(this.disclosures, orderServiceMetadata.disclosures) &&
        Objects.equals(this.name, orderServiceMetadata.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maximumDepthCm, maximumHeightCm, maximumLengthCm, maximumWeightKg, type, designator, disclosures, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderServiceMetadata {\n");
    sb.append("    maximumDepthCm: ").append(toIndentedString(maximumDepthCm)).append("\n");
    sb.append("    maximumHeightCm: ").append(toIndentedString(maximumHeightCm)).append("\n");
    sb.append("    maximumLengthCm: ").append(toIndentedString(maximumLengthCm)).append("\n");
    sb.append("    maximumWeightKg: ").append(toIndentedString(maximumWeightKg)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    designator: ").append(toIndentedString(designator)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

