/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A payment represents a payment for a booking with an airline
 */
@ApiModel(description = "A payment represents a payment for a booking with an airline")
@JsonPropertyOrder({
  Payment.JSON_PROPERTY_AMOUNT,
  Payment.JSON_PROPERTY_CREATED_AT,
  Payment.JSON_PROPERTY_CURRENCY,
  Payment.JSON_PROPERTY_ID,
  Payment.JSON_PROPERTY_LIVE_MODE,
  Payment.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class Payment {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private JsonNullable<String> currency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  /**
   * The type of payment applied to this order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying &#x60;arc_bsp_cash&#x60;. Otherwise, you must pay using your Duffel account&#39;s balance by specifying &#x60;balance&#x60;. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you&#39;re not sure which of these options applies to you, get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   */
  public enum TypeEnum {
    ARC_BSP_CASH("arc_bsp_cash"),
    
    BALANCE("balance");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public Payment() { 
  }

  public Payment amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The price of the payment
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "30.20", value = "The price of the payment")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public Payment createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the payment was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the payment was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Payment currency(String currency) {
    this.currency = JsonNullable.<String>of(currency);
    
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonIgnore

  public String getCurrency() {
        return currency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCurrency_JsonNullable() {
    return currency;
  }
  
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  public void setCurrency_JsonNullable(JsonNullable<String> currency) {
    this.currency = currency;
  }

  public void setCurrency(String currency) {
    this.currency = JsonNullable.<String>of(currency);
  }


  public Payment id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the payment
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "pay_00009hthhsUZ8W4LxQgkjo", value = "Duffel's unique identifier for the payment")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Payment liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the __Payment__ was created in live mode. This field will be set to &#x60;true&#x60; if the __Payment__ was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether the __Payment__ was created in live mode. This field will be set to `true` if the __Payment__ was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public Payment type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of payment applied to this order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying &#x60;arc_bsp_cash&#x60;. Otherwise, you must pay using your Duffel account&#39;s balance by specifying &#x60;balance&#x60;. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you&#39;re not sure which of these options applies to you, get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "balance", value = "The type of payment applied to this order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying `arc_bsp_cash`. Otherwise, you must pay using your Duffel account's balance by specifying `balance`. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you're not sure which of these options applies to you, get in touch with the Duffel support team at <help@duffel.com>.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payment payment = (Payment) o;
    return Objects.equals(this.amount, payment.amount) &&
        Objects.equals(this.createdAt, payment.createdAt) &&
        equalsNullable(this.currency, payment.currency) &&
        Objects.equals(this.id, payment.id) &&
        Objects.equals(this.liveMode, payment.liveMode) &&
        Objects.equals(this.type, payment.type);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, createdAt, hashCodeNullable(currency), id, liveMode, type);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payment {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

