/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A __Refund__ is used to refund money to a customer for part or all of a __Payment Intent__.  You can issue multiple __Refund__s from the same __Payment Intent__. 
 */
@ApiModel(description = "A __Refund__ is used to refund money to a customer for part or all of a __Payment Intent__.  You can issue multiple __Refund__s from the same __Payment Intent__. ")
@JsonPropertyOrder({
  Refund1.JSON_PROPERTY_AMOUNT,
  Refund1.JSON_PROPERTY_ARRIVAL,
  Refund1.JSON_PROPERTY_CREATED_AT,
  Refund1.JSON_PROPERTY_CURRENCY,
  Refund1.JSON_PROPERTY_DESTINATION,
  Refund1.JSON_PROPERTY_ID,
  Refund1.JSON_PROPERTY_LIVE_MODE,
  Refund1.JSON_PROPERTY_NET_AMOUNT,
  Refund1.JSON_PROPERTY_NET_CURRENCY,
  Refund1.JSON_PROPERTY_PAYMENT_INTENT_ID,
  Refund1.JSON_PROPERTY_STATUS,
  Refund1.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Refund_1")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class Refund1 {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_ARRIVAL = "arrival";
  private String arrival;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  /**
   * Where the __Refund__ amount will be sent to
   */
  public enum DestinationEnum {
    ORIGINAL_FORM_OF_PAYMENT("original_form_of_payment");

    private String value;

    DestinationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DestinationEnum fromValue(String value) {
      for (DestinationEnum b : DestinationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private DestinationEnum destination;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_NET_AMOUNT = "net_amount";
  private String netAmount;

  public static final String JSON_PROPERTY_NET_CURRENCY = "net_currency";
  private String netCurrency;

  public static final String JSON_PROPERTY_PAYMENT_INTENT_ID = "payment_intent_id";
  private String paymentIntentId;

  /**
   * The status of the __Refund__.  **Succeeded**: The refund is on its way to the **destination**.  **Pending**: The __Refund__ could not be processed immediately, and is pending processing.  **Failed**: A refund can fail if the customer’s bank or card issuer has been unable to process it correctly (e.g., a closed bank account or a problem with the card). The bank returns the refunded amount to us and we add it back to your __Balance__. This process can take up to 30 days from the post date. 
   */
  public enum StatusEnum {
    SUCCEEDED("succeeded"),
    
    PENDING("pending"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public Refund1() { 
  }

  public Refund1 amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The amount of the __Payment Intent__ that will be refunded to the customer 
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "300.10", value = "The amount of the __Payment Intent__ that will be refunded to the customer ")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public Refund1 arrival(String arrival) {
    
    this.arrival = arrival;
    return this;
  }

   /**
   * When the refund is expected to arrive in the **destination**
   * @return arrival
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Credit approximately 5-10 business days later, depending upon the bank.", value = "When the refund is expected to arrive in the **destination**")
  @JsonProperty(JSON_PROPERTY_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArrival() {
    return arrival;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrival(String arrival) {
    this.arrival = arrival;
  }


  public Refund1 createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Refund1 currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.   It will always match the currency of the __Payment Intent__. 
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.   It will always match the currency of the __Payment Intent__. ")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Refund1 destination(DestinationEnum destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Where the __Refund__ amount will be sent to
   * @return destination
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "original_form_of_payment", value = "Where the __Refund__ amount will be sent to")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DestinationEnum getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(DestinationEnum destination) {
    this.destination = destination;
  }


  public Refund1 id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the __Refund__
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ref_00009hthhsUZ8W4LxQgkjo", value = "Duffel's unique identifier for the __Refund__")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Refund1 liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the __Refund__ was created in live mode. This field will be set to &#x60;true&#x60; if the __Refund__ was created in live mode, or &#x60;false&#x60; if it was created in test mode. 
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether the __Refund__ was created in live mode. This field will be set to `true` if the __Refund__ was created in live mode, or `false` if it was created in test mode. ")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public Refund1 netAmount(String netAmount) {
    
    this.netAmount = netAmount;
    return this;
  }

   /**
   * The amount deducted from your __Balance__ to cover the __Refund__ &#x60;amount&#x60; 
   * @return netAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "300.10", value = "The amount deducted from your __Balance__ to cover the __Refund__ `amount` ")
  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNetAmount() {
    return netAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAmount(String netAmount) {
    this.netAmount = netAmount;
  }


  public Refund1 netCurrency(String netCurrency) {
    
    this.netCurrency = netCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;net_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency. 
   * @return netCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `net_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency. ")
  @JsonProperty(JSON_PROPERTY_NET_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNetCurrency() {
    return netCurrency;
  }


  @JsonProperty(JSON_PROPERTY_NET_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCurrency(String netCurrency) {
    this.netCurrency = netCurrency;
  }


  public Refund1 paymentIntentId(String paymentIntentId) {
    
    this.paymentIntentId = paymentIntentId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the __Payment Intent__ that the __Refund__ is for
   * @return paymentIntentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "pit_00009hthhsUZ8W4LxQgkjo", value = "Duffel's unique identifier for the __Payment Intent__ that the __Refund__ is for")
  @JsonProperty(JSON_PROPERTY_PAYMENT_INTENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentIntentId() {
    return paymentIntentId;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_INTENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentIntentId(String paymentIntentId) {
    this.paymentIntentId = paymentIntentId;
  }


  public Refund1 status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of the __Refund__.  **Succeeded**: The refund is on its way to the **destination**.  **Pending**: The __Refund__ could not be processed immediately, and is pending processing.  **Failed**: A refund can fail if the customer’s bank or card issuer has been unable to process it correctly (e.g., a closed bank account or a problem with the card). The bank returns the refunded amount to us and we add it back to your __Balance__. This process can take up to 30 days from the post date. 
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "succeeded", value = "The status of the __Refund__.  **Succeeded**: The refund is on its way to the **destination**.  **Pending**: The __Refund__ could not be processed immediately, and is pending processing.  **Failed**: A refund can fail if the customer’s bank or card issuer has been unable to process it correctly (e.g., a closed bank account or a problem with the card). The bank returns the refunded amount to us and we add it back to your __Balance__. This process can take up to 30 days from the post date. ")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Refund1 updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Refund1 refund1 = (Refund1) o;
    return Objects.equals(this.amount, refund1.amount) &&
        Objects.equals(this.arrival, refund1.arrival) &&
        Objects.equals(this.createdAt, refund1.createdAt) &&
        Objects.equals(this.currency, refund1.currency) &&
        Objects.equals(this.destination, refund1.destination) &&
        Objects.equals(this.id, refund1.id) &&
        Objects.equals(this.liveMode, refund1.liveMode) &&
        Objects.equals(this.netAmount, refund1.netAmount) &&
        Objects.equals(this.netCurrency, refund1.netCurrency) &&
        Objects.equals(this.paymentIntentId, refund1.paymentIntentId) &&
        Objects.equals(this.status, refund1.status) &&
        Objects.equals(this.updatedAt, refund1.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, arrival, createdAt, currency, destination, id, liveMode, netAmount, netCurrency, paymentIntentId, status, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Refund1 {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    arrival: ").append(toIndentedString(arrival)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    netCurrency: ").append(toIndentedString(netCurrency)).append("\n");
    sb.append("    paymentIntentId: ").append(toIndentedString(paymentIntentId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

