/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.SeatMapCabinRow;
import com.duffel.sdk.model.WingPosition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A cabin is a physical section of an aircraft that passengers travel  in. The cabin that a passenger travels in will depend on the fare  they paid (for example an economy cabin versus a business class cabin). 
 */
@ApiModel(description = "A cabin is a physical section of an aircraft that passengers travel  in. The cabin that a passenger travels in will depend on the fare  they paid (for example an economy cabin versus a business class cabin). ")
@JsonPropertyOrder({
  SeatMapCabin.JSON_PROPERTY_AISLES,
  SeatMapCabin.JSON_PROPERTY_CABIN_CLASS,
  SeatMapCabin.JSON_PROPERTY_DECK,
  SeatMapCabin.JSON_PROPERTY_ROWS,
  SeatMapCabin.JSON_PROPERTY_WINGS
})
@JsonTypeName("Seat_Map_Cabin")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class SeatMapCabin {
  public static final String JSON_PROPERTY_AISLES = "aisles";
  private Integer aisles;

  /**
   * The cabin class that the passenger will travel in on this segment
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private CabinClassEnum cabinClass;

  public static final String JSON_PROPERTY_DECK = "deck";
  private Integer deck;

  public static final String JSON_PROPERTY_ROWS = "rows";
  private List<SeatMapCabinRow> rows = new ArrayList<>();

  public static final String JSON_PROPERTY_WINGS = "wings";
  private JsonNullable<WingPosition> wings = JsonNullable.<WingPosition>undefined();

  public SeatMapCabin() { 
  }

  public SeatMapCabin aisles(Integer aisles) {
    
    this.aisles = aisles;
    return this;
  }

   /**
   * The number of aisles in this cabin.   If this is set to &#x60;1&#x60;, each row of the cabin is split into two sections. If this is set to &#x60;2&#x60;, each row of the cabin is split into three sections. 
   * minimum: 1
   * maximum: 2
   * @return aisles
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1) @Max(2)  @ApiModelProperty(example = "1", required = true, value = "The number of aisles in this cabin.   If this is set to `1`, each row of the cabin is split into two sections. If this is set to `2`, each row of the cabin is split into three sections. ")
  @JsonProperty(JSON_PROPERTY_AISLES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAisles() {
    return aisles;
  }


  @JsonProperty(JSON_PROPERTY_AISLES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAisles(Integer aisles) {
    this.aisles = aisles;
  }


  public SeatMapCabin cabinClass(CabinClassEnum cabinClass) {
    
    this.cabinClass = cabinClass;
    return this;
  }

   /**
   * The cabin class that the passenger will travel in on this segment
   * @return cabinClass
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "economy", required = true, value = "The cabin class that the passenger will travel in on this segment")
  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CabinClassEnum getCabinClass() {
    return cabinClass;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = cabinClass;
  }


  public SeatMapCabin deck(Integer deck) {
    
    this.deck = deck;
    return this;
  }

   /**
   * Level 0 is the main deck and level 1 is the upper deck above that,  which is found on some large aircraft. 
   * minimum: 0
   * maximum: 1
   * @return deck
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0) @Max(1)  @ApiModelProperty(example = "0", required = true, value = "Level 0 is the main deck and level 1 is the upper deck above that,  which is found on some large aircraft. ")
  @JsonProperty(JSON_PROPERTY_DECK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getDeck() {
    return deck;
  }


  @JsonProperty(JSON_PROPERTY_DECK)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDeck(Integer deck) {
    this.deck = deck;
  }


  public SeatMapCabin rows(List<SeatMapCabinRow> rows) {
    
    this.rows = rows;
    return this;
  }

  public SeatMapCabin addRowsItem(SeatMapCabinRow rowsItem) {
    this.rows.add(rowsItem);
    return this;
  }

   /**
   * A list of rows in this cabin.   Row sections are broken up by aisles. Rows are ordered from front to  back of the aircraft. 
   * @return rows
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "A list of rows in this cabin.   Row sections are broken up by aisles. Rows are ordered from front to  back of the aircraft. ")
  @JsonProperty(JSON_PROPERTY_ROWS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SeatMapCabinRow> getRows() {
    return rows;
  }


  @JsonProperty(JSON_PROPERTY_ROWS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRows(List<SeatMapCabinRow> rows) {
    this.rows = rows;
  }


  public SeatMapCabin wings(WingPosition wings) {
    this.wings = JsonNullable.<WingPosition>of(wings);
    
    return this;
  }

   /**
   * Get wings
   * @return wings
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public WingPosition getWings() {
        return wings.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<WingPosition> getWings_JsonNullable() {
    return wings;
  }
  
  @JsonProperty(JSON_PROPERTY_WINGS)
  public void setWings_JsonNullable(JsonNullable<WingPosition> wings) {
    this.wings = wings;
  }

  public void setWings(WingPosition wings) {
    this.wings = JsonNullable.<WingPosition>of(wings);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SeatMapCabin seatMapCabin = (SeatMapCabin) o;
    return Objects.equals(this.aisles, seatMapCabin.aisles) &&
        Objects.equals(this.cabinClass, seatMapCabin.cabinClass) &&
        Objects.equals(this.deck, seatMapCabin.deck) &&
        Objects.equals(this.rows, seatMapCabin.rows) &&
        equalsNullable(this.wings, seatMapCabin.wings);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(aisles, cabinClass, deck, rows, hashCodeNullable(wings));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SeatMapCabin {\n");
    sb.append("    aisles: ").append(toIndentedString(aisles)).append("\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    deck: ").append(toIndentedString(deck)).append("\n");
    sb.append("    rows: ").append(toIndentedString(rows)).append("\n");
    sb.append("    wings: ").append(toIndentedString(wings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

