/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An object containing metadata about the service, like the designator of the  seat. 
 */
@ApiModel(description = "An object containing metadata about the service, like the designator of the  seat. ")
@JsonPropertyOrder({
  ServiceMetadataSeat.JSON_PROPERTY_DESIGNATOR,
  ServiceMetadataSeat.JSON_PROPERTY_DISCLOSURES,
  ServiceMetadataSeat.JSON_PROPERTY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class ServiceMetadataSeat {
  public static final String JSON_PROPERTY_DESIGNATOR = "designator";
  private String designator;

  public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
  private List<String> disclosures = new ArrayList<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public ServiceMetadataSeat() { 
  }

  public ServiceMetadataSeat designator(String designator) {
    
    this.designator = designator;
    return this;
  }

   /**
   * The designator used to uniquely identify the seat, usually made up of a  row number and a column letter 
   * @return designator
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "14B", required = true, value = "The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDesignator() {
    return designator;
  }


  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDesignator(String designator) {
    this.designator = designator;
  }


  public ServiceMetadataSeat disclosures(List<String> disclosures) {
    
    this.disclosures = disclosures;
    return this;
  }

  public ServiceMetadataSeat addDisclosuresItem(String disclosuresItem) {
    this.disclosures.add(disclosuresItem);
    return this;
  }

   /**
   * Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. 
   * @return disclosures
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", required = true, value = "Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getDisclosures() {
    return disclosures;
  }


  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisclosures(List<String> disclosures) {
    this.disclosures = disclosures;
  }


  public ServiceMetadataSeat name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features 
   * @return name
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "Exit row seat", required = true, value = "A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceMetadataSeat serviceMetadataSeat = (ServiceMetadataSeat) o;
    return Objects.equals(this.designator, serviceMetadataSeat.designator) &&
        Objects.equals(this.disclosures, serviceMetadataSeat.disclosures) &&
        Objects.equals(this.name, serviceMetadataSeat.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(designator, disclosures, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceMetadataSeat {\n");
    sb.append("    designator: ").append(toIndentedString(designator)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

