/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * WebhookRequestBody
 */
@JsonPropertyOrder({
  WebhookRequestBody.JSON_PROPERTY_EVENTS,
  WebhookRequestBody.JSON_PROPERTY_URL
})
@JsonTypeName("Webhook_Request_Body")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:24:03.539801+07:00[Asia/Bangkok]")
public class WebhookRequestBody {
  public static final String JSON_PROPERTY_EVENTS = "events";
  private List<String> events = new ArrayList<>();

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public WebhookRequestBody() { 
  }

  public WebhookRequestBody events(List<String> events) {
    
    this.events = events;
    return this;
  }

  public WebhookRequestBody addEventsItem(String eventsItem) {
    this.events.add(eventsItem);
    return this;
  }

   /**
   * The events that this webhook will be subscribed to
   * @return events
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"order.created\",\"order.airline_initiated_change_detected\"]", required = true, value = "The events that this webhook will be subscribed to")
  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getEvents() {
    return events;
  }


  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEvents(List<String> events) {
    this.events = events;
  }


  public WebhookRequestBody url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * The URL where your webhook will be received
   * @return url
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.example.com/webhooks", required = true, value = "The URL where your webhook will be received")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookRequestBody webhookRequestBody = (WebhookRequestBody) o;
    return Objects.equals(this.events, webhookRequestBody.events) &&
        Objects.equals(this.url, webhookRequestBody.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(events, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookRequestBody {\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

