/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.City3;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"city", "city_name", "iata_code", "iata_country_code", "icao_code", "id", "latitude", "longitude", "name", "time_zone"})
public class Airport {
    public static final String JSON_PROPERTY_CITY = "city";
    private JsonNullable<City3> city = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CITY_NAME = "city_name";
    private String cityName;
    public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
    private JsonNullable<String> iataCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
    private String iataCountryCode;
    public static final String JSON_PROPERTY_ICAO_CODE = "icao_code";
    private JsonNullable<String> icaoCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LATITUDE = "latitude";
    private Float latitude;
    public static final String JSON_PROPERTY_LONGITUDE = "longitude";
    private Float longitude;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TIME_ZONE = "time_zone";
    private String timeZone;

    public Airport city(City3 city) {
        this.city = JsonNullable.of((Object)city);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public City3 getCity() {
        return (City3)this.city.orElse(null);
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<City3> getCity_JsonNullable() {
        return this.city;
    }

    @JsonProperty(value="city")
    public void setCity_JsonNullable(JsonNullable<City3> city) {
        this.city = city;
    }

    public void setCity(City3 city) {
        this.city = JsonNullable.of((Object)city);
    }

    public Airport cityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="London", value="The name of the city (or cities separated by a `/`) where the airport is located")
    @JsonProperty(value="city_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCityName() {
        return this.cityName;
    }

    @JsonProperty(value="city_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Airport iataCode(String iataCode) {
        this.iataCode = JsonNullable.of((Object)iataCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LHR", value="The three-character IATA code for the airport")
    @JsonIgnore
    public String getIataCode() {
        return (String)this.iataCode.orElse(null);
    }

    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIataCode_JsonNullable() {
        return this.iataCode;
    }

    @JsonProperty(value="iata_code")
    public void setIataCode_JsonNullable(JsonNullable<String> iataCode) {
        this.iataCode = iataCode;
    }

    public void setIataCode(String iataCode) {
        this.iataCode = JsonNullable.of((Object)iataCode);
    }

    public Airport iataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GB", value="The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the airport is located")
    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIataCountryCode() {
        return this.iataCountryCode;
    }

    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
    }

    public Airport icaoCode(String icaoCode) {
        this.icaoCode = JsonNullable.of((Object)icaoCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EGLL", value="The four-character ICAO code for the airport")
    @JsonIgnore
    public String getIcaoCode() {
        return (String)this.icaoCode.orElse(null);
    }

    @JsonProperty(value="icao_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getIcaoCode_JsonNullable() {
        return this.icaoCode;
    }

    @JsonProperty(value="icao_code")
    public void setIcaoCode_JsonNullable(JsonNullable<String> icaoCode) {
        this.icaoCode = icaoCode;
    }

    public void setIcaoCode(String icaoCode) {
        this.icaoCode = JsonNullable.of((Object)icaoCode);
    }

    public Airport id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="arp_lhr_gb", value="Duffel's unique identifier for the airport")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Airport latitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="64.068865", value="The latitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -90\u00b0 and 90\u00b0")
    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLatitude() {
        return this.latitude;
    }

    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public Airport longitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-141.951519", value="The longitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -180\u00b0 and 180\u00b0")
    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLongitude() {
        return this.longitude;
    }

    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Airport name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Heathrow", value="The name of the airport")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Airport timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Europe/London", value="The time zone of the airport, specified by name from the [tz database](https://en.wikipedia.org/wiki/Tz_database)")
    @JsonProperty(value="time_zone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="time_zone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Airport airport = (Airport)o;
        return Airport.equalsNullable(this.city, airport.city) && Objects.equals(this.cityName, airport.cityName) && Airport.equalsNullable(this.iataCode, airport.iataCode) && Objects.equals(this.iataCountryCode, airport.iataCountryCode) && Airport.equalsNullable(this.icaoCode, airport.icaoCode) && Objects.equals(this.id, airport.id) && Objects.equals(this.latitude, airport.latitude) && Objects.equals(this.longitude, airport.longitude) && Objects.equals(this.name, airport.name) && Objects.equals(this.timeZone, airport.timeZone);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(Airport.hashCodeNullable(this.city), this.cityName, Airport.hashCodeNullable(this.iataCode), this.iataCountryCode, Airport.hashCodeNullable(this.icaoCode), this.id, this.latitude, this.longitude, this.name, this.timeZone);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Airport {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    cityName: ").append(this.toIndentedString(this.cityName)).append("\n");
        sb.append("    iataCode: ").append(this.toIndentedString(this.iataCode)).append("\n");
        sb.append("    iataCountryCode: ").append(this.toIndentedString(this.iataCountryCode)).append("\n");
        sb.append("    icaoCode: ").append(this.toIndentedString(this.icaoCode)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

