/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="The payment details to use to pay for the order change, if there is an amount to be paid.  Some order changes may not need this. If the `change_total_amount` is zero or negative, there is no need to pass a `payment` object. ")
@JsonPropertyOrder(value={"amount", "currency", "type"})
@JsonTypeName(value="confirmOrderChange_request_data_payment")
public class ConfirmOrderChangeRequestDataPayment {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ConfirmOrderChangeRequestDataPayment amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="30.20", required=true, value="The amount of the payment. This should be the same as the `change_total_amount` of the order change. ")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ConfirmOrderChangeRequestDataPayment currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `change_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public ConfirmOrderChangeRequestDataPayment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="balance", required=true, value="The type of payment you want to use for the __Order Change__. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying `arc_bsp_cash`. Otherwise, you must pay using your Duffel account's balance by specifying `balance`. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you're not sure which of these options applies to you, get in touch with the Duffel support team at <help@duffel.com>.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmOrderChangeRequestDataPayment confirmOrderChangeRequestDataPayment = (ConfirmOrderChangeRequestDataPayment)o;
        return Objects.equals(this.amount, confirmOrderChangeRequestDataPayment.amount) && Objects.equals(this.currency, confirmOrderChangeRequestDataPayment.currency) && Objects.equals((Object)this.type, (Object)confirmOrderChangeRequestDataPayment.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.currency, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfirmOrderChangeRequestDataPayment {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ARC_BSP_CASH("arc_bsp_cash"),
        BALANCE("balance"),
        PAYMENTS("payments");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

