/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The inclusive time range for the departure of the slice")
@JsonPropertyOrder(value={"from", "to"})
public class DepartureTime {
    public static final String JSON_PROPERTY_FROM = "from";
    private JsonNullable<String> from = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TO = "to";
    private JsonNullable<String> to = JsonNullable.undefined();

    public DepartureTime from(String from) {
        this.from = JsonNullable.of((Object)from);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="09:45", value="The local time in the format `hh:mm` of the origin airport at or after which the slice should depart. Defaults to current time at airport when only `to` is provided or `from` value is in the past")
    @JsonIgnore
    public String getFrom() {
        return (String)this.from.orElse(null);
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFrom_JsonNullable() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom_JsonNullable(JsonNullable<String> from) {
        this.from = from;
    }

    public void setFrom(String from) {
        this.from = JsonNullable.of((Object)from);
    }

    public DepartureTime to(String to) {
        this.to = JsonNullable.of((Object)to);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="17:00", value="The local time in the format `hh:mm` of the origin airport at or before which the slice should depart. Defaults to `23:59` when only `from` is provided")
    @JsonIgnore
    public String getTo() {
        return (String)this.to.orElse(null);
    }

    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTo_JsonNullable() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo_JsonNullable(JsonNullable<String> to) {
        this.to = to;
    }

    public void setTo(String to) {
        this.to = JsonNullable.of((Object)to);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepartureTime departureTime = (DepartureTime)o;
        return DepartureTime.equalsNullable(this.from, departureTime.from) && DepartureTime.equalsNullable(this.to, departureTime.to);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(DepartureTime.hashCodeNullable(this.from), DepartureTime.hashCodeNullable(this.to));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepartureTime {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

