/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferServiceMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;

@JsonPropertyOrder(value={"id", "maximum_quantity", "metadata", "passenger_ids", "segment_ids", "total_amount", "total_currency", "type"})
@JsonTypeName(value="Offer_Service")
public class OfferService {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MAXIMUM_QUANTITY = "maximum_quantity";
    private Integer maximumQuantity;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private OfferServiceMetadata metadata;
    public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
    private List<String> passengerIds = null;
    public static final String JSON_PROPERTY_SEGMENT_IDS = "segment_ids";
    private List<String> segmentIds = null;
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private String totalAmount;
    public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
    private String totalCurrency;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public OfferService id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ase_00009UhD4ongolulWd9123", value="Duffel's unique identifier for the service")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OfferService maximumQuantity(Integer maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
        return this;
    }

    @Nullable
    @Min(value=1L)
    @ApiModelProperty(example="1", value="The maximum quantity of this service that can be booked with an order")
    @JsonProperty(value="maximum_quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=1L) Integer getMaximumQuantity() {
        return this.maximumQuantity;
    }

    @JsonProperty(value="maximum_quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaximumQuantity(Integer maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
    }

    public OfferService metadata(OfferServiceMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferServiceMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(OfferServiceMetadata metadata) {
        this.metadata = metadata;
    }

    public OfferService passengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
        return this;
    }

    public OfferService addPassengerIdsItem(String passengerIdsItem) {
        if (this.passengerIds == null) {
            this.passengerIds = new ArrayList<String>();
        }
        this.passengerIds.add(passengerIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"pas_00009hj8USM7Ncg31cBCLL\"]", value="The list of passenger `id`s the service applies to. If you add this service to an order it will apply to all the passengers in this list. For services where the type is `baggage`, this list will include only a single passenger.")
    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPassengerIds() {
        return this.passengerIds;
    }

    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
    }

    public OfferService segmentIds(List<String> segmentIds) {
        this.segmentIds = segmentIds;
        return this;
    }

    public OfferService addSegmentIdsItem(String segmentIdsItem) {
        if (this.segmentIds == null) {
            this.segmentIds = new ArrayList<String>();
        }
        this.segmentIds.add(segmentIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"seg_00009hj8USM7Ncg31cB456\"]", value="The list of segment `id`s the service applies to. If you add this service to an order it will apply to all the segments in this list. For services where the type is `baggage`, depending on the airline, this list includes all the segments of all slices or all the segments of a single slice.")
    @JsonProperty(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSegmentIds() {
        return this.segmentIds;
    }

    @JsonProperty(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSegmentIds(List<String> segmentIds) {
        this.segmentIds = segmentIds;
    }

    public OfferService totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15.00", value="The total price of the service for all passengers and segments it applies to, including taxes. This price is for a single unit of the service. ")
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public OfferService totalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `total_amount`, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalCurrency() {
        return this.totalCurrency;
    }

    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
    }

    public OfferService type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="baggage", value="The type of the service. For now we only return services of type  `baggage` but we will return other types in the future. We  won't consider adding new service types a breaking change. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferService offerService = (OfferService)o;
        return Objects.equals(this.id, offerService.id) && Objects.equals(this.maximumQuantity, offerService.maximumQuantity) && Objects.equals(this.metadata, offerService.metadata) && Objects.equals(this.passengerIds, offerService.passengerIds) && Objects.equals(this.segmentIds, offerService.segmentIds) && Objects.equals(this.totalAmount, offerService.totalAmount) && Objects.equals(this.totalCurrency, offerService.totalCurrency) && Objects.equals((Object)this.type, (Object)offerService.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.maximumQuantity, this.metadata, this.passengerIds, this.segmentIds, this.totalAmount, this.totalCurrency, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferService {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    maximumQuantity: ").append(this.toIndentedString(this.maximumQuantity)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    passengerIds: ").append(this.toIndentedString(this.passengerIds)).append("\n");
        sb.append("    segmentIds: ").append(this.toIndentedString(this.segmentIds)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    totalCurrency: ").append(this.toIndentedString(this.totalCurrency)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BAGGAGE("baggage");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

