/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.Airline4;
import com.duffel.sdk.model.AirlineInitiatedChange;
import com.duffel.sdk.model.OrderChange;
import com.duffel.sdk.model.OrderConditions1;
import com.duffel.sdk.model.OrderDocument;
import com.duffel.sdk.model.OrderPassenger;
import com.duffel.sdk.model.OrderPaymentStatus;
import com.duffel.sdk.model.OrderService;
import com.duffel.sdk.model.OrderSlice;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="An order represents a booking with an airline")
@JsonPropertyOrder(value={"airline_initiated_changes", "available_actions", "base_amount", "base_currency", "booking_reference", "cancelled_at", "changes", "conditions", "content", "created_at", "documents", "id", "live_mode", "metadata", "owner", "passengers", "payment_status", "services", "slices", "synced_at", "tax_amount", "tax_currency", "total_amount", "total_currency"})
public class Order {
    public static final String JSON_PROPERTY_AIRLINE_INITIATED_CHANGES = "airline_initiated_changes";
    private List<AirlineInitiatedChange> airlineInitiatedChanges = new ArrayList<AirlineInitiatedChange>();
    public static final String JSON_PROPERTY_AVAILABLE_ACTIONS = "available_actions";
    private List<AvailableActionsEnum> availableActions = null;
    public static final String JSON_PROPERTY_BASE_AMOUNT = "base_amount";
    private String baseAmount;
    public static final String JSON_PROPERTY_BASE_CURRENCY = "base_currency";
    private String baseCurrency;
    public static final String JSON_PROPERTY_BOOKING_REFERENCE = "booking_reference";
    private String bookingReference;
    public static final String JSON_PROPERTY_CANCELLED_AT = "cancelled_at";
    private OffsetDateTime cancelledAt;
    public static final String JSON_PROPERTY_CHANGES = "changes";
    private List<OrderChange> changes = new ArrayList<OrderChange>();
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private OrderConditions1 conditions;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private ContentEnum content;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DOCUMENTS = "documents";
    private List<OrderDocument> documents = new ArrayList<OrderDocument>();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Object metadata;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private Airline4 owner;
    public static final String JSON_PROPERTY_PASSENGERS = "passengers";
    private List<OrderPassenger> passengers = new ArrayList<OrderPassenger>();
    public static final String JSON_PROPERTY_PAYMENT_STATUS = "payment_status";
    private OrderPaymentStatus paymentStatus;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<OrderService> services = new ArrayList<OrderService>();
    public static final String JSON_PROPERTY_SLICES = "slices";
    private List<OrderSlice> slices = new ArrayList<OrderSlice>();
    public static final String JSON_PROPERTY_SYNCED_AT = "synced_at";
    private OffsetDateTime syncedAt;
    public static final String JSON_PROPERTY_TAX_AMOUNT = "tax_amount";
    private String taxAmount;
    public static final String JSON_PROPERTY_TAX_CURRENCY = "tax_currency";
    private String taxCurrency;
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private String totalAmount;
    public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
    private String totalCurrency;

    public Order airlineInitiatedChanges(List<AirlineInitiatedChange> airlineInitiatedChanges) {
        this.airlineInitiatedChanges = airlineInitiatedChanges;
        return this;
    }

    public Order addAirlineInitiatedChangesItem(AirlineInitiatedChange airlineInitiatedChangesItem) {
        this.airlineInitiatedChanges.add(airlineInitiatedChangesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The airline-initiated changes for this Order")
    @JsonProperty(value="airline_initiated_changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AirlineInitiatedChange> getAirlineInitiatedChanges() {
        return this.airlineInitiatedChanges;
    }

    @JsonProperty(value="airline_initiated_changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAirlineInitiatedChanges(List<AirlineInitiatedChange> airlineInitiatedChanges) {
        this.airlineInitiatedChanges = airlineInitiatedChanges;
    }

    public Order availableActions(List<AvailableActionsEnum> availableActions) {
        this.availableActions = availableActions;
        return this;
    }

    public Order addAvailableActionsItem(AvailableActionsEnum availableActionsItem) {
        if (this.availableActions == null) {
            this.availableActions = new ArrayList<AvailableActionsEnum>();
        }
        this.availableActions.add(availableActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"cancel\",\"update\"]", value="The available actions for this __Order__")
    @JsonProperty(value="available_actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AvailableActionsEnum> getAvailableActions() {
        return this.availableActions;
    }

    @JsonProperty(value="available_actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailableActions(List<AvailableActionsEnum> availableActions) {
        this.availableActions = availableActions;
    }

    public Order baseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="60.60", required=true, value="The base price of the order for all flights and services booked, excluding taxes")
    @JsonProperty(value="base_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBaseAmount() {
        return this.baseAmount;
    }

    @JsonProperty(value="base_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
    }

    public Order baseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `base_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="base_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    @JsonProperty(value="base_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    public Order bookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="RZPNX8", required=true, value="The airline's reference for the order, sometimes known as a \"passenger name record\" (PNR) or \"record locator\". Your customers can use this to check in and manage their booking on the airline's website. Usually, this is made up of six alphanumeric characters, but airlines can have their own formats (for example, easyJet's booking references are 7 alphanumeric characters long and LATAM's references are made up of 13 alphanumeric characters beginning with `LA`.)")
    @JsonProperty(value="booking_reference")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBookingReference() {
        return this.bookingReference;
    }

    @JsonProperty(value="booking_reference")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
    }

    public Order cancelledAt(OffsetDateTime cancelledAt) {
        this.cancelledAt = cancelledAt;
        return this;
    }

    @Nullable
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was cancelled, if it has been cancelled")
    @JsonProperty(value="cancelled_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCancelledAt() {
        return this.cancelledAt;
    }

    @JsonProperty(value="cancelled_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancelledAt(OffsetDateTime cancelledAt) {
        this.cancelledAt = cancelledAt;
    }

    public Order changes(List<OrderChange> changes) {
        this.changes = changes;
        return this;
    }

    public Order addChangesItem(OrderChange changesItem) {
        this.changes.add(changesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The passenger-initiated changes for this Order")
    @JsonProperty(value="changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderChange> getChanges() {
        return this.changes;
    }

    @JsonProperty(value="changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChanges(List<OrderChange> changes) {
        this.changes = changes;
    }

    public Order conditions(OrderConditions1 conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrderConditions1 getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConditions(OrderConditions1 conditions) {
        this.conditions = conditions;
    }

    public Order content(ContentEnum content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="self-managed", value="Whether the __Order__ is Self-Managed or Managed")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContentEnum getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(ContentEnum content) {
        this.content = content;
    }

    public Order createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Order documents(List<OrderDocument> documents) {
        this.documents = documents;
        return this;
    }

    public Order addDocumentsItem(OrderDocument documentsItem) {
        this.documents.add(documentsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The documents issued for this order")
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderDocument> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDocuments(List<OrderDocument> documents) {
        this.documents = documents;
    }

    public Order id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ord_00009hthhsUZ8W4LxQgkjo", required=true, value="Duffel's unique identifier for the order")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Order liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Whether the order was created in live mode. This field will be set to `true` if the order was created in live mode, or `false` if it was created in test mode.")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Order metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="{\"customer_prefs\":\"window seat\",\"payment_intent_id\":\"pit_00009htYpSCXrwaB9DnUm2\"}", required=true, value="Metadata contains a set of key-value pairs that you can attach to an object. It can be useful for storing additional information about the object, in a structured format. Duffel does not use this information. You should not store sensitive information in this field. ")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Object getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Order owner(Airline4 owner) {
        this.owner = owner;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Airline4 getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwner(Airline4 owner) {
        this.owner = owner;
    }

    public Order passengers(List<OrderPassenger> passengers) {
        this.passengers = passengers;
        return this;
    }

    public Order addPassengersItem(OrderPassenger passengersItem) {
        this.passengers.add(passengersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The passengers who are travelling")
    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderPassenger> getPassengers() {
        return this.passengers;
    }

    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassengers(List<OrderPassenger> passengers) {
        this.passengers = passengers;
    }

    public Order paymentStatus(OrderPaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payment_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrderPaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    @JsonProperty(value="payment_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentStatus(OrderPaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public Order services(List<OrderService> services) {
        this.services = services;
        return this;
    }

    public Order addServicesItem(OrderService servicesItem) {
        this.services.add(servicesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The services booked along with this order")
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderService> getServices() {
        return this.services;
    }

    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServices(List<OrderService> services) {
        this.services = services;
    }

    public Order slices(List<OrderSlice> slices) {
        this.slices = slices;
        return this;
    }

    public Order addSlicesItem(OrderSlice slicesItem) {
        this.slices.add(slicesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The [slices](/docs/api/overview/key-principles) that make up the itinerary of this order. One-way journeys can be expressed using one slice, whereas return trips will need two.")
    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OrderSlice> getSlices() {
        return this.slices;
    }

    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSlices(List<OrderSlice> slices) {
        this.slices = slices;
    }

    public Order syncedAt(OffsetDateTime syncedAt) {
        this.syncedAt = syncedAt;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11Z", required=true, value="Airlines are always the source of truth for orders. The orders returned in the Duffel API are a view of those orders. This field is the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Order__ was last synced with the airline. If this datetime is in the last minute you can consider the order up to date. ")
    @JsonProperty(value="synced_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getSyncedAt() {
        return this.syncedAt;
    }

    @JsonProperty(value="synced_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSyncedAt(OffsetDateTime syncedAt) {
        this.syncedAt = syncedAt;
    }

    public Order taxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="30.20", required=true, value="The amount of tax payable on the order for all the flights booked")
    @JsonProperty(value="tax_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaxAmount() {
        return this.taxAmount;
    }

    @JsonProperty(value="tax_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public Order taxCurrency(String taxCurrency) {
        this.taxCurrency = taxCurrency;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `tax_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="tax_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaxCurrency() {
        return this.taxCurrency;
    }

    @JsonProperty(value="tax_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaxCurrency(String taxCurrency) {
        this.taxCurrency = taxCurrency;
    }

    public Order totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90.80", required=true, value="The total price of the order for all the flights and services booked, including taxes")
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Order totalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalCurrency() {
        return this.totalCurrency;
    }

    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.airlineInitiatedChanges, order.airlineInitiatedChanges) && Objects.equals(this.availableActions, order.availableActions) && Objects.equals(this.baseAmount, order.baseAmount) && Objects.equals(this.baseCurrency, order.baseCurrency) && Objects.equals(this.bookingReference, order.bookingReference) && Objects.equals(this.cancelledAt, order.cancelledAt) && Objects.equals(this.changes, order.changes) && Objects.equals(this.conditions, order.conditions) && Objects.equals((Object)this.content, (Object)order.content) && Objects.equals(this.createdAt, order.createdAt) && Objects.equals(this.documents, order.documents) && Objects.equals(this.id, order.id) && Objects.equals(this.liveMode, order.liveMode) && Objects.equals(this.metadata, order.metadata) && Objects.equals(this.owner, order.owner) && Objects.equals(this.passengers, order.passengers) && Objects.equals(this.paymentStatus, order.paymentStatus) && Objects.equals(this.services, order.services) && Objects.equals(this.slices, order.slices) && Objects.equals(this.syncedAt, order.syncedAt) && Objects.equals(this.taxAmount, order.taxAmount) && Objects.equals(this.taxCurrency, order.taxCurrency) && Objects.equals(this.totalAmount, order.totalAmount) && Objects.equals(this.totalCurrency, order.totalCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.airlineInitiatedChanges, this.availableActions, this.baseAmount, this.baseCurrency, this.bookingReference, this.cancelledAt, this.changes, this.conditions, this.content, this.createdAt, this.documents, this.id, this.liveMode, this.metadata, this.owner, this.passengers, this.paymentStatus, this.services, this.slices, this.syncedAt, this.taxAmount, this.taxCurrency, this.totalAmount, this.totalCurrency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    airlineInitiatedChanges: ").append(this.toIndentedString(this.airlineInitiatedChanges)).append("\n");
        sb.append("    availableActions: ").append(this.toIndentedString(this.availableActions)).append("\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    baseCurrency: ").append(this.toIndentedString(this.baseCurrency)).append("\n");
        sb.append("    bookingReference: ").append(this.toIndentedString(this.bookingReference)).append("\n");
        sb.append("    cancelledAt: ").append(this.toIndentedString(this.cancelledAt)).append("\n");
        sb.append("    changes: ").append(this.toIndentedString(this.changes)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    content: ").append(this.toIndentedString((Object)this.content)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    passengers: ").append(this.toIndentedString(this.passengers)).append("\n");
        sb.append("    paymentStatus: ").append(this.toIndentedString(this.paymentStatus)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    slices: ").append(this.toIndentedString(this.slices)).append("\n");
        sb.append("    syncedAt: ").append(this.toIndentedString(this.syncedAt)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxCurrency: ").append(this.toIndentedString(this.taxCurrency)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    totalCurrency: ").append(this.toIndentedString(this.totalCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ContentEnum {
        SELF_MANAGED("self-managed"),
        MANAGED("managed");

        private String value;

        private ContentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentEnum fromValue(String value) {
            for (ContentEnum b : ContentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AvailableActionsEnum {
        CANCEL("cancel"),
        CHANGE("change"),
        UPDATE("update");

        private String value;

        private AvailableActionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AvailableActionsEnum fromValue(String value) {
            for (AvailableActionsEnum b : AvailableActionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

