/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="An order cancellation is used to cancel an order with an airline")
@JsonPropertyOrder(value={"confirmed_at", "created_at", "expires_at", "id", "live_mode", "order_id", "refund_amount", "refund_currency", "refund_to"})
@JsonTypeName(value="Order_Cancellation")
public class OrderCancellation {
    public static final String JSON_PROPERTY_CONFIRMED_AT = "confirmed_at";
    private OffsetDateTime confirmedAt;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_ORDER_ID = "order_id";
    private String orderId;
    public static final String JSON_PROPERTY_REFUND_AMOUNT = "refund_amount";
    private String refundAmount;
    public static final String JSON_PROPERTY_REFUND_CURRENCY = "refund_currency";
    private String refundCurrency;
    public static final String JSON_PROPERTY_REFUND_TO = "refund_to";
    private RefundToEnum refundTo;

    public OrderCancellation confirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
        return this;
    }

    @Nullable
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-01-17T11:51:43.114803Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime that indicates when the order cancellation was confirmed")
    @JsonProperty(value="confirmed_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getConfirmedAt() {
        return this.confirmedAt;
    }

    @JsonProperty(value="confirmed_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
    }

    public OrderCancellation createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order cancellation was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OrderCancellation expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @NotNull
    @Valid
    @ApiModelProperty(example="2020-01-17T10:42:14Z", required=true, value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which this cancellation must be confirmed")
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public OrderCancellation id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ore_00009qzZWzjDipIkqpaUAj", required=true, value="Duffel's unique identifier for the order cancellation")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderCancellation liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Whether the order cancellation was created in live mode. This field will be set to `true` if the order cancellation was created in live mode, or `false` if it was created in test mode.")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public OrderCancellation orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ord_00009hthhsUZ8W4LxQgkjo", required=true, value="Duffel's unique identifier for the order")
    @JsonProperty(value="order_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="order_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderCancellation refundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90.80", required=true, value="The amount that will be returned to the original payment method if the order is cancelled, determined according to the fare conditions. This may be `0.00` if the fare is non-refundable. It will include the refund amount of the flights and the services booked.")
    @JsonProperty(value="refund_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRefundAmount() {
        return this.refundAmount;
    }

    @JsonProperty(value="refund_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public OrderCancellation refundCurrency(String refundCurrency) {
        this.refundCurrency = refundCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `refund_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). For `hold` orders that are awaiting payment, the refund amount will always be 0.00. ")
    @JsonProperty(value="refund_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRefundCurrency() {
        return this.refundCurrency;
    }

    @JsonProperty(value="refund_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefundCurrency(String refundCurrency) {
        this.refundCurrency = refundCurrency;
    }

    public OrderCancellation refundTo(RefundToEnum refundTo) {
        this.refundTo = refundTo;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="arc_bsp_cash", required=true, value="Where the refund, once confirmed, will be sent. `card` is currently a restricted feature. `awaiting_payment` is for pay later orders where no payment has been made yet. ")
    @JsonProperty(value="refund_to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RefundToEnum getRefundTo() {
        return this.refundTo;
    }

    @JsonProperty(value="refund_to")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefundTo(RefundToEnum refundTo) {
        this.refundTo = refundTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderCancellation orderCancellation = (OrderCancellation)o;
        return Objects.equals(this.confirmedAt, orderCancellation.confirmedAt) && Objects.equals(this.createdAt, orderCancellation.createdAt) && Objects.equals(this.expiresAt, orderCancellation.expiresAt) && Objects.equals(this.id, orderCancellation.id) && Objects.equals(this.liveMode, orderCancellation.liveMode) && Objects.equals(this.orderId, orderCancellation.orderId) && Objects.equals(this.refundAmount, orderCancellation.refundAmount) && Objects.equals(this.refundCurrency, orderCancellation.refundCurrency) && Objects.equals((Object)this.refundTo, (Object)orderCancellation.refundTo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.confirmedAt, this.createdAt, this.expiresAt, this.id, this.liveMode, this.orderId, this.refundAmount, this.refundCurrency, this.refundTo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderCancellation {\n");
        sb.append("    confirmedAt: ").append(this.toIndentedString(this.confirmedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    refundAmount: ").append(this.toIndentedString(this.refundAmount)).append("\n");
        sb.append("    refundCurrency: ").append(this.toIndentedString(this.refundCurrency)).append("\n");
        sb.append("    refundTo: ").append(this.toIndentedString((Object)this.refundTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RefundToEnum {
        ARC_BSP_CASH("arc_bsp_cash"),
        BALANCE("balance"),
        CARD("card"),
        VOUCHER("voucher"),
        AWAITING_PAYMENT("awaiting_payment");

        private String value;

        private RefundToEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RefundToEnum fromValue(String value) {
            for (RefundToEnum b : RefundToEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

