/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The payment status for this order")
@JsonPropertyOrder(value={"awaiting_payment", "payment_required_by", "price_guarantee_expires_at"})
public class OrderPaymentStatus {
    public static final String JSON_PROPERTY_AWAITING_PAYMENT = "awaiting_payment";
    private Boolean awaitingPayment;
    public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
    private JsonNullable<OffsetDateTime> paymentRequiredBy = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
    private JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt = JsonNullable.undefined();

    public OrderPaymentStatus awaitingPayment(Boolean awaitingPayment) {
        this.awaitingPayment = awaitingPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether a full payment has been made, or the airline is waiting for a payment to be made. This will be set to false if the order has been cancelled or if `payment_required_by` has elapsed.")
    @JsonProperty(value="awaiting_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAwaitingPayment() {
        return this.awaitingPayment;
    }

    @JsonProperty(value="awaiting_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwaitingPayment(Boolean awaitingPayment) {
        this.awaitingPayment = awaitingPayment;
    }

    public OrderPaymentStatus paymentRequiredBy(OffsetDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:42:14.545Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this order. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be `null` only for orders where `awaiting_payment` is `false`.")
    @JsonIgnore
    public OffsetDateTime getPaymentRequiredBy() {
        return (OffsetDateTime)this.paymentRequiredBy.orElse(null);
    }

    @JsonProperty(value="payment_required_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getPaymentRequiredBy_JsonNullable() {
        return this.paymentRequiredBy;
    }

    @JsonProperty(value="payment_required_by")
    public void setPaymentRequiredBy_JsonNullable(JsonNullable<OffsetDateTime> paymentRequiredBy) {
        this.paymentRequiredBy = paymentRequiredBy;
    }

    public void setPaymentRequiredBy(OffsetDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
    }

    public OrderPaymentStatus priceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-01-17T10:42:14.545Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and the order will need to be repriced before payment. This will be `null` when there is no price guarantee.")
    @JsonIgnore
    public OffsetDateTime getPriceGuaranteeExpiresAt() {
        return (OffsetDateTime)this.priceGuaranteeExpiresAt.orElse(null);
    }

    @JsonProperty(value="price_guarantee_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
        return this.priceGuaranteeExpiresAt;
    }

    @JsonProperty(value="price_guarantee_expires_at")
    public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<OffsetDateTime> priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
    }

    public void setPriceGuaranteeExpiresAt(OffsetDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPaymentStatus orderPaymentStatus = (OrderPaymentStatus)o;
        return Objects.equals(this.awaitingPayment, orderPaymentStatus.awaitingPayment) && OrderPaymentStatus.equalsNullable(this.paymentRequiredBy, orderPaymentStatus.paymentRequiredBy) && OrderPaymentStatus.equalsNullable(this.priceGuaranteeExpiresAt, orderPaymentStatus.priceGuaranteeExpiresAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.awaitingPayment, OrderPaymentStatus.hashCodeNullable(this.paymentRequiredBy), OrderPaymentStatus.hashCodeNullable(this.priceGuaranteeExpiresAt));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPaymentStatus {\n");
        sb.append("    awaitingPayment: ").append(this.toIndentedString(this.awaitingPayment)).append("\n");
        sb.append("    paymentRequiredBy: ").append(this.toIndentedString(this.paymentRequiredBy)).append("\n");
        sb.append("    priceGuaranteeExpiresAt: ").append(this.toIndentedString(this.priceGuaranteeExpiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

