/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.ServiceMetadataForASeat1;
import com.duffel.sdk.model.SliceSegmentPassengerBaggage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"baggages", "cabin_class", "cabin_class_marketing_name", "passenger_id", "seat"})
@JsonTypeName(value="Order_Slice_Segment_Passenger")
public class OrderSliceSegmentPassenger {
    public static final String JSON_PROPERTY_BAGGAGES = "baggages";
    private List<SliceSegmentPassengerBaggage> baggages = null;
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private JsonNullable<CabinClassEnum> cabinClass = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME = "cabin_class_marketing_name";
    private JsonNullable<String> cabinClassMarketingName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
    private String passengerId;
    public static final String JSON_PROPERTY_SEAT = "seat";
    private JsonNullable<ServiceMetadataForASeat1> seat = JsonNullable.undefined();

    public OrderSliceSegmentPassenger baggages(List<SliceSegmentPassengerBaggage> baggages) {
        this.baggages = baggages;
        return this;
    }

    public OrderSliceSegmentPassenger addBaggagesItem(SliceSegmentPassengerBaggage baggagesItem) {
        if (this.baggages == null) {
            this.baggages = new ArrayList<SliceSegmentPassengerBaggage>();
        }
        this.baggages.add(baggagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The baggage allowances for the passenger on this segment that were included in the original offer. Any extra baggage items which were booked as services will be listed in the `services` field instead of here.")
    @JsonProperty(value="baggages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SliceSegmentPassengerBaggage> getBaggages() {
        return this.baggages;
    }

    @JsonProperty(value="baggages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaggages(List<SliceSegmentPassengerBaggage> baggages) {
        this.baggages = baggages;
    }

    public OrderSliceSegmentPassenger cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = JsonNullable.of((Object)((Object)cabinClass));
        return this;
    }

    @Nullable
    @ApiModelProperty(example="economy", value="The cabin class that the passenger will travel in on this segment")
    @JsonIgnore
    public CabinClassEnum getCabinClass() {
        return (CabinClassEnum)((Object)this.cabinClass.orElse(null));
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CabinClassEnum> getCabinClass_JsonNullable() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    public void setCabinClass_JsonNullable(JsonNullable<CabinClassEnum> cabinClass) {
        this.cabinClass = cabinClass;
    }

    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = JsonNullable.of((Object)((Object)cabinClass));
    }

    public OrderSliceSegmentPassenger cabinClassMarketingName(String cabinClassMarketingName) {
        this.cabinClassMarketingName = JsonNullable.of((Object)cabinClassMarketingName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Economy Basic", value="The name that the marketing carrier uses to market this cabin class")
    @JsonIgnore
    public String getCabinClassMarketingName() {
        return (String)this.cabinClassMarketingName.orElse(null);
    }

    @JsonProperty(value="cabin_class_marketing_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCabinClassMarketingName_JsonNullable() {
        return this.cabinClassMarketingName;
    }

    @JsonProperty(value="cabin_class_marketing_name")
    public void setCabinClassMarketingName_JsonNullable(JsonNullable<String> cabinClassMarketingName) {
        this.cabinClassMarketingName = cabinClassMarketingName;
    }

    public void setCabinClassMarketingName(String cabinClassMarketingName) {
        this.cabinClassMarketingName = JsonNullable.of((Object)cabinClassMarketingName);
    }

    public OrderSliceSegmentPassenger passengerId(String passengerId) {
        this.passengerId = passengerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="passenger_0", value="The identifier for the passenger. You may have specified this ID yourself when creating the offer request, or otherwise, Duffel will have generated its own random ID.")
    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassengerId() {
        return this.passengerId;
    }

    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengerId(String passengerId) {
        this.passengerId = passengerId;
    }

    public OrderSliceSegmentPassenger seat(ServiceMetadataForASeat1 seat) {
        this.seat = JsonNullable.of((Object)seat);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public ServiceMetadataForASeat1 getSeat() {
        return (ServiceMetadataForASeat1)this.seat.orElse(null);
    }

    @JsonProperty(value="seat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ServiceMetadataForASeat1> getSeat_JsonNullable() {
        return this.seat;
    }

    @JsonProperty(value="seat")
    public void setSeat_JsonNullable(JsonNullable<ServiceMetadataForASeat1> seat) {
        this.seat = seat;
    }

    public void setSeat(ServiceMetadataForASeat1 seat) {
        this.seat = JsonNullable.of((Object)seat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderSliceSegmentPassenger orderSliceSegmentPassenger = (OrderSliceSegmentPassenger)o;
        return Objects.equals(this.baggages, orderSliceSegmentPassenger.baggages) && OrderSliceSegmentPassenger.equalsNullable(this.cabinClass, orderSliceSegmentPassenger.cabinClass) && OrderSliceSegmentPassenger.equalsNullable(this.cabinClassMarketingName, orderSliceSegmentPassenger.cabinClassMarketingName) && Objects.equals(this.passengerId, orderSliceSegmentPassenger.passengerId) && OrderSliceSegmentPassenger.equalsNullable(this.seat, orderSliceSegmentPassenger.seat);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.baggages, OrderSliceSegmentPassenger.hashCodeNullable(this.cabinClass), OrderSliceSegmentPassenger.hashCodeNullable(this.cabinClassMarketingName), this.passengerId, OrderSliceSegmentPassenger.hashCodeNullable(this.seat));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderSliceSegmentPassenger {\n");
        sb.append("    baggages: ").append(this.toIndentedString(this.baggages)).append("\n");
        sb.append("    cabinClass: ").append(this.toIndentedString(this.cabinClass)).append("\n");
        sb.append("    cabinClassMarketingName: ").append(this.toIndentedString(this.cabinClassMarketingName)).append("\n");
        sb.append("    passengerId: ").append(this.toIndentedString(this.passengerId)).append("\n");
        sb.append("    seat: ").append(this.toIndentedString(this.seat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

