/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.SeatMapCabin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Each seat map is for a specific segment")
@JsonPropertyOrder(value={"cabins", "id", "segment_id", "slice_id"})
@JsonTypeName(value="Seat_map")
public class SeatMap {
    public static final String JSON_PROPERTY_CABINS = "cabins";
    private List<SeatMapCabin> cabins = new ArrayList<SeatMapCabin>();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_SEGMENT_ID = "segment_id";
    private String segmentId;
    public static final String JSON_PROPERTY_SLICE_ID = "slice_id";
    private String sliceId;

    public SeatMap cabins(List<SeatMapCabin> cabins) {
        this.cabins = cabins;
        return this;
    }

    public SeatMap addCabinsItem(SeatMapCabin cabinsItem) {
        this.cabins.add(cabinsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The list of cabins in this seat map.  Cabins are ordered by deck from lowest to highest, and then within  each deck from the front to back of the aircraft. ")
    @JsonProperty(value="cabins")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SeatMapCabin> getCabins() {
        return this.cabins;
    }

    @JsonProperty(value="cabins")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCabins(List<SeatMapCabin> cabins) {
        this.cabins = cabins;
    }

    public SeatMap id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="sea_00003hthlsHZ8W4LxXjkzo", required=true, value="Duffel's unique identifier for the seat map")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SeatMap segmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="seg_00009htYpSCXrwaB9Dn456", required=true, value="Duffel's unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different `id`s).")
    @JsonProperty(value="segment_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty(value="segment_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public SeatMap sliceId(String sliceId) {
        this.sliceId = sliceId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="sli_00009htYpSCXrwaB9Dn123", required=true, value="Duffel's unique identifier for the slice. It identifies the slice of an offer (i.e. the same slice across offers will have different `id`s.)")
    @JsonProperty(value="slice_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSliceId() {
        return this.sliceId;
    }

    @JsonProperty(value="slice_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSliceId(String sliceId) {
        this.sliceId = sliceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeatMap seatMap = (SeatMap)o;
        return Objects.equals(this.cabins, seatMap.cabins) && Objects.equals(this.id, seatMap.id) && Objects.equals(this.segmentId, seatMap.segmentId) && Objects.equals(this.sliceId, seatMap.sliceId);
    }

    public int hashCode() {
        return Objects.hash(this.cabins, this.id, this.segmentId, this.sliceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SeatMap {\n");
        sb.append("    cabins: ").append(this.toIndentedString(this.cabins)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    segmentId: ").append(this.toIndentedString(this.segmentId)).append("\n");
        sb.append("    sliceId: ").append(this.toIndentedString(this.sliceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

