/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="A bookable seat is a special kind of service. Only one seat can be booked per passenger, per segment ")
@JsonPropertyOrder(value={"id", "passenger_id", "total_amount", "total_currency"})
public class SeatMapService {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
    private String passengerId;
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private String totalAmount;
    public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
    private String totalCurrency;

    public SeatMapService id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ase_00009UhD4ongolulWd9123", required=true, value="Duffel's unique identifier for the service")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SeatMapService passengerId(String passengerId) {
        this.passengerId = passengerId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="pas_00009hj8USM7Ncg31cBCLL", required=true, value="The passenger that this seat is for")
    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassengerId() {
        return this.passengerId;
    }

    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassengerId(String passengerId) {
        this.passengerId = passengerId;
    }

    public SeatMapService totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="15.00", required=true, value="The total price of the seat, including taxes")
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public SeatMapService totalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GBP", required=true, value="The currency of the `total_amount`, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you\u2019re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalCurrency() {
        return this.totalCurrency;
    }

    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeatMapService seatMapService = (SeatMapService)o;
        return Objects.equals(this.id, seatMapService.id) && Objects.equals(this.passengerId, seatMapService.passengerId) && Objects.equals(this.totalAmount, seatMapService.totalAmount) && Objects.equals(this.totalCurrency, seatMapService.totalCurrency);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.passengerId, this.totalAmount, this.totalCurrency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SeatMapService {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    passengerId: ").append(this.toIndentedString(this.passengerId)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    totalCurrency: ").append(this.toIndentedString(this.totalCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

