/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="Where the wings of the aircraft are in relation to rows in the cabin.  The numbers correspond to the indices of the first and the last  row which are overwing. You can use this to draw a visual  representation of the wings to help users get a better idea of  what they will see outside their window.  The indices are 0th-based and are for all rows, not just those that have seats.  This is `null` when no rows of the cabin are overwing. ")
@JsonPropertyOrder(value={"first_row_index", "last_row_index"})
@JsonTypeName(value="Wing_Position")
public class WingPosition {
    public static final String JSON_PROPERTY_FIRST_ROW_INDEX = "first_row_index";
    private Integer firstRowIndex;
    public static final String JSON_PROPERTY_LAST_ROW_INDEX = "last_row_index";
    private Integer lastRowIndex;

    public WingPosition firstRowIndex(Integer firstRowIndex) {
        this.firstRowIndex = firstRowIndex;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="8", required=true, value="The index of the first row which is overwing, starting from  the front of the aircraft. ")
    @JsonProperty(value="first_row_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getFirstRowIndex() {
        return this.firstRowIndex;
    }

    @JsonProperty(value="first_row_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstRowIndex(Integer firstRowIndex) {
        this.firstRowIndex = firstRowIndex;
    }

    public WingPosition lastRowIndex(Integer lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="12", required=true, value="The index of the last row which is overwing, starting from  the front of the aircraft. ")
    @JsonProperty(value="last_row_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLastRowIndex() {
        return this.lastRowIndex;
    }

    @JsonProperty(value="last_row_index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastRowIndex(Integer lastRowIndex) {
        this.lastRowIndex = lastRowIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WingPosition wingPosition = (WingPosition)o;
        return Objects.equals(this.firstRowIndex, wingPosition.firstRowIndex) && Objects.equals(this.lastRowIndex, wingPosition.lastRowIndex);
    }

    public int hashCode() {
        return Objects.hash(this.firstRowIndex, this.lastRowIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WingPosition {\n");
        sb.append("    firstRowIndex: ").append(this.toIndentedString(this.firstRowIndex)).append("\n");
        sb.append("    lastRowIndex: ").append(this.toIndentedString(this.lastRowIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

