package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.ConfirmOrderChange200Response;
import com.duffel.sdk.model.ConfirmOrderChangeRequest;
import com.duffel.sdk.model.CreateOrderChangeRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OrderChangesApi {
    private ApiClient apiClient;

    public OrderChangesApi() {
        this(new ApiClient());
    }

    @Autowired
    public OrderChangesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Confirm an order change
     * Once you&#39;ve created a pending order change, you&#39;ll know the &#x60;change_total_amount&#x60; due for the change.  To actually change the order, you&#39;ll need to confirm the change. The booking with the airline will be updated with the new slice you previously chose, and the &#x60;change_total_amount&#x60; will be charged to your specific payment type.  If the amount of &#x60;change_total_amount&#x60; is negative, then this will be returned to the &#x60;refund_to&#x60; method (e.g. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order change object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param confirmOrderChangeRequest The confirmOrderChangeRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec confirmOrderChangeRequestCreation(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        Object postBody = confirmOrderChangeRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'confirmOrderChangeRequest' is set
        if (confirmOrderChangeRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'confirmOrderChangeRequest' when calling confirmOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes/{id}/actions/confirm", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Confirm an order change
     * Once you&#39;ve created a pending order change, you&#39;ll know the &#x60;change_total_amount&#x60; due for the change.  To actually change the order, you&#39;ll need to confirm the change. The booking with the airline will be updated with the new slice you previously chose, and the &#x60;change_total_amount&#x60; will be charged to your specific payment type.  If the amount of &#x60;change_total_amount&#x60; is negative, then this will be returned to the &#x60;refund_to&#x60; method (e.g. your Duffel balance). You&#39;ll then need to refund your customer (e.g. back to their credit/debit card). 
     * <p><b>200</b> - An order change object
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param confirmOrderChangeRequest The confirmOrderChangeRequest parameter
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> confirmOrderChange(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return confirmOrderChangeRequestCreation(accept, duffelVersion, id, confirmOrderChangeRequest, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> confirmOrderChangeWithHttpInfo(String accept, String duffelVersion, String id, ConfirmOrderChangeRequest confirmOrderChangeRequest, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return confirmOrderChangeRequestCreation(accept, duffelVersion, id, confirmOrderChangeRequest, acceptEncoding).toEntity(localVarReturnType);
    }
    /**
     * Create a pending order change
     * To begin the process of changing an order you need to create an order change. The OrderChange will contain the &#x60;selected_order_change_offer&#x60; reference of the change you wish to make to your order.  To proceed, you must confirm the change using the [Confirm an order change](/docs/api/order-changes/confirm-order-change) endpoint.  
     * <p><b>201</b> - An order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequest The createOrderChangeRequest parameter
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOrderChangeRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        Object postBody = createOrderChangeRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrderChange", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a pending order change
     * To begin the process of changing an order you need to create an order change. The OrderChange will contain the &#x60;selected_order_change_offer&#x60; reference of the change you wish to make to your order.  To proceed, you must confirm the change using the [Confirm an order change](/docs/api/order-changes/confirm-order-change) endpoint.  
     * <p><b>201</b> - An order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param createOrderChangeRequest The createOrderChangeRequest parameter
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> createOrderChange(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return createOrderChangeRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> createOrderChangeWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, CreateOrderChangeRequest createOrderChangeRequest) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return createOrderChangeRequestCreation(accept, duffelVersion, acceptEncoding, contentType, createOrderChangeRequest).toEntity(localVarReturnType);
    }
    /**
     * Get a single order change
     * Retrieves an order change by its ID
     * <p><b>200</b> - A single order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderChangeById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return apiClient.invokeAPI("/air/order_changes/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order change
     * Retrieves an order change by its ID
     * <p><b>200</b> - A single order change
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ConfirmOrderChange200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConfirmOrderChange200Response> getOrderChangeById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return getOrderChangeByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<ConfirmOrderChange200Response>> getOrderChangeByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<ConfirmOrderChange200Response> localVarReturnType = new ParameterizedTypeReference<ConfirmOrderChange200Response>() {};
        return getOrderChangeByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }
}
