package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.GetSeatMaps200Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class SeatMapsApi {
    private ApiClient apiClient;

    public SeatMapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SeatMapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get seat maps
     * Gets seat maps by specific parameters. At the moment we only  support querying by an offer ID.  A list of seat maps, one per segment, will be returned, which you can use  to build a seat selection UI for your customers. This is not available  for all airlines or flights, so seat maps will not always be returned.  If there are one or more passengers, you do not have to select a seat for  each one. Each passenger can only select one seat per segment. Two passengers  cannot select the same seat.  As with other services when creating an order, the total amount charged will be the cost of the offer and any selected services. 
     * <p><b>200</b> - A list of seat maps.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId The offer ID which you want to get seat maps for
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetSeatMaps200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getSeatMapsRequestCreation(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerId' is set
        if (offerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerId' when calling getSeatMaps", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offer_id", offerId));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return apiClient.invokeAPI("/air/seat_maps", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get seat maps
     * Gets seat maps by specific parameters. At the moment we only  support querying by an offer ID.  A list of seat maps, one per segment, will be returned, which you can use  to build a seat selection UI for your customers. This is not available  for all airlines or flights, so seat maps will not always be returned.  If there are one or more passengers, you do not have to select a seat for  each one. Each passenger can only select one seat per segment. Two passengers  cannot select the same seat.  As with other services when creating an order, the total amount charged will be the cost of the offer and any selected services. 
     * <p><b>200</b> - A list of seat maps.
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId The offer ID which you want to get seat maps for
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetSeatMaps200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetSeatMaps200Response> getSeatMaps(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return getSeatMapsRequestCreation(accept, duffelVersion, offerId, acceptEncoding).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<GetSeatMaps200Response>> getSeatMapsWithHttpInfo(String accept, String duffelVersion, String offerId, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetSeatMaps200Response> localVarReturnType = new ParameterizedTypeReference<GetSeatMaps200Response>() {};
        return getSeatMapsRequestCreation(accept, duffelVersion, offerId, acceptEncoding).toEntity(localVarReturnType);
    }
}
