/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Airline1
 */
@JsonPropertyOrder({
  Airline1.JSON_PROPERTY_IATA_CODE,
  Airline1.JSON_PROPERTY_ID,
  Airline1.JSON_PROPERTY_LOGO_LOCKUP_URL,
  Airline1.JSON_PROPERTY_LOGO_SYMBOL_URL,
  Airline1.JSON_PROPERTY_NAME
})
@JsonTypeName("Airline_1")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class Airline1 {
  public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
  private JsonNullable<String> iataCode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LOGO_LOCKUP_URL = "logo_lockup_url";
  private JsonNullable<String> logoLockupUrl = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LOGO_SYMBOL_URL = "logo_symbol_url";
  private JsonNullable<String> logoSymbolUrl = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public Airline1() { 
  }

  public Airline1 iataCode(String iataCode) {
    this.iataCode = JsonNullable.<String>of(iataCode);
    
    return this;
  }

   /**
   * The two-character IATA code for the airline. This may be &#x60;null&#x60; for non-IATA carriers.
   * @return iataCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "BA", value = "The two-character IATA code for the airline. This may be `null` for non-IATA carriers.")
  @JsonIgnore

  public String getIataCode() {
        return iataCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIataCode_JsonNullable() {
    return iataCode;
  }
  
  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  public void setIataCode_JsonNullable(JsonNullable<String> iataCode) {
    this.iataCode = iataCode;
  }

  public void setIataCode(String iataCode) {
    this.iataCode = JsonNullable.<String>of(iataCode);
  }


  public Airline1 id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the airline
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "aln_00001876aqC8c5umZmrRds", value = "Duffel's unique identifier for the airline")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Airline1 logoLockupUrl(String logoLockupUrl) {
    this.logoLockupUrl = JsonNullable.<String>of(logoLockupUrl);
    
    return this;
  }

   /**
   * Path to a svg of the airline lockup logo. A lockup logo is also called a combination logo, in which it combines the logotype and logomark. This may be &#x60;null&#x60; if no logo is available.
   * @return logoLockupUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://assets.duffel.com/img/airlines/for-light-background/full-color-lockup/BA.svg", value = "Path to a svg of the airline lockup logo. A lockup logo is also called a combination logo, in which it combines the logotype and logomark. This may be `null` if no logo is available.")
  @JsonIgnore

  public String getLogoLockupUrl() {
        return logoLockupUrl.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOGO_LOCKUP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLogoLockupUrl_JsonNullable() {
    return logoLockupUrl;
  }
  
  @JsonProperty(JSON_PROPERTY_LOGO_LOCKUP_URL)
  public void setLogoLockupUrl_JsonNullable(JsonNullable<String> logoLockupUrl) {
    this.logoLockupUrl = logoLockupUrl;
  }

  public void setLogoLockupUrl(String logoLockupUrl) {
    this.logoLockupUrl = JsonNullable.<String>of(logoLockupUrl);
  }


  public Airline1 logoSymbolUrl(String logoSymbolUrl) {
    this.logoSymbolUrl = JsonNullable.<String>of(logoSymbolUrl);
    
    return this;
  }

   /**
   * Path to a svg of the airline logo. This may be &#x60;null&#x60; if no logo is available.
   * @return logoSymbolUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://assets.duffel.com/img/airlines/for-light-background/full-color-logo/BA.svg", value = "Path to a svg of the airline logo. This may be `null` if no logo is available.")
  @JsonIgnore

  public String getLogoSymbolUrl() {
        return logoSymbolUrl.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOGO_SYMBOL_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLogoSymbolUrl_JsonNullable() {
    return logoSymbolUrl;
  }
  
  @JsonProperty(JSON_PROPERTY_LOGO_SYMBOL_URL)
  public void setLogoSymbolUrl_JsonNullable(JsonNullable<String> logoSymbolUrl) {
    this.logoSymbolUrl = logoSymbolUrl;
  }

  public void setLogoSymbolUrl(String logoSymbolUrl) {
    this.logoSymbolUrl = JsonNullable.<String>of(logoSymbolUrl);
  }


  public Airline1 name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the airline
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "British Airways", value = "The name of the airline")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Airline1 airline1 = (Airline1) o;
    return equalsNullable(this.iataCode, airline1.iataCode) &&
        Objects.equals(this.id, airline1.id) &&
        equalsNullable(this.logoLockupUrl, airline1.logoLockupUrl) &&
        equalsNullable(this.logoSymbolUrl, airline1.logoSymbolUrl) &&
        Objects.equals(this.name, airline1.name);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(iataCode), id, hashCodeNullable(logoLockupUrl), hashCodeNullable(logoSymbolUrl), name);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Airline1 {\n");
    sb.append("    iataCode: ").append(toIndentedString(iataCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logoLockupUrl: ").append(toIndentedString(logoLockupUrl)).append("\n");
    sb.append("    logoSymbolUrl: ").append(toIndentedString(logoSymbolUrl)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

