/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferSlice;
import com.duffel.sdk.model.TravelAgentTicket;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * AirlineInitiatedChange
 */
@JsonPropertyOrder({
  AirlineInitiatedChange.JSON_PROPERTY_ACTION_TAKEN,
  AirlineInitiatedChange.JSON_PROPERTY_ACTION_TAKEN_AT,
  AirlineInitiatedChange.JSON_PROPERTY_ADDED,
  AirlineInitiatedChange.JSON_PROPERTY_AVAILABLE_ACTIONS,
  AirlineInitiatedChange.JSON_PROPERTY_CREATED_AT,
  AirlineInitiatedChange.JSON_PROPERTY_ID,
  AirlineInitiatedChange.JSON_PROPERTY_ORDER_ID,
  AirlineInitiatedChange.JSON_PROPERTY_REMOVED,
  AirlineInitiatedChange.JSON_PROPERTY_TRAVEL_AGENT_TICKET,
  AirlineInitiatedChange.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Airline_InitiatedChange")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class AirlineInitiatedChange {
  /**
   * The action taken in response to this airline-initiated change.  Accepted, cancelled and changed reflect your action in accepting the change, cancelling the order or changing the order respectively. 
   */
  public enum ActionTakenEnum {
    ACCEPTED("accepted"),
    
    CANCELLED("cancelled"),
    
    CHANGED("changed");

    private String value;

    ActionTakenEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActionTakenEnum fromValue(String value) {
      for (ActionTakenEnum b : ActionTakenEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_ACTION_TAKEN = "action_taken";
  private ActionTakenEnum actionTaken;

  public static final String JSON_PROPERTY_ACTION_TAKEN_AT = "action_taken_at";
  private String actionTakenAt;

  public static final String JSON_PROPERTY_ADDED = "added";
  private List<OfferSlice> added = new ArrayList<>();

  /**
   * Gets or Sets availableActions
   */
  public enum AvailableActionsEnum {
    ACCEPT("accept"),
    
    CANCEL("cancel"),
    
    CHANGE("change"),
    
    UPDATE("update");

    private String value;

    AvailableActionsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AvailableActionsEnum fromValue(String value) {
      for (AvailableActionsEnum b : AvailableActionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AVAILABLE_ACTIONS = "available_actions";
  private List<AvailableActionsEnum> availableActions = new ArrayList<>();

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ORDER_ID = "order_id";
  private String orderId;

  public static final String JSON_PROPERTY_REMOVED = "removed";
  private List<OfferSlice> removed = new ArrayList<>();

  public static final String JSON_PROPERTY_TRAVEL_AGENT_TICKET = "travel_agent_ticket";
  private List<TravelAgentTicket> travelAgentTicket = new ArrayList<>();

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public AirlineInitiatedChange() { 
  }

  public AirlineInitiatedChange actionTaken(ActionTakenEnum actionTaken) {
    
    this.actionTaken = actionTaken;
    return this;
  }

   /**
   * The action taken in response to this airline-initiated change.  Accepted, cancelled and changed reflect your action in accepting the change, cancelling the order or changing the order respectively. 
   * @return actionTaken
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "accepted", required = true, value = "The action taken in response to this airline-initiated change.  Accepted, cancelled and changed reflect your action in accepting the change, cancelling the order or changing the order respectively. ")
  @JsonProperty(JSON_PROPERTY_ACTION_TAKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ActionTakenEnum getActionTaken() {
    return actionTaken;
  }


  @JsonProperty(JSON_PROPERTY_ACTION_TAKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActionTaken(ActionTakenEnum actionTaken) {
    this.actionTaken = actionTaken;
  }


  public AirlineInitiatedChange actionTakenAt(String actionTakenAt) {
    
    this.actionTakenAt = actionTakenAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which an action was taken
   * @return actionTakenAt
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "2022-01-17T10:12:14.545Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which an action was taken")
  @JsonProperty(JSON_PROPERTY_ACTION_TAKEN_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getActionTakenAt() {
    return actionTakenAt;
  }


  @JsonProperty(JSON_PROPERTY_ACTION_TAKEN_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActionTakenAt(String actionTakenAt) {
    this.actionTakenAt = actionTakenAt;
  }


  public AirlineInitiatedChange added(List<OfferSlice> added) {
    
    this.added = added;
    return this;
  }

  public AirlineInitiatedChange addAddedItem(OfferSlice addedItem) {
    this.added.add(addedItem);
    return this;
  }

   /**
   * List of updated [slices and segments](/docs/api/orders/schema#orders-schema-slices) following the change. These slices and segments may each have a new ID as a result of the changes.
   * @return added
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of updated [slices and segments](/docs/api/orders/schema#orders-schema-slices) following the change. These slices and segments may each have a new ID as a result of the changes.")
  @JsonProperty(JSON_PROPERTY_ADDED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OfferSlice> getAdded() {
    return added;
  }


  @JsonProperty(JSON_PROPERTY_ADDED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdded(List<OfferSlice> added) {
    this.added = added;
  }


  public AirlineInitiatedChange availableActions(List<AvailableActionsEnum> availableActions) {
    
    this.availableActions = availableActions;
    return this;
  }

  public AirlineInitiatedChange addAvailableActionsItem(AvailableActionsEnum availableActionsItem) {
    this.availableActions.add(availableActionsItem);
    return this;
  }

   /**
   * The available actions you can take on this Airline-Initiated Change through our API.  &#x60;\&quot;update\&quot;&#x60; means that you can use the update endpoint for an Airline-Initiated Change.  Possible values in array: &#x60;\&quot;accept\&quot;&#x60;, &#x60;\&quot;cancel\&quot;&#x60;, &#x60;\&quot;change\&quot;&#x60;, or &#x60;\&quot;update\&quot;&#x60; 
   * @return availableActions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"accept\",\"cancel\",\"change\"]", required = true, value = "The available actions you can take on this Airline-Initiated Change through our API.  `\"update\"` means that you can use the update endpoint for an Airline-Initiated Change.  Possible values in array: `\"accept\"`, `\"cancel\"`, `\"change\"`, or `\"update\"` ")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<AvailableActionsEnum> getAvailableActions() {
    return availableActions;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAvailableActions(List<AvailableActionsEnum> availableActions) {
    this.availableActions = availableActions;
  }


  public AirlineInitiatedChange createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which we detected the airline-initiated change
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which we detected the airline-initiated change")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public AirlineInitiatedChange id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the airline-initiated change
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "aic_00001876aqC8c5umZmrRds", required = true, value = "Duffel's unique identifier for the airline-initiated change")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public AirlineInitiatedChange orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order
   * @return orderId
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ord_00009hthhsUZ8W4LxQgkjo", required = true, value = "Duffel's unique identifier for the order")
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public AirlineInitiatedChange removed(List<OfferSlice> removed) {
    
    this.removed = removed;
    return this;
  }

  public AirlineInitiatedChange addRemovedItem(OfferSlice removedItem) {
    this.removed.add(removedItem);
    return this;
  }

   /**
   * List of [slices and segments](/docs/api/orders/schema#orders-schema-slices) as they were before the change.
   * @return removed
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of [slices and segments](/docs/api/orders/schema#orders-schema-slices) as they were before the change.")
  @JsonProperty(JSON_PROPERTY_REMOVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OfferSlice> getRemoved() {
    return removed;
  }


  @JsonProperty(JSON_PROPERTY_REMOVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRemoved(List<OfferSlice> removed) {
    this.removed = removed;
  }


  public AirlineInitiatedChange travelAgentTicket(List<TravelAgentTicket> travelAgentTicket) {
    
    this.travelAgentTicket = travelAgentTicket;
    return this;
  }

  public AirlineInitiatedChange addTravelAgentTicketItem(TravelAgentTicket travelAgentTicketItem) {
    this.travelAgentTicket.add(travelAgentTicketItem);
    return this;
  }

   /**
   * The associated Travel Agent Ticket, if any, for this Airline-Initiated Change. This value will be present for Airline-Initiated changes that take some time to be processed. 
   * @return travelAgentTicket
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The associated Travel Agent Ticket, if any, for this Airline-Initiated Change. This value will be present for Airline-Initiated changes that take some time to be processed. ")
  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT_TICKET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<TravelAgentTicket> getTravelAgentTicket() {
    return travelAgentTicket;
  }


  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT_TICKET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTravelAgentTicket(List<TravelAgentTicket> travelAgentTicket) {
    this.travelAgentTicket = travelAgentTicket;
  }


  public AirlineInitiatedChange updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the airline-initiated change was last updated
   * @return updatedAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the airline-initiated change was last updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AirlineInitiatedChange airlineInitiatedChange = (AirlineInitiatedChange) o;
    return Objects.equals(this.actionTaken, airlineInitiatedChange.actionTaken) &&
        Objects.equals(this.actionTakenAt, airlineInitiatedChange.actionTakenAt) &&
        Objects.equals(this.added, airlineInitiatedChange.added) &&
        Objects.equals(this.availableActions, airlineInitiatedChange.availableActions) &&
        Objects.equals(this.createdAt, airlineInitiatedChange.createdAt) &&
        Objects.equals(this.id, airlineInitiatedChange.id) &&
        Objects.equals(this.orderId, airlineInitiatedChange.orderId) &&
        Objects.equals(this.removed, airlineInitiatedChange.removed) &&
        Objects.equals(this.travelAgentTicket, airlineInitiatedChange.travelAgentTicket) &&
        Objects.equals(this.updatedAt, airlineInitiatedChange.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actionTaken, actionTakenAt, added, availableActions, createdAt, id, orderId, removed, travelAgentTicket, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AirlineInitiatedChange {\n");
    sb.append("    actionTaken: ").append(toIndentedString(actionTaken)).append("\n");
    sb.append("    actionTakenAt: ").append(toIndentedString(actionTakenAt)).append("\n");
    sb.append("    added: ").append(toIndentedString(added)).append("\n");
    sb.append("    availableActions: ").append(toIndentedString(availableActions)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    removed: ").append(toIndentedString(removed)).append("\n");
    sb.append("    travelAgentTicket: ").append(toIndentedString(travelAgentTicket)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

