/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.SeatService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A seat for a passenger. If the &#x60;available_services&#x60; list is empty (which will be represented as an empty list : &#x60;[]&#x60;), the seat is unavailable.  For display, all seats should be displayed with the same static width. 
 */
@ApiModel(description = "A seat for a passenger. If the `available_services` list is empty (which will be represented as an empty list : `[]`), the seat is unavailable.  For display, all seats should be displayed with the same static width. ")
@JsonPropertyOrder({
  CabinRowSectionSeatElement.JSON_PROPERTY_AVAILABLE_SERVICES,
  CabinRowSectionSeatElement.JSON_PROPERTY_DESIGNATOR,
  CabinRowSectionSeatElement.JSON_PROPERTY_DISCLOSURES,
  CabinRowSectionSeatElement.JSON_PROPERTY_NAME,
  CabinRowSectionSeatElement.JSON_PROPERTY_TYPE
})
@JsonTypeName("Cabin_Row_Section_Seat_Element")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class CabinRowSectionSeatElement {
  public static final String JSON_PROPERTY_AVAILABLE_SERVICES = "available_services";
  private List<SeatService> availableServices = new ArrayList<>();

  public static final String JSON_PROPERTY_DESIGNATOR = "designator";
  private String designator;

  public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
  private List<String> disclosures = new ArrayList<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  /**
   * The type of this element
   */
  public enum TypeEnum {
    SEAT("seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public CabinRowSectionSeatElement() { 
  }

  public CabinRowSectionSeatElement availableServices(List<SeatService> availableServices) {
    
    this.availableServices = availableServices;
    return this;
  }

  public CabinRowSectionSeatElement addAvailableServicesItem(SeatService availableServicesItem) {
    this.availableServices.add(availableServicesItem);
    return this;
  }

   /**
   * Seats are considered a special kind of service. There will be at most one service per seat per passenger. A seat can only be booked for one passenger. If a seat has no available services (which will be represented as an empty list : &#x60;[]&#x60;) then it&#39;s unavailable. 
   * @return availableServices
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Seats are considered a special kind of service. There will be at most one service per seat per passenger. A seat can only be booked for one passenger. If a seat has no available services (which will be represented as an empty list : `[]`) then it's unavailable. ")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SeatService> getAvailableServices() {
    return availableServices;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAvailableServices(List<SeatService> availableServices) {
    this.availableServices = availableServices;
  }


  public CabinRowSectionSeatElement designator(String designator) {
    
    this.designator = designator;
    return this;
  }

   /**
   * The designator used to uniquely identify the seat, usually made up of a  row number and a column letter 
   * @return designator
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "14B", required = true, value = "The designator used to uniquely identify the seat, usually made up of a  row number and a column letter ")
  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDesignator() {
    return designator;
  }


  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDesignator(String designator) {
    this.designator = designator;
  }


  public CabinRowSectionSeatElement disclosures(List<String> disclosures) {
    
    this.disclosures = disclosures;
    return this;
  }

  public CabinRowSectionSeatElement addDisclosuresItem(String disclosuresItem) {
    this.disclosures.add(disclosuresItem);
    return this;
  }

   /**
   * Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. 
   * @return disclosures
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "[\"Do not seat children in exit row seats\",\"Do not seat passengers with special needs in exit row seats\"]", required = true, value = "Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. ")
  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getDisclosures() {
    return disclosures;
  }


  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisclosures(List<String> disclosures) {
    this.disclosures = disclosures;
  }


  public CabinRowSectionSeatElement name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features 
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Exit row seat", value = "A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features ")
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public CabinRowSectionSeatElement type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of this element
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "seat", required = true, value = "The type of this element")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CabinRowSectionSeatElement cabinRowSectionSeatElement = (CabinRowSectionSeatElement) o;
    return Objects.equals(this.availableServices, cabinRowSectionSeatElement.availableServices) &&
        Objects.equals(this.designator, cabinRowSectionSeatElement.designator) &&
        Objects.equals(this.disclosures, cabinRowSectionSeatElement.disclosures) &&
        equalsNullable(this.name, cabinRowSectionSeatElement.name) &&
        Objects.equals(this.type, cabinRowSectionSeatElement.type);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(availableServices, designator, disclosures, hashCodeNullable(name), type);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CabinRowSectionSeatElement {\n");
    sb.append("    availableServices: ").append(toIndentedString(availableServices)).append("\n");
    sb.append("    designator: ").append(toIndentedString(designator)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

