/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateOrderRequestDataPaymentsInner
 */
@JsonPropertyOrder({
  CreateOrderRequestDataPaymentsInner.JSON_PROPERTY_AMOUNT,
  CreateOrderRequestDataPaymentsInner.JSON_PROPERTY_CURRENCY,
  CreateOrderRequestDataPaymentsInner.JSON_PROPERTY_TYPE
})
@JsonTypeName("createOrder_request_data_payments_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class CreateOrderRequestDataPaymentsInner {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private String amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  /**
   * The type of payment you want to apply to the order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying &#x60;arc_bsp_cash&#x60;. Otherwise, you must pay using your Duffel account&#39;s balance by specifying &#x60;balance&#x60;. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you&#39;re not sure which of these options applies to you, get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   */
  public enum TypeEnum {
    ARC_BSP_CASH("arc_bsp_cash"),
    
    BALANCE("balance");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public CreateOrderRequestDataPaymentsInner() { 
  }

  public CreateOrderRequestDataPaymentsInner amount(String amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The amount of the payment. This should be the same as the &#x60;total_amount&#x60; of the offer specified in &#x60;selected_offers&#x60;, plus the &#x60;total_amount&#x60; of all the services specified in &#x60;services&#x60;.
   * @return amount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "30.20", required = true, value = "The amount of the payment. This should be the same as the `total_amount` of the offer specified in `selected_offers`, plus the `total_amount` of all the services specified in `services`.")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(String amount) {
    this.amount = amount;
  }


  public CreateOrderRequestDataPaymentsInner currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency of the &#x60;amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. This should be the same as the &#x60;total_currency&#x60; of the offer specified in &#x60;selected_offers&#x60;.
   * @return currency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. This should be the same as the `total_currency` of the offer specified in `selected_offers`.")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public CreateOrderRequestDataPaymentsInner type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of payment you want to apply to the order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying &#x60;arc_bsp_cash&#x60;. Otherwise, you must pay using your Duffel account&#39;s balance by specifying &#x60;balance&#x60;. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you&#39;re not sure which of these options applies to you, get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "balance", required = true, value = "The type of payment you want to apply to the order. If you are an IATA agent with your own agreements with airlines, in some cases, you can pay using ARC/BSP cash by specifying `arc_bsp_cash`. Otherwise, you must pay using your Duffel account's balance by specifying `balance`. In [test mode](/docs/api/overview/test-mode), your balance is unlimited. If you're not sure which of these options applies to you, get in touch with the Duffel support team at <help@duffel.com>.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderRequestDataPaymentsInner createOrderRequestDataPaymentsInner = (CreateOrderRequestDataPaymentsInner) o;
    return Objects.equals(this.amount, createOrderRequestDataPaymentsInner.amount) &&
        Objects.equals(this.currency, createOrderRequestDataPaymentsInner.currency) &&
        Objects.equals(this.type, createOrderRequestDataPaymentsInner.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderRequestDataPaymentsInner {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

