/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferConditions1;
import com.duffel.sdk.model.OfferIndexOwner;
import com.duffel.sdk.model.OfferIndexPaymentRequirements;
import com.duffel.sdk.model.OfferPassenger;
import com.duffel.sdk.model.OfferService;
import com.duffel.sdk.model.OfferSlice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Offer1
 */
@JsonPropertyOrder({
  Offer1.JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES,
  Offer1.JSON_PROPERTY_AVAILABLE_SERVICES,
  Offer1.JSON_PROPERTY_BASE_AMOUNT,
  Offer1.JSON_PROPERTY_BASE_CURRENCY,
  Offer1.JSON_PROPERTY_CONDITIONS,
  Offer1.JSON_PROPERTY_CREATED_AT,
  Offer1.JSON_PROPERTY_EXPIRES_AT,
  Offer1.JSON_PROPERTY_ID,
  Offer1.JSON_PROPERTY_LIVE_MODE,
  Offer1.JSON_PROPERTY_OWNER,
  Offer1.JSON_PROPERTY_PARTIAL,
  Offer1.JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED,
  Offer1.JSON_PROPERTY_PASSENGERS,
  Offer1.JSON_PROPERTY_PAYMENT_REQUIREMENTS,
  Offer1.JSON_PROPERTY_SLICES,
  Offer1.JSON_PROPERTY_TAX_AMOUNT,
  Offer1.JSON_PROPERTY_TAX_CURRENCY,
  Offer1.JSON_PROPERTY_TOTAL_AMOUNT,
  Offer1.JSON_PROPERTY_TOTAL_CURRENCY,
  Offer1.JSON_PROPERTY_TOTAL_EMISSIONS_KG,
  Offer1.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Offer_1")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class Offer1 {
  /**
   * Gets or Sets allowedPassengerIdentityDocumentTypes
   */
  public enum AllowedPassengerIdentityDocumentTypesEnum {
    PASSPORT("passport");

    private String value;

    AllowedPassengerIdentityDocumentTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AllowedPassengerIdentityDocumentTypesEnum fromValue(String value) {
      for (AllowedPassengerIdentityDocumentTypesEnum b : AllowedPassengerIdentityDocumentTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES = "allowed_passenger_identity_document_types";
  private List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes = null;

  public static final String JSON_PROPERTY_AVAILABLE_SERVICES = "available_services";
  private List<OfferService> availableServices = null;

  public static final String JSON_PROPERTY_BASE_AMOUNT = "base_amount";
  private String baseAmount;

  public static final String JSON_PROPERTY_BASE_CURRENCY = "base_currency";
  private String baseCurrency;

  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private OfferConditions1 conditions;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private OfferIndexOwner owner;

  public static final String JSON_PROPERTY_PARTIAL = "partial";
  private Boolean partial;

  public static final String JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED = "passenger_identity_documents_required";
  private Boolean passengerIdentityDocumentsRequired;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OfferPassenger> passengers = null;

  public static final String JSON_PROPERTY_PAYMENT_REQUIREMENTS = "payment_requirements";
  private OfferIndexPaymentRequirements paymentRequirements;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private List<OfferSlice> slices = null;

  public static final String JSON_PROPERTY_TAX_AMOUNT = "tax_amount";
  private JsonNullable<String> taxAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TAX_CURRENCY = "tax_currency";
  private JsonNullable<String> taxCurrency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  public static final String JSON_PROPERTY_TOTAL_EMISSIONS_KG = "total_emissions_kg";
  private String totalEmissionsKg;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public Offer1() { 
  }

  public Offer1 allowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
    
    this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
    return this;
  }

  public Offer1 addAllowedPassengerIdentityDocumentTypesItem(AllowedPassengerIdentityDocumentTypesEnum allowedPassengerIdentityDocumentTypesItem) {
    if (this.allowedPassengerIdentityDocumentTypes == null) {
      this.allowedPassengerIdentityDocumentTypes = new ArrayList<>();
    }
    this.allowedPassengerIdentityDocumentTypes.add(allowedPassengerIdentityDocumentTypesItem);
    return this;
  }

   /**
   * The types of identity documents that may be provided for the passengers when creating an order based on this offer. Currently, the only supported type is &#x60;passport&#x60;. If this is &#x60;[]&#x60;, then you must not provide identity documents.
   * @return allowedPassengerIdentityDocumentTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"passport\"]", value = "The types of identity documents that may be provided for the passengers when creating an order based on this offer. Currently, the only supported type is `passport`. If this is `[]`, then you must not provide identity documents.")
  @JsonProperty(JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AllowedPassengerIdentityDocumentTypesEnum> getAllowedPassengerIdentityDocumentTypes() {
    return allowedPassengerIdentityDocumentTypes;
  }


  @JsonProperty(JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
    this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
  }


  public Offer1 availableServices(List<OfferService> availableServices) {
    
    this.availableServices = availableServices;
    return this;
  }

  public Offer1 addAvailableServicesItem(OfferService availableServicesItem) {
    if (this.availableServices == null) {
      this.availableServices = new ArrayList<>();
    }
    this.availableServices.add(availableServicesItem);
    return this;
  }

   /**
   * The services that can be booked along with the offer but are not included by default, for example an additional checked bag. This field is only returned in the [Get single offer](/docs/api/offers/get-offer-by-id) endpoint. When there are no services available, or we don&#39;t support services for the airline, this list will be empty. If you want to know which airlines we support services for, please get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   * @return availableServices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The services that can be booked along with the offer but are not included by default, for example an additional checked bag. This field is only returned in the [Get single offer](/docs/api/offers/get-offer-by-id) endpoint. When there are no services available, or we don't support services for the airline, this list will be empty. If you want to know which airlines we support services for, please get in touch with the Duffel support team at <help@duffel.com>.")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferService> getAvailableServices() {
    return availableServices;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableServices(List<OfferService> availableServices) {
    this.availableServices = availableServices;
  }


  public Offer1 baseAmount(String baseAmount) {
    
    this.baseAmount = baseAmount;
    return this;
  }

   /**
   * The base price of the offer for all passengers, excluding taxes. It does not include the base amount of any service(s) that might be booked with the offer.
   * @return baseAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "30.20", value = "The base price of the offer for all passengers, excluding taxes. It does not include the base amount of any service(s) that might be booked with the offer.")
  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBaseAmount() {
    return baseAmount;
  }


  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseAmount(String baseAmount) {
    this.baseAmount = baseAmount;
  }


  public Offer1 baseCurrency(String baseCurrency) {
    
    this.baseCurrency = baseCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;base_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return baseCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `base_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBaseCurrency() {
    return baseCurrency;
  }


  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseCurrency(String baseCurrency) {
    this.baseCurrency = baseCurrency;
  }


  public Offer1 conditions(OfferConditions1 conditions) {
    
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferConditions1 getConditions() {
    return conditions;
  }


  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(OfferConditions1 conditions) {
    this.conditions = conditions;
  }


  public Offer1 createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Offer1 expiresAt(OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime expiry of the offer before which the traveller should use this offer to create an order. After this time the offer can no longer be used to create an order.
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime expiry of the offer before which the traveller should use this offer to create an order. After this time the offer can no longer be used to create an order.")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public Offer1 id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the offer
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "off_00009htYpSCXrwaB9DnUm0", value = "Duffel's unique identifier for the offer")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Offer1 liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the offer request was created in live mode. This field will be set to &#x60;true&#x60; if the offer request was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether the offer request was created in live mode. This field will be set to `true` if the offer request was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public Offer1 owner(OfferIndexOwner owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferIndexOwner getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(OfferIndexOwner owner) {
    this.owner = owner;
  }


  public Offer1 partial(Boolean partial) {
    
    this.partial = partial;
    return this;
  }

   /**
   * Partial offers are a new concept we&#39;re introducing as a part of a new multi-step search flow that we&#39;re currently experimenting with. A partial offer can&#39;t be booked directly, but it can be combined with other partial offers to form a full offer. Partial offers are only ever returned through the multi-step search flow. So there&#39;s no need to add any handling to deal with partial offers if you&#39;re using the traditional &#x60;OfferRequest&#x60; search flow to create offers. 
   * @return partial
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Partial offers are a new concept we're introducing as a part of a new multi-step search flow that we're currently experimenting with. A partial offer can't be booked directly, but it can be combined with other partial offers to form a full offer. Partial offers are only ever returned through the multi-step search flow. So there's no need to add any handling to deal with partial offers if you're using the traditional `OfferRequest` search flow to create offers. ")
  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPartial() {
    return partial;
  }


  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartial(Boolean partial) {
    this.partial = partial;
  }


  public Offer1 passengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
    
    this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
    return this;
  }

   /**
   * Whether identity documents must be provided for each of the passengers when creating an order based on this offer. If this is &#x60;true&#x60;, you must provide an identity document for every passenger.
   * @return passengerIdentityDocumentsRequired
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether identity documents must be provided for each of the passengers when creating an order based on this offer. If this is `true`, you must provide an identity document for every passenger.")
  @JsonProperty(JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPassengerIdentityDocumentsRequired() {
    return passengerIdentityDocumentsRequired;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
    this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
  }


  public Offer1 passengers(List<OfferPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public Offer1 addPassengersItem(OfferPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The passengers included in the offer
   * @return passengers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The passengers included in the offer")
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengers(List<OfferPassenger> passengers) {
    this.passengers = passengers;
  }


  public Offer1 paymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
    
    this.paymentRequirements = paymentRequirements;
    return this;
  }

   /**
   * Get paymentRequirements
   * @return paymentRequirements
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIREMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferIndexPaymentRequirements getPaymentRequirements() {
    return paymentRequirements;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIREMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
    this.paymentRequirements = paymentRequirements;
  }


  public Offer1 slices(List<OfferSlice> slices) {
    
    this.slices = slices;
    return this;
  }

  public Offer1 addSlicesItem(OfferSlice slicesItem) {
    if (this.slices == null) {
      this.slices = new ArrayList<>();
    }
    this.slices.add(slicesItem);
    return this;
  }

   /**
   * The [slices](/docs/api/overview/key-principles) that make up this offer. Each slice will include one or more [segments](/docs/api/overview/key-principles), the specific flights that the airline is offering to take the passengers from the slice&#39;s &#x60;origin&#x60; to its &#x60;destination&#x60;. [Partial](#offers-schema-partial) offers contain a single slice as each partial offer is for a particular slice of the journey.
   * @return slices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The [slices](/docs/api/overview/key-principles) that make up this offer. Each slice will include one or more [segments](/docs/api/overview/key-principles), the specific flights that the airline is offering to take the passengers from the slice's `origin` to its `destination`. [Partial](#offers-schema-partial) offers contain a single slice as each partial offer is for a particular slice of the journey.")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferSlice> getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(List<OfferSlice> slices) {
    this.slices = slices;
  }


  public Offer1 taxAmount(String taxAmount) {
    this.taxAmount = JsonNullable.<String>of(taxAmount);
    
    return this;
  }

   /**
   * The amount of tax payable on the offer for all passengers
   * @return taxAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "40.80", value = "The amount of tax payable on the offer for all passengers")
  @JsonIgnore

  public String getTaxAmount() {
        return taxAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaxAmount_JsonNullable() {
    return taxAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  public void setTaxAmount_JsonNullable(JsonNullable<String> taxAmount) {
    this.taxAmount = taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = JsonNullable.<String>of(taxAmount);
  }


  public Offer1 taxCurrency(String taxCurrency) {
    this.taxCurrency = JsonNullable.<String>of(taxCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;tax_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return taxCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `tax_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonIgnore

  public String getTaxCurrency() {
        return taxCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaxCurrency_JsonNullable() {
    return taxCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  public void setTaxCurrency_JsonNullable(JsonNullable<String> taxCurrency) {
    this.taxCurrency = taxCurrency;
  }

  public void setTaxCurrency(String taxCurrency) {
    this.taxCurrency = JsonNullable.<String>of(taxCurrency);
  }


  public Offer1 totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the offer for all passengers, including taxes. It does not include the total price of any service(s) that might be booked with the offer.
   * @return totalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "45.00", value = "The total price of the offer for all passengers, including taxes. It does not include the total price of any service(s) that might be booked with the offer.")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public Offer1 totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  public Offer1 totalEmissionsKg(String totalEmissionsKg) {
    
    this.totalEmissionsKg = totalEmissionsKg;
    return this;
  }

   /**
   * An estimate of the total carbon dioxide (CO₂) emissions when all of the passengers fly this offer&#39;s itinerary, measured in kilograms
   * @return totalEmissionsKg
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "460", value = "An estimate of the total carbon dioxide (CO₂) emissions when all of the passengers fly this offer's itinerary, measured in kilograms")
  @JsonProperty(JSON_PROPERTY_TOTAL_EMISSIONS_KG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalEmissionsKg() {
    return totalEmissionsKg;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_EMISSIONS_KG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalEmissionsKg(String totalEmissionsKg) {
    this.totalEmissionsKg = totalEmissionsKg;
  }


  public Offer1 updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Offer1 offer1 = (Offer1) o;
    return Objects.equals(this.allowedPassengerIdentityDocumentTypes, offer1.allowedPassengerIdentityDocumentTypes) &&
        Objects.equals(this.availableServices, offer1.availableServices) &&
        Objects.equals(this.baseAmount, offer1.baseAmount) &&
        Objects.equals(this.baseCurrency, offer1.baseCurrency) &&
        Objects.equals(this.conditions, offer1.conditions) &&
        Objects.equals(this.createdAt, offer1.createdAt) &&
        Objects.equals(this.expiresAt, offer1.expiresAt) &&
        Objects.equals(this.id, offer1.id) &&
        Objects.equals(this.liveMode, offer1.liveMode) &&
        Objects.equals(this.owner, offer1.owner) &&
        Objects.equals(this.partial, offer1.partial) &&
        Objects.equals(this.passengerIdentityDocumentsRequired, offer1.passengerIdentityDocumentsRequired) &&
        Objects.equals(this.passengers, offer1.passengers) &&
        Objects.equals(this.paymentRequirements, offer1.paymentRequirements) &&
        Objects.equals(this.slices, offer1.slices) &&
        equalsNullable(this.taxAmount, offer1.taxAmount) &&
        equalsNullable(this.taxCurrency, offer1.taxCurrency) &&
        Objects.equals(this.totalAmount, offer1.totalAmount) &&
        Objects.equals(this.totalCurrency, offer1.totalCurrency) &&
        Objects.equals(this.totalEmissionsKg, offer1.totalEmissionsKg) &&
        Objects.equals(this.updatedAt, offer1.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedPassengerIdentityDocumentTypes, availableServices, baseAmount, baseCurrency, conditions, createdAt, expiresAt, id, liveMode, owner, partial, passengerIdentityDocumentsRequired, passengers, paymentRequirements, slices, hashCodeNullable(taxAmount), hashCodeNullable(taxCurrency), totalAmount, totalCurrency, totalEmissionsKg, updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Offer1 {\n");
    sb.append("    allowedPassengerIdentityDocumentTypes: ").append(toIndentedString(allowedPassengerIdentityDocumentTypes)).append("\n");
    sb.append("    availableServices: ").append(toIndentedString(availableServices)).append("\n");
    sb.append("    baseAmount: ").append(toIndentedString(baseAmount)).append("\n");
    sb.append("    baseCurrency: ").append(toIndentedString(baseCurrency)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    partial: ").append(toIndentedString(partial)).append("\n");
    sb.append("    passengerIdentityDocumentsRequired: ").append(toIndentedString(passengerIdentityDocumentsRequired)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    paymentRequirements: ").append(toIndentedString(paymentRequirements)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxCurrency: ").append(toIndentedString(taxCurrency)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("    totalEmissionsKg: ").append(toIndentedString(totalEmissionsKg)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

