/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferPassenger
 */
@JsonPropertyOrder({
  OfferPassenger.JSON_PROPERTY_AGE,
  OfferPassenger.JSON_PROPERTY_FAMILY_NAME,
  OfferPassenger.JSON_PROPERTY_GIVEN_NAME,
  OfferPassenger.JSON_PROPERTY_ID,
  OfferPassenger.JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS,
  OfferPassenger.JSON_PROPERTY_TYPE
})
@JsonTypeName("Offer_Passenger")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OfferPassenger {
  public static final String JSON_PROPERTY_AGE = "age";
  private Integer age;

  public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
  private JsonNullable<String> familyName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
  private JsonNullable<String> givenName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
  private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = null;

  /**
   * The type of the passenger
   */
  public enum TypeEnum {
    ADULT("adult"),
    
    CHILD("child"),
    
    INFANT_WITHOUT_SEAT("infant_without_seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OfferPassenger() { 
  }

  public OfferPassenger age(Integer age) {
    
    this.age = age;
    return this;
  }

   /**
   * The age of the passenger on the &#x60;departure_date&#x60; of the final slice
   * minimum: 0
   * maximum: 130
   * @return age
  **/
  @javax.annotation.Nullable
 @Min(0) @Max(130)  @ApiModelProperty(example = "14", value = "The age of the passenger on the `departure_date` of the final slice")
  @JsonProperty(JSON_PROPERTY_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAge() {
    return age;
  }


  @JsonProperty(JSON_PROPERTY_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAge(Integer age) {
    this.age = age;
  }


  public OfferPassenger familyName(String familyName) {
    this.familyName = JsonNullable.<String>of(familyName);
    
    return this;
  }

   /**
   * The passenger&#39;s family name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you&#39;re also including __Loyalty Programme Accounts__. 
   * @return familyName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Earhart", value = "The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
  @JsonIgnore

  public String getFamilyName() {
        return familyName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFamilyName_JsonNullable() {
    return familyName;
  }
  
  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  public void setFamilyName_JsonNullable(JsonNullable<String> familyName) {
    this.familyName = familyName;
  }

  public void setFamilyName(String familyName) {
    this.familyName = JsonNullable.<String>of(familyName);
  }


  public OfferPassenger givenName(String givenName) {
    this.givenName = JsonNullable.<String>of(givenName);
    
    return this;
  }

   /**
   * The passenger&#39;s given name. Only &#x60;space&#x60;, &#x60;-&#x60;, &#x60;&#39;&#x60;, and letters from the [&#x60;ASCII&#x60;](https://www.unicode.org/charts/PDF/U0000.pdf), [&#x60;Latin-1 Supplement&#x60;](https://www.unicode.org/charts/PDF/U0080.pdf) and [&#x60;Latin Extended-A&#x60;](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of &#x60;Æ&#x60;, &#x60;æ&#x60;, &#x60;Ĳ&#x60;, &#x60;ĳ&#x60;, &#x60;Œ&#x60;, &#x60;œ&#x60;, &#x60;Þ&#x60;, and &#x60;ð&#x60;) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you&#39;re also including __Loyalty Programme Accounts__. 
   * @return givenName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Amelia", value = "The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `Æ`, `æ`, `Ĳ`, `ĳ`, `Œ`, `œ`, `Þ`, and `ð`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
  @JsonIgnore

  public String getGivenName() {
        return givenName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getGivenName_JsonNullable() {
    return givenName;
  }
  
  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  public void setGivenName_JsonNullable(JsonNullable<String> givenName) {
    this.givenName = givenName;
  }

  public void setGivenName(String givenName) {
    this.givenName = JsonNullable.<String>of(givenName);
  }


  public OfferPassenger id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The identifier for the passenger. This ID will be generated by Duffel
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "pas_00009hj8USM7Ncg31cBCL", value = "The identifier for the passenger. This ID will be generated by Duffel")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferPassenger loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    return this;
  }

  public OfferPassenger addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
    if (this.loyaltyProgrammeAccounts == null) {
      this.loyaltyProgrammeAccounts = new ArrayList<>();
    }
    this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
    return this;
  }

   /**
   * The __Loyalty Programme Accounts__ for this passenger
   * @return loyaltyProgrammeAccounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The __Loyalty Programme Accounts__ for this passenger")
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
    return loyaltyProgrammeAccounts;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
  }


  public OfferPassenger type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the passenger
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "adult", value = "The type of the passenger")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferPassenger offerPassenger = (OfferPassenger) o;
    return Objects.equals(this.age, offerPassenger.age) &&
        equalsNullable(this.familyName, offerPassenger.familyName) &&
        equalsNullable(this.givenName, offerPassenger.givenName) &&
        Objects.equals(this.id, offerPassenger.id) &&
        Objects.equals(this.loyaltyProgrammeAccounts, offerPassenger.loyaltyProgrammeAccounts) &&
        Objects.equals(this.type, offerPassenger.type);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(age, hashCodeNullable(familyName), hashCodeNullable(givenName), id, loyaltyProgrammeAccounts, type);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferPassenger {\n");
    sb.append("    age: ").append(toIndentedString(age)).append("\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loyaltyProgrammeAccounts: ").append(toIndentedString(loyaltyProgrammeAccounts)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

