/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferRequestBodyPassengersInner;
import com.duffel.sdk.model.OfferRequestBodyPrivateFares;
import com.duffel.sdk.model.OfferRequestBodySlice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferRequestBody
 */
@JsonPropertyOrder({
  OfferRequestBody.JSON_PROPERTY_CABIN_CLASS,
  OfferRequestBody.JSON_PROPERTY_MAX_CONNECTIONS,
  OfferRequestBody.JSON_PROPERTY_PASSENGERS,
  OfferRequestBody.JSON_PROPERTY_PRIVATE_FARES,
  OfferRequestBody.JSON_PROPERTY_SLICES
})
@JsonTypeName("Offer_Request_Body")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OfferRequestBody {
  /**
   * The cabin that the passengers want to travel in
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private CabinClassEnum cabinClass;

  public static final String JSON_PROPERTY_MAX_CONNECTIONS = "max_connections";
  private Integer maxConnections;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OfferRequestBodyPassengersInner> passengers = new ArrayList<>();

  public static final String JSON_PROPERTY_PRIVATE_FARES = "private_fares";
  private OfferRequestBodyPrivateFares privateFares;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private List<OfferRequestBodySlice> slices = new ArrayList<>();

  public OfferRequestBody() { 
  }

  public OfferRequestBody cabinClass(CabinClassEnum cabinClass) {
    
    this.cabinClass = cabinClass;
    return this;
  }

   /**
   * The cabin that the passengers want to travel in
   * @return cabinClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "economy", value = "The cabin that the passengers want to travel in")
  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CabinClassEnum getCabinClass() {
    return cabinClass;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = cabinClass;
  }


  public OfferRequestBody maxConnections(Integer maxConnections) {
    
    this.maxConnections = maxConnections;
    return this;
  }

   /**
   * The maximum number of connections within any slice of the offer. For example 0 means a direct flight which will have a single segment within each slice and 1 means a maximum of two segments within each slice of the offer.
   * @return maxConnections
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "The maximum number of connections within any slice of the offer. For example 0 means a direct flight which will have a single segment within each slice and 1 means a maximum of two segments within each slice of the offer.")
  @JsonProperty(JSON_PROPERTY_MAX_CONNECTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxConnections() {
    return maxConnections;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CONNECTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxConnections(Integer maxConnections) {
    this.maxConnections = maxConnections;
  }


  public OfferRequestBody passengers(List<OfferRequestBodyPassengersInner> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public OfferRequestBody addPassengersItem(OfferRequestBodyPassengersInner passengersItem) {
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The passengers who want to travel. If you specify an &#x60;age&#x60; for a passenger, the &#x60;type&#x60; may differ for the same passenger in different offers due to airline&#39;s different rules. e.g. one airline may treat a 14 year old as an adult, and another as a young adult. You may only specify an &#x60;age&#x60; or a &#x60;type&#x60; – not both.
   * @return passengers
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "[{\"family_name\":\"Earhart\",\"given_name\":\"Amelia\",\"loyalty_programme_accounts\":[{\"account_number\":\"12901014\",\"airline_iata_code\":\"BA\"}],\"type\":\"adult\"},{\"age\":14}]", required = true, value = "The passengers who want to travel. If you specify an `age` for a passenger, the `type` may differ for the same passenger in different offers due to airline's different rules. e.g. one airline may treat a 14 year old as an adult, and another as a young adult. You may only specify an `age` or a `type` – not both.")
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OfferRequestBodyPassengersInner> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengers(List<OfferRequestBodyPassengersInner> passengers) {
    this.passengers = passengers;
  }


  public OfferRequestBody privateFares(OfferRequestBodyPrivateFares privateFares) {
    
    this.privateFares = privateFares;
    return this;
  }

   /**
   * Get privateFares
   * @return privateFares
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRIVATE_FARES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferRequestBodyPrivateFares getPrivateFares() {
    return privateFares;
  }


  @JsonProperty(JSON_PROPERTY_PRIVATE_FARES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrivateFares(OfferRequestBodyPrivateFares privateFares) {
    this.privateFares = privateFares;
  }


  public OfferRequestBody slices(List<OfferRequestBodySlice> slices) {
    
    this.slices = slices;
    return this;
  }

  public OfferRequestBody addSlicesItem(OfferRequestBodySlice slicesItem) {
    this.slices.add(slicesItem);
    return this;
  }

   /**
   * The [slices](/docs/api/overview/key-principles) that make up this offer request. One-way journeys can be expressed using one slice, whereas return trips will need two.
   * @return slices
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The [slices](/docs/api/overview/key-principles) that make up this offer request. One-way journeys can be expressed using one slice, whereas return trips will need two.")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OfferRequestBodySlice> getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSlices(List<OfferRequestBodySlice> slices) {
    this.slices = slices;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestBody offerRequestBody = (OfferRequestBody) o;
    return Objects.equals(this.cabinClass, offerRequestBody.cabinClass) &&
        Objects.equals(this.maxConnections, offerRequestBody.maxConnections) &&
        Objects.equals(this.passengers, offerRequestBody.passengers) &&
        Objects.equals(this.privateFares, offerRequestBody.privateFares) &&
        Objects.equals(this.slices, offerRequestBody.slices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cabinClass, maxConnections, passengers, privateFares, slices);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestBody {\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    maxConnections: ").append(toIndentedString(maxConnections)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    privateFares: ").append(toIndentedString(privateFares)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

