/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferRequestSliceAirportCity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferRequestSliceAirport
 */
@JsonPropertyOrder({
  OfferRequestSliceAirport.JSON_PROPERTY_CITY,
  OfferRequestSliceAirport.JSON_PROPERTY_IATA_CITY_CODE,
  OfferRequestSliceAirport.JSON_PROPERTY_IATA_CODE,
  OfferRequestSliceAirport.JSON_PROPERTY_IATA_COUNTRY_CODE,
  OfferRequestSliceAirport.JSON_PROPERTY_ID,
  OfferRequestSliceAirport.JSON_PROPERTY_NAME,
  OfferRequestSliceAirport.JSON_PROPERTY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OfferRequestSliceAirport {
  public static final String JSON_PROPERTY_CITY = "city";
  private OfferRequestSliceAirportCity city;

  public static final String JSON_PROPERTY_IATA_CITY_CODE = "iata_city_code";
  private String iataCityCode;

  public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
  private String iataCode;

  public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
  private String iataCountryCode;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * The type of place, either an airport or a city
   */
  public enum TypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OfferRequestSliceAirport() { 
  }

  public OfferRequestSliceAirport city(OfferRequestSliceAirportCity city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferRequestSliceAirportCity getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(OfferRequestSliceAirportCity city) {
    this.city = city;
  }


  public OfferRequestSliceAirport iataCityCode(String iataCityCode) {
    
    this.iataCityCode = iataCityCode;
    return this;
  }

   /**
   * 3-letter IATA code for the airport&#39;s city
   * @return iataCityCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LON", value = "3-letter IATA code for the airport's city")
  @JsonProperty(JSON_PROPERTY_IATA_CITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCityCode() {
    return iataCityCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_CITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCityCode(String iataCityCode) {
    this.iataCityCode = iataCityCode;
  }


  public OfferRequestSliceAirport iataCode(String iataCode) {
    
    this.iataCode = iataCode;
    return this;
  }

   /**
   * 3-letter IATA code for the airport
   * @return iataCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LHR", value = "3-letter IATA code for the airport")
  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCode() {
    return iataCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCode(String iataCode) {
    this.iataCode = iataCode;
  }


  public OfferRequestSliceAirport iataCountryCode(String iataCountryCode) {
    
    this.iataCountryCode = iataCountryCode;
    return this;
  }

   /**
   * 2-letter IATA code for the airport&#39;s country
   * @return iataCountryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GB", value = "2-letter IATA code for the airport's country")
  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIataCountryCode() {
    return iataCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIataCountryCode(String iataCountryCode) {
    this.iataCountryCode = iataCountryCode;
  }


  public OfferRequestSliceAirport id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique identifier for the airport
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "arp_lhr_gb", value = "Unique identifier for the airport")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferRequestSliceAirport name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of the airport
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Heathrow", value = "Name of the airport")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public OfferRequestSliceAirport type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of place, either an airport or a city
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "airport", value = "The type of place, either an airport or a city")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestSliceAirport offerRequestSliceAirport = (OfferRequestSliceAirport) o;
    return Objects.equals(this.city, offerRequestSliceAirport.city) &&
        Objects.equals(this.iataCityCode, offerRequestSliceAirport.iataCityCode) &&
        Objects.equals(this.iataCode, offerRequestSliceAirport.iataCode) &&
        Objects.equals(this.iataCountryCode, offerRequestSliceAirport.iataCountryCode) &&
        Objects.equals(this.id, offerRequestSliceAirport.id) &&
        Objects.equals(this.name, offerRequestSliceAirport.name) &&
        Objects.equals(this.type, offerRequestSliceAirport.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(city, iataCityCode, iataCode, iataCountryCode, id, name, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestSliceAirport {\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    iataCityCode: ").append(toIndentedString(iataCityCode)).append("\n");
    sb.append("    iataCode: ").append(toIndentedString(iataCode)).append("\n");
    sb.append("    iataCountryCode: ").append(toIndentedString(iataCountryCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

