/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferServiceMetadata;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferService
 */
@JsonPropertyOrder({
  OfferService.JSON_PROPERTY_ID,
  OfferService.JSON_PROPERTY_MAXIMUM_QUANTITY,
  OfferService.JSON_PROPERTY_METADATA,
  OfferService.JSON_PROPERTY_PASSENGER_IDS,
  OfferService.JSON_PROPERTY_SEGMENT_IDS,
  OfferService.JSON_PROPERTY_TOTAL_AMOUNT,
  OfferService.JSON_PROPERTY_TOTAL_CURRENCY,
  OfferService.JSON_PROPERTY_TYPE
})
@JsonTypeName("Offer_Service")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OfferService {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MAXIMUM_QUANTITY = "maximum_quantity";
  private Integer maximumQuantity;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private OfferServiceMetadata metadata;

  public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
  private List<String> passengerIds = null;

  public static final String JSON_PROPERTY_SEGMENT_IDS = "segment_ids";
  private List<String> segmentIds = null;

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  /**
   * The type of the service. For now we only return services of type  &#x60;baggage&#x60; but we will return other types in the future. We  won&#39;t consider adding new service types a breaking change. 
   */
  public enum TypeEnum {
    BAGGAGE("baggage");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OfferService() { 
  }

  public OfferService id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the service
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ase_00009UhD4ongolulWd9123", value = "Duffel's unique identifier for the service")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferService maximumQuantity(Integer maximumQuantity) {
    
    this.maximumQuantity = maximumQuantity;
    return this;
  }

   /**
   * The maximum quantity of this service that can be booked with an order
   * minimum: 1
   * @return maximumQuantity
  **/
  @javax.annotation.Nullable
 @Min(1)  @ApiModelProperty(example = "1", value = "The maximum quantity of this service that can be booked with an order")
  @JsonProperty(JSON_PROPERTY_MAXIMUM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaximumQuantity() {
    return maximumQuantity;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaximumQuantity(Integer maximumQuantity) {
    this.maximumQuantity = maximumQuantity;
  }


  public OfferService metadata(OfferServiceMetadata metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferServiceMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(OfferServiceMetadata metadata) {
    this.metadata = metadata;
  }


  public OfferService passengerIds(List<String> passengerIds) {
    
    this.passengerIds = passengerIds;
    return this;
  }

  public OfferService addPassengerIdsItem(String passengerIdsItem) {
    if (this.passengerIds == null) {
      this.passengerIds = new ArrayList<>();
    }
    this.passengerIds.add(passengerIdsItem);
    return this;
  }

   /**
   * The list of passenger &#x60;id&#x60;s the service applies to. If you add this service to an order it will apply to all the passengers in this list. For services where the type is &#x60;baggage&#x60;, this list will include only a single passenger.
   * @return passengerIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"pas_00009hj8USM7Ncg31cBCLL\"]", value = "The list of passenger `id`s the service applies to. If you add this service to an order it will apply to all the passengers in this list. For services where the type is `baggage`, this list will include only a single passenger.")
  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPassengerIds() {
    return passengerIds;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerIds(List<String> passengerIds) {
    this.passengerIds = passengerIds;
  }


  public OfferService segmentIds(List<String> segmentIds) {
    
    this.segmentIds = segmentIds;
    return this;
  }

  public OfferService addSegmentIdsItem(String segmentIdsItem) {
    if (this.segmentIds == null) {
      this.segmentIds = new ArrayList<>();
    }
    this.segmentIds.add(segmentIdsItem);
    return this;
  }

   /**
   * The list of segment &#x60;id&#x60;s the service applies to. If you add this service to an order it will apply to all the segments in this list. For services where the type is &#x60;baggage&#x60;, depending on the airline, this list includes all the segments of all slices or all the segments of a single slice.
   * @return segmentIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"seg_00009hj8USM7Ncg31cB456\"]", value = "The list of segment `id`s the service applies to. If you add this service to an order it will apply to all the segments in this list. For services where the type is `baggage`, depending on the airline, this list includes all the segments of all slices or all the segments of a single slice.")
  @JsonProperty(JSON_PROPERTY_SEGMENT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSegmentIds() {
    return segmentIds;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentIds(List<String> segmentIds) {
    this.segmentIds = segmentIds;
  }


  public OfferService totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the service for all passengers and segments it applies to, including taxes. This price is for a single unit of the service. 
   * @return totalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15.00", value = "The total price of the service for all passengers and segments it applies to, including taxes. This price is for a single unit of the service. ")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public OfferService totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `total_amount`, as an  [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  public OfferService type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the service. For now we only return services of type  &#x60;baggage&#x60; but we will return other types in the future. We  won&#39;t consider adding new service types a breaking change. 
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "baggage", value = "The type of the service. For now we only return services of type  `baggage` but we will return other types in the future. We  won't consider adding new service types a breaking change. ")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferService offerService = (OfferService) o;
    return Objects.equals(this.id, offerService.id) &&
        Objects.equals(this.maximumQuantity, offerService.maximumQuantity) &&
        Objects.equals(this.metadata, offerService.metadata) &&
        Objects.equals(this.passengerIds, offerService.passengerIds) &&
        Objects.equals(this.segmentIds, offerService.segmentIds) &&
        Objects.equals(this.totalAmount, offerService.totalAmount) &&
        Objects.equals(this.totalCurrency, offerService.totalCurrency) &&
        Objects.equals(this.type, offerService.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, maximumQuantity, metadata, passengerIds, segmentIds, totalAmount, totalCurrency, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferService {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    maximumQuantity: ").append(toIndentedString(maximumQuantity)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    passengerIds: ").append(toIndentedString(passengerIds)).append("\n");
    sb.append("    segmentIds: ").append(toIndentedString(segmentIds)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

