/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferSliceConditions1;
import com.duffel.sdk.model.OfferSliceDestination;
import com.duffel.sdk.model.OfferSliceOrigin;
import com.duffel.sdk.model.OfferSliceSegment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferSlice
 */
@JsonPropertyOrder({
  OfferSlice.JSON_PROPERTY_CONDITIONS,
  OfferSlice.JSON_PROPERTY_DESTINATION,
  OfferSlice.JSON_PROPERTY_DESTINATION_TYPE,
  OfferSlice.JSON_PROPERTY_DURATION,
  OfferSlice.JSON_PROPERTY_FARE_BRAND_NAME,
  OfferSlice.JSON_PROPERTY_ID,
  OfferSlice.JSON_PROPERTY_ORIGIN,
  OfferSlice.JSON_PROPERTY_ORIGIN_TYPE,
  OfferSlice.JSON_PROPERTY_SEGMENTS
})
@JsonTypeName("Offer_Slice")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OfferSlice {
  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private List<OfferSliceConditions1> conditions = null;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private OfferSliceDestination destination;

  /**
   * The type of the destination
   */
  public enum DestinationTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    DestinationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DestinationTypeEnum fromValue(String value) {
      for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
  private DestinationTypeEnum destinationType;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private JsonNullable<String> duration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FARE_BRAND_NAME = "fare_brand_name";
  private JsonNullable<String> fareBrandName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private OfferSliceOrigin origin;

  /**
   * The type of the origin
   */
  public enum OriginTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    OriginTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OriginTypeEnum fromValue(String value) {
      for (OriginTypeEnum b : OriginTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
  private OriginTypeEnum originType;

  public static final String JSON_PROPERTY_SEGMENTS = "segments";
  private List<OfferSliceSegment> segments = null;

  public OfferSlice() { 
  }

  public OfferSlice conditions(List<OfferSliceConditions1> conditions) {
    
    this.conditions = conditions;
    return this;
  }

  public OfferSlice addConditionsItem(OfferSliceConditions1 conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

   /**
   * The options and conditions to change or cancel this slice
   * @return conditions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The options and conditions to change or cancel this slice")
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferSliceConditions1> getConditions() {
    return conditions;
  }


  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(List<OfferSliceConditions1> conditions) {
    this.conditions = conditions;
  }


  public OfferSlice destination(OfferSliceDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(OfferSliceDestination destination) {
    this.destination = destination;
  }


  public OfferSlice destinationType(DestinationTypeEnum destinationType) {
    
    this.destinationType = destinationType;
    return this;
  }

   /**
   * The type of the destination
   * @return destinationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "airport", value = "The type of the destination")
  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DestinationTypeEnum getDestinationType() {
    return destinationType;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationType(DestinationTypeEnum destinationType) {
    this.destinationType = destinationType;
  }


  public OfferSlice duration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
    
    return this;
  }

   /**
   * The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PT02H26M", value = "The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
  @JsonIgnore

  public String getDuration() {
        return duration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDuration_JsonNullable() {
    return duration;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION)
  public void setDuration_JsonNullable(JsonNullable<String> duration) {
    this.duration = duration;
  }

  public void setDuration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
  }


  public OfferSlice fareBrandName(String fareBrandName) {
    this.fareBrandName = JsonNullable.<String>of(fareBrandName);
    
    return this;
  }

   /**
   * The name of the fare brand associated with this slice. A fare brand specifies the travel conditions you get on your slice made available by the airline. e.g. a British Airways Economy Basic fare will only include a hand baggage allowance. It is worth noting that the fare brand names are defined by the airlines themselves and therefore they are subject to change without any prior notice. We’re in the process of adding support for &#x60;fare_brand_name&#x60; across all our airlines, so for now, this field may be &#x60;null&#x60; in some offers. This will become a non-nullable attribute in the near future. 
   * @return fareBrandName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Basic", value = "The name of the fare brand associated with this slice. A fare brand specifies the travel conditions you get on your slice made available by the airline. e.g. a British Airways Economy Basic fare will only include a hand baggage allowance. It is worth noting that the fare brand names are defined by the airlines themselves and therefore they are subject to change without any prior notice. We’re in the process of adding support for `fare_brand_name` across all our airlines, so for now, this field may be `null` in some offers. This will become a non-nullable attribute in the near future. ")
  @JsonIgnore

  public String getFareBrandName() {
        return fareBrandName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FARE_BRAND_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFareBrandName_JsonNullable() {
    return fareBrandName;
  }
  
  @JsonProperty(JSON_PROPERTY_FARE_BRAND_NAME)
  public void setFareBrandName_JsonNullable(JsonNullable<String> fareBrandName) {
    this.fareBrandName = fareBrandName;
  }

  public void setFareBrandName(String fareBrandName) {
    this.fareBrandName = JsonNullable.<String>of(fareBrandName);
  }


  public OfferSlice id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the slice. It identifies the slice of an offer (i.e. the same slice across offers will have different &#x60;id&#x60;s.)
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "sli_00009htYpSCXrwaB9Dn123", value = "Duffel's unique identifier for the slice. It identifies the slice of an offer (i.e. the same slice across offers will have different `id`s.)")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferSlice origin(OfferSliceOrigin origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferSliceOrigin getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(OfferSliceOrigin origin) {
    this.origin = origin;
  }


  public OfferSlice originType(OriginTypeEnum originType) {
    
    this.originType = originType;
    return this;
  }

   /**
   * The type of the origin
   * @return originType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "airport", value = "The type of the origin")
  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OriginTypeEnum getOriginType() {
    return originType;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginType(OriginTypeEnum originType) {
    this.originType = originType;
  }


  public OfferSlice segments(List<OfferSliceSegment> segments) {
    
    this.segments = segments;
    return this;
  }

  public OfferSlice addSegmentsItem(OfferSliceSegment segmentsItem) {
    if (this.segments == null) {
      this.segments = new ArrayList<>();
    }
    this.segments.add(segmentsItem);
    return this;
  }

   /**
   * The segments - that is, specific flights - that the airline is offering to get the passengers from the &#x60;origin&#x60; to the &#x60;destination&#x60;
   * @return segments
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The segments - that is, specific flights - that the airline is offering to get the passengers from the `origin` to the `destination`")
  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferSliceSegment> getSegments() {
    return segments;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegments(List<OfferSliceSegment> segments) {
    this.segments = segments;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferSlice offerSlice = (OfferSlice) o;
    return Objects.equals(this.conditions, offerSlice.conditions) &&
        Objects.equals(this.destination, offerSlice.destination) &&
        Objects.equals(this.destinationType, offerSlice.destinationType) &&
        equalsNullable(this.duration, offerSlice.duration) &&
        equalsNullable(this.fareBrandName, offerSlice.fareBrandName) &&
        Objects.equals(this.id, offerSlice.id) &&
        Objects.equals(this.origin, offerSlice.origin) &&
        Objects.equals(this.originType, offerSlice.originType) &&
        Objects.equals(this.segments, offerSlice.segments);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, destination, destinationType, hashCodeNullable(duration), hashCodeNullable(fareBrandName), id, origin, originType, segments);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferSlice {\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationType: ").append(toIndentedString(destinationType)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    fareBrandName: ").append(toIndentedString(fareBrandName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originType: ").append(toIndentedString(originType)).append("\n");
    sb.append("    segments: ").append(toIndentedString(segments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

