/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Airline4;
import com.duffel.sdk.model.AirlineInitiatedChange;
import com.duffel.sdk.model.OrderChange;
import com.duffel.sdk.model.OrderConditions1;
import com.duffel.sdk.model.OrderDocument;
import com.duffel.sdk.model.OrderPassenger;
import com.duffel.sdk.model.OrderPaymentStatus;
import com.duffel.sdk.model.OrderService;
import com.duffel.sdk.model.OrderSlice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An order represents a booking with an airline
 */
@ApiModel(description = "An order represents a booking with an airline")
@JsonPropertyOrder({
  Order1.JSON_PROPERTY_AIRLINE_INITIATED_CHANGES,
  Order1.JSON_PROPERTY_AVAILABLE_ACTIONS,
  Order1.JSON_PROPERTY_BASE_AMOUNT,
  Order1.JSON_PROPERTY_BASE_CURRENCY,
  Order1.JSON_PROPERTY_BOOKING_REFERENCE,
  Order1.JSON_PROPERTY_CANCELLED_AT,
  Order1.JSON_PROPERTY_CHANGES,
  Order1.JSON_PROPERTY_CONDITIONS,
  Order1.JSON_PROPERTY_CONTENT,
  Order1.JSON_PROPERTY_CREATED_AT,
  Order1.JSON_PROPERTY_DOCUMENTS,
  Order1.JSON_PROPERTY_ID,
  Order1.JSON_PROPERTY_LIVE_MODE,
  Order1.JSON_PROPERTY_METADATA,
  Order1.JSON_PROPERTY_OWNER,
  Order1.JSON_PROPERTY_PASSENGERS,
  Order1.JSON_PROPERTY_PAYMENT_STATUS,
  Order1.JSON_PROPERTY_SERVICES,
  Order1.JSON_PROPERTY_SLICES,
  Order1.JSON_PROPERTY_SYNCED_AT,
  Order1.JSON_PROPERTY_TAX_AMOUNT,
  Order1.JSON_PROPERTY_TAX_CURRENCY,
  Order1.JSON_PROPERTY_TOTAL_AMOUNT,
  Order1.JSON_PROPERTY_TOTAL_CURRENCY
})
@JsonTypeName("Order_1")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class Order1 {
  public static final String JSON_PROPERTY_AIRLINE_INITIATED_CHANGES = "airline_initiated_changes";
  private List<AirlineInitiatedChange> airlineInitiatedChanges = new ArrayList<>();

  /**
   * Gets or Sets availableActions
   */
  public enum AvailableActionsEnum {
    CANCEL("cancel"),
    
    CHANGE("change"),
    
    UPDATE("update");

    private String value;

    AvailableActionsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AvailableActionsEnum fromValue(String value) {
      for (AvailableActionsEnum b : AvailableActionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AVAILABLE_ACTIONS = "available_actions";
  private List<AvailableActionsEnum> availableActions = null;

  public static final String JSON_PROPERTY_BASE_AMOUNT = "base_amount";
  private String baseAmount;

  public static final String JSON_PROPERTY_BASE_CURRENCY = "base_currency";
  private String baseCurrency;

  public static final String JSON_PROPERTY_BOOKING_REFERENCE = "booking_reference";
  private String bookingReference;

  public static final String JSON_PROPERTY_CANCELLED_AT = "cancelled_at";
  private OffsetDateTime cancelledAt;

  public static final String JSON_PROPERTY_CHANGES = "changes";
  private List<OrderChange> changes = new ArrayList<>();

  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private OrderConditions1 conditions;

  /**
   * Whether the __Order__ is Self-Managed or Managed
   */
  public enum ContentEnum {
    SELF_MANAGED("self-managed"),
    
    MANAGED("managed");

    private String value;

    ContentEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentEnum fromValue(String value) {
      for (ContentEnum b : ContentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT = "content";
  private ContentEnum content;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DOCUMENTS = "documents";
  private List<OrderDocument> documents = new ArrayList<>();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Object metadata;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private Airline4 owner;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OrderPassenger> passengers = new ArrayList<>();

  public static final String JSON_PROPERTY_PAYMENT_STATUS = "payment_status";
  private OrderPaymentStatus paymentStatus;

  public static final String JSON_PROPERTY_SERVICES = "services";
  private List<OrderService> services = new ArrayList<>();

  public static final String JSON_PROPERTY_SLICES = "slices";
  private List<OrderSlice> slices = new ArrayList<>();

  public static final String JSON_PROPERTY_SYNCED_AT = "synced_at";
  private OffsetDateTime syncedAt;

  public static final String JSON_PROPERTY_TAX_AMOUNT = "tax_amount";
  private String taxAmount;

  public static final String JSON_PROPERTY_TAX_CURRENCY = "tax_currency";
  private String taxCurrency;

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  public Order1() { 
  }

  public Order1 airlineInitiatedChanges(List<AirlineInitiatedChange> airlineInitiatedChanges) {
    
    this.airlineInitiatedChanges = airlineInitiatedChanges;
    return this;
  }

  public Order1 addAirlineInitiatedChangesItem(AirlineInitiatedChange airlineInitiatedChangesItem) {
    this.airlineInitiatedChanges.add(airlineInitiatedChangesItem);
    return this;
  }

   /**
   * The airline-initiated changes for this Order
   * @return airlineInitiatedChanges
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The airline-initiated changes for this Order")
  @JsonProperty(JSON_PROPERTY_AIRLINE_INITIATED_CHANGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<AirlineInitiatedChange> getAirlineInitiatedChanges() {
    return airlineInitiatedChanges;
  }


  @JsonProperty(JSON_PROPERTY_AIRLINE_INITIATED_CHANGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAirlineInitiatedChanges(List<AirlineInitiatedChange> airlineInitiatedChanges) {
    this.airlineInitiatedChanges = airlineInitiatedChanges;
  }


  public Order1 availableActions(List<AvailableActionsEnum> availableActions) {
    
    this.availableActions = availableActions;
    return this;
  }

  public Order1 addAvailableActionsItem(AvailableActionsEnum availableActionsItem) {
    if (this.availableActions == null) {
      this.availableActions = new ArrayList<>();
    }
    this.availableActions.add(availableActionsItem);
    return this;
  }

   /**
   * The available actions for this __Order__
   * @return availableActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"cancel\",\"update\"]", value = "The available actions for this __Order__")
  @JsonProperty(JSON_PROPERTY_AVAILABLE_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AvailableActionsEnum> getAvailableActions() {
    return availableActions;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableActions(List<AvailableActionsEnum> availableActions) {
    this.availableActions = availableActions;
  }


  public Order1 baseAmount(String baseAmount) {
    
    this.baseAmount = baseAmount;
    return this;
  }

   /**
   * The base price of the order for all flights and services booked, excluding taxes
   * @return baseAmount
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "60.60", required = true, value = "The base price of the order for all flights and services booked, excluding taxes")
  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBaseAmount() {
    return baseAmount;
  }


  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseAmount(String baseAmount) {
    this.baseAmount = baseAmount;
  }


  public Order1 baseCurrency(String baseCurrency) {
    
    this.baseCurrency = baseCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;base_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return baseCurrency
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `base_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBaseCurrency() {
    return baseCurrency;
  }


  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseCurrency(String baseCurrency) {
    this.baseCurrency = baseCurrency;
  }


  public Order1 bookingReference(String bookingReference) {
    
    this.bookingReference = bookingReference;
    return this;
  }

   /**
   * The airline&#39;s reference for the order, sometimes known as a \&quot;passenger name record\&quot; (PNR) or \&quot;record locator\&quot;. Your customers can use this to check in and manage their booking on the airline&#39;s website. Usually, this is made up of six alphanumeric characters, but airlines can have their own formats (for example, easyJet&#39;s booking references are 7 alphanumeric characters long and LATAM&#39;s references are made up of 13 alphanumeric characters beginning with &#x60;LA&#x60;.)
   * @return bookingReference
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "RZPNX8", required = true, value = "The airline's reference for the order, sometimes known as a \"passenger name record\" (PNR) or \"record locator\". Your customers can use this to check in and manage their booking on the airline's website. Usually, this is made up of six alphanumeric characters, but airlines can have their own formats (for example, easyJet's booking references are 7 alphanumeric characters long and LATAM's references are made up of 13 alphanumeric characters beginning with `LA`.)")
  @JsonProperty(JSON_PROPERTY_BOOKING_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingReference() {
    return bookingReference;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingReference(String bookingReference) {
    this.bookingReference = bookingReference;
  }


  public Order1 cancelledAt(OffsetDateTime cancelledAt) {
    
    this.cancelledAt = cancelledAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was cancelled, if it has been cancelled
   * @return cancelledAt
  **/
  @javax.annotation.Nullable
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was cancelled, if it has been cancelled")
  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCancelledAt() {
    return cancelledAt;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelledAt(OffsetDateTime cancelledAt) {
    this.cancelledAt = cancelledAt;
  }


  public Order1 changes(List<OrderChange> changes) {
    
    this.changes = changes;
    return this;
  }

  public Order1 addChangesItem(OrderChange changesItem) {
    this.changes.add(changesItem);
    return this;
  }

   /**
   * The passenger-initiated changes for this Order
   * @return changes
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The passenger-initiated changes for this Order")
  @JsonProperty(JSON_PROPERTY_CHANGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderChange> getChanges() {
    return changes;
  }


  @JsonProperty(JSON_PROPERTY_CHANGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChanges(List<OrderChange> changes) {
    this.changes = changes;
  }


  public Order1 conditions(OrderConditions1 conditions) {
    
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderConditions1 getConditions() {
    return conditions;
  }


  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConditions(OrderConditions1 conditions) {
    this.conditions = conditions;
  }


  public Order1 content(ContentEnum content) {
    
    this.content = content;
    return this;
  }

   /**
   * Whether the __Order__ is Self-Managed or Managed
   * @return content
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "self-managed", value = "Whether the __Order__ is Self-Managed or Managed")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContentEnum getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(ContentEnum content) {
    this.content = content;
  }


  public Order1 createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was created
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11.642Z", required = true, value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Order1 documents(List<OrderDocument> documents) {
    
    this.documents = documents;
    return this;
  }

  public Order1 addDocumentsItem(OrderDocument documentsItem) {
    this.documents.add(documentsItem);
    return this;
  }

   /**
   * The documents issued for this order
   * @return documents
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The documents issued for this order")
  @JsonProperty(JSON_PROPERTY_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderDocument> getDocuments() {
    return documents;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDocuments(List<OrderDocument> documents) {
    this.documents = documents;
  }


  public Order1 id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order
   * @return id
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ord_00009hthhsUZ8W4LxQgkjo", required = true, value = "Duffel's unique identifier for the order")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public Order1 liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the order was created in live mode. This field will be set to &#x60;true&#x60; if the order was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Whether the order was created in live mode. This field will be set to `true` if the order was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public Order1 metadata(Object metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Metadata contains a set of key-value pairs that you can attach to an object. It can be useful for storing additional information about the object, in a structured format. Duffel does not use this information. You should not store sensitive information in this field. 
   * @return metadata
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "{\"customer_prefs\":\"window seat\",\"payment_intent_id\":\"pit_00009htYpSCXrwaB9DnUm2\"}", required = true, value = "Metadata contains a set of key-value pairs that you can attach to an object. It can be useful for storing additional information about the object, in a structured format. Duffel does not use this information. You should not store sensitive information in this field. ")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Object getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  public Order1 owner(Airline4 owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Airline4 getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwner(Airline4 owner) {
    this.owner = owner;
  }


  public Order1 passengers(List<OrderPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public Order1 addPassengersItem(OrderPassenger passengersItem) {
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The passengers who are travelling
   * @return passengers
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The passengers who are travelling")
  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengers(List<OrderPassenger> passengers) {
    this.passengers = passengers;
  }


  public Order1 paymentStatus(OrderPaymentStatus paymentStatus) {
    
    this.paymentStatus = paymentStatus;
    return this;
  }

   /**
   * Get paymentStatus
   * @return paymentStatus
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderPaymentStatus getPaymentStatus() {
    return paymentStatus;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPaymentStatus(OrderPaymentStatus paymentStatus) {
    this.paymentStatus = paymentStatus;
  }


  public Order1 services(List<OrderService> services) {
    
    this.services = services;
    return this;
  }

  public Order1 addServicesItem(OrderService servicesItem) {
    this.services.add(servicesItem);
    return this;
  }

   /**
   * The services booked along with this order
   * @return services
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The services booked along with this order")
  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderService> getServices() {
    return services;
  }


  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServices(List<OrderService> services) {
    this.services = services;
  }


  public Order1 slices(List<OrderSlice> slices) {
    
    this.slices = slices;
    return this;
  }

  public Order1 addSlicesItem(OrderSlice slicesItem) {
    this.slices.add(slicesItem);
    return this;
  }

   /**
   * The [slices](/docs/api/overview/key-principles) that make up the itinerary of this order. One-way journeys can be expressed using one slice, whereas return trips will need two.
   * @return slices
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The [slices](/docs/api/overview/key-principles) that make up the itinerary of this order. One-way journeys can be expressed using one slice, whereas return trips will need two.")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderSlice> getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSlices(List<OrderSlice> slices) {
    this.slices = slices;
  }


  public Order1 syncedAt(OffsetDateTime syncedAt) {
    
    this.syncedAt = syncedAt;
    return this;
  }

   /**
   * Airlines are always the source of truth for orders. The orders returned in the Duffel API are a view of those orders. This field is the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Order__ was last synced with the airline. If this datetime is in the last minute you can consider the order up to date. 
   * @return syncedAt
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(example = "2020-04-11T15:48:11Z", required = true, value = "Airlines are always the source of truth for orders. The orders returned in the Duffel API are a view of those orders. This field is the [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Order__ was last synced with the airline. If this datetime is in the last minute you can consider the order up to date. ")
  @JsonProperty(JSON_PROPERTY_SYNCED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getSyncedAt() {
    return syncedAt;
  }


  @JsonProperty(JSON_PROPERTY_SYNCED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSyncedAt(OffsetDateTime syncedAt) {
    this.syncedAt = syncedAt;
  }


  public Order1 taxAmount(String taxAmount) {
    
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * The amount of tax payable on the order for all the flights booked
   * @return taxAmount
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "30.20", required = true, value = "The amount of tax payable on the order for all the flights booked")
  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTaxAmount() {
    return taxAmount;
  }


  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }


  public Order1 taxCurrency(String taxCurrency) {
    
    this.taxCurrency = taxCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;tax_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return taxCurrency
  **/
  @javax.annotation.Nullable
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `tax_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTaxCurrency() {
    return taxCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTaxCurrency(String taxCurrency) {
    this.taxCurrency = taxCurrency;
  }


  public Order1 totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the order for all the flights and services booked, including taxes
   * @return totalAmount
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "90.80", required = true, value = "The total price of the order for all the flights and services booked, including taxes")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public Order1 totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GBP", required = true, value = "The currency of the `total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Order1 order1 = (Order1) o;
    return Objects.equals(this.airlineInitiatedChanges, order1.airlineInitiatedChanges) &&
        Objects.equals(this.availableActions, order1.availableActions) &&
        Objects.equals(this.baseAmount, order1.baseAmount) &&
        Objects.equals(this.baseCurrency, order1.baseCurrency) &&
        Objects.equals(this.bookingReference, order1.bookingReference) &&
        Objects.equals(this.cancelledAt, order1.cancelledAt) &&
        Objects.equals(this.changes, order1.changes) &&
        Objects.equals(this.conditions, order1.conditions) &&
        Objects.equals(this.content, order1.content) &&
        Objects.equals(this.createdAt, order1.createdAt) &&
        Objects.equals(this.documents, order1.documents) &&
        Objects.equals(this.id, order1.id) &&
        Objects.equals(this.liveMode, order1.liveMode) &&
        Objects.equals(this.metadata, order1.metadata) &&
        Objects.equals(this.owner, order1.owner) &&
        Objects.equals(this.passengers, order1.passengers) &&
        Objects.equals(this.paymentStatus, order1.paymentStatus) &&
        Objects.equals(this.services, order1.services) &&
        Objects.equals(this.slices, order1.slices) &&
        Objects.equals(this.syncedAt, order1.syncedAt) &&
        Objects.equals(this.taxAmount, order1.taxAmount) &&
        Objects.equals(this.taxCurrency, order1.taxCurrency) &&
        Objects.equals(this.totalAmount, order1.totalAmount) &&
        Objects.equals(this.totalCurrency, order1.totalCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(airlineInitiatedChanges, availableActions, baseAmount, baseCurrency, bookingReference, cancelledAt, changes, conditions, content, createdAt, documents, id, liveMode, metadata, owner, passengers, paymentStatus, services, slices, syncedAt, taxAmount, taxCurrency, totalAmount, totalCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Order1 {\n");
    sb.append("    airlineInitiatedChanges: ").append(toIndentedString(airlineInitiatedChanges)).append("\n");
    sb.append("    availableActions: ").append(toIndentedString(availableActions)).append("\n");
    sb.append("    baseAmount: ").append(toIndentedString(baseAmount)).append("\n");
    sb.append("    baseCurrency: ").append(toIndentedString(baseCurrency)).append("\n");
    sb.append("    bookingReference: ").append(toIndentedString(bookingReference)).append("\n");
    sb.append("    cancelledAt: ").append(toIndentedString(cancelledAt)).append("\n");
    sb.append("    changes: ").append(toIndentedString(changes)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    paymentStatus: ").append(toIndentedString(paymentStatus)).append("\n");
    sb.append("    services: ").append(toIndentedString(services)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("    syncedAt: ").append(toIndentedString(syncedAt)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxCurrency: ").append(toIndentedString(taxCurrency)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

