/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderChangeSlices;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An order change offer represents flights that can be used to replace a slice in an existing paid order
 */
@ApiModel(description = "An order change offer represents flights that can be used to replace a slice in an existing paid order")
@JsonPropertyOrder({
  OrderChangeOffer.JSON_PROPERTY_CHANGE_TOTAL_AMOUNT,
  OrderChangeOffer.JSON_PROPERTY_CHANGE_TOTAL_CURRENCY,
  OrderChangeOffer.JSON_PROPERTY_CREATED_AT,
  OrderChangeOffer.JSON_PROPERTY_EXPIRES_AT,
  OrderChangeOffer.JSON_PROPERTY_ID,
  OrderChangeOffer.JSON_PROPERTY_LIVE_MODE,
  OrderChangeOffer.JSON_PROPERTY_NEW_TOTAL_AMOUNT,
  OrderChangeOffer.JSON_PROPERTY_NEW_TOTAL_CURRENCY,
  OrderChangeOffer.JSON_PROPERTY_ORDER_CHANGE_ID,
  OrderChangeOffer.JSON_PROPERTY_PENALTY_TOTAL_AMOUNT,
  OrderChangeOffer.JSON_PROPERTY_PENALTY_TOTAL_CURRENCY,
  OrderChangeOffer.JSON_PROPERTY_REFUND_TO,
  OrderChangeOffer.JSON_PROPERTY_SLICES,
  OrderChangeOffer.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Order_Change_Offer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OrderChangeOffer {
  public static final String JSON_PROPERTY_CHANGE_TOTAL_AMOUNT = "change_total_amount";
  private String changeTotalAmount;

  public static final String JSON_PROPERTY_CHANGE_TOTAL_CURRENCY = "change_total_currency";
  private JsonNullable<String> changeTotalCurrency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_NEW_TOTAL_AMOUNT = "new_total_amount";
  private JsonNullable<String> newTotalAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NEW_TOTAL_CURRENCY = "new_total_currency";
  private String newTotalCurrency;

  public static final String JSON_PROPERTY_ORDER_CHANGE_ID = "order_change_id";
  private String orderChangeId;

  public static final String JSON_PROPERTY_PENALTY_TOTAL_AMOUNT = "penalty_total_amount";
  private JsonNullable<String> penaltyTotalAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PENALTY_TOTAL_CURRENCY = "penalty_total_currency";
  private JsonNullable<String> penaltyTotalCurrency = JsonNullable.<String>undefined();

  /**
   * Where the refund, once confirmed, will be sent. &#x60;card&#x60; is currently a restricted feature. &#x60;awaiting_payment&#x60; is for pay later orders where no payment has been made yet. 
   */
  public enum RefundToEnum {
    ARC_BSP_CASH("arc_bsp_cash"),
    
    BALANCE("balance"),
    
    CARD("card"),
    
    VOUCHER("voucher"),
    
    AWAITING_PAYMENT("awaiting_payment");

    private String value;

    RefundToEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundToEnum fromValue(String value) {
      for (RefundToEnum b : RefundToEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUND_TO = "refund_to";
  private RefundToEnum refundTo;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private OrderChangeSlices slices;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public OrderChangeOffer() { 
  }

  public OrderChangeOffer changeTotalAmount(String changeTotalAmount) {
    
    this.changeTotalAmount = changeTotalAmount;
    return this;
  }

   /**
   * The amount that will be charged or returned to the original payment method if refunded, determined according to the fare conditions. This may be negative to reflect a refund. 
   * @return changeTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "90.80", value = "The amount that will be charged or returned to the original payment method if refunded, determined according to the fare conditions. This may be negative to reflect a refund. ")
  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChangeTotalAmount() {
    return changeTotalAmount;
  }


  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChangeTotalAmount(String changeTotalAmount) {
    this.changeTotalAmount = changeTotalAmount;
  }


  public OrderChangeOffer changeTotalCurrency(String changeTotalCurrency) {
    this.changeTotalCurrency = JsonNullable.<String>of(changeTotalCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;change_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return changeTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `change_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonIgnore

  public String getChangeTotalCurrency() {
        return changeTotalCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getChangeTotalCurrency_JsonNullable() {
    return changeTotalCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_CHANGE_TOTAL_CURRENCY)
  public void setChangeTotalCurrency_JsonNullable(JsonNullable<String> changeTotalCurrency) {
    this.changeTotalCurrency = changeTotalCurrency;
  }

  public void setChangeTotalCurrency(String changeTotalCurrency) {
    this.changeTotalCurrency = JsonNullable.<String>of(changeTotalCurrency);
  }


  public OrderChangeOffer createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public OrderChangeOffer expiresAt(OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer will expire and no longer be usable to create an order
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:42:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer will expire and no longer be usable to create an order")
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public OrderChangeOffer id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the order change offer
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "oco_0000A3vUda8dKRtUSQPSXw", value = "Duffel's unique identifier for the order change offer")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderChangeOffer liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the order change offer was created in live mode. This field will be set to &#x60;true&#x60; if the order change offer was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether the order change offer was created in live mode. This field will be set to `true` if the order change offer was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public OrderChangeOffer newTotalAmount(String newTotalAmount) {
    this.newTotalAmount = JsonNullable.<String>of(newTotalAmount);
    
    return this;
  }

   /**
   * The price of this offer if it was newly purchased
   * @return newTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "35.50", value = "The price of this offer if it was newly purchased")
  @JsonIgnore

  public String getNewTotalAmount() {
        return newTotalAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNewTotalAmount_JsonNullable() {
    return newTotalAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_AMOUNT)
  public void setNewTotalAmount_JsonNullable(JsonNullable<String> newTotalAmount) {
    this.newTotalAmount = newTotalAmount;
  }

  public void setNewTotalAmount(String newTotalAmount) {
    this.newTotalAmount = JsonNullable.<String>of(newTotalAmount);
  }


  public OrderChangeOffer newTotalCurrency(String newTotalCurrency) {
    
    this.newTotalCurrency = newTotalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;new_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return newTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `new_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNewTotalCurrency() {
    return newTotalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_NEW_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNewTotalCurrency(String newTotalCurrency) {
    this.newTotalCurrency = newTotalCurrency;
  }


  public OrderChangeOffer orderChangeId(String orderChangeId) {
    
    this.orderChangeId = orderChangeId;
    return this;
  }

   /**
   * The ID for an __order change__ if one has already been created from this __order change offer__
   * @return orderChangeId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "oce_0000A4QasEUIjJ6jHKfhHU", value = "The ID for an __order change__ if one has already been created from this __order change offer__")
  @JsonProperty(JSON_PROPERTY_ORDER_CHANGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderChangeId() {
    return orderChangeId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_CHANGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderChangeId(String orderChangeId) {
    this.orderChangeId = orderChangeId;
  }


  public OrderChangeOffer penaltyTotalAmount(String penaltyTotalAmount) {
    this.penaltyTotalAmount = JsonNullable.<String>of(penaltyTotalAmount);
    
    return this;
  }

   /**
   * The penalty imposed by the airline for making this change
   * @return penaltyTotalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10.50", value = "The penalty imposed by the airline for making this change")
  @JsonIgnore

  public String getPenaltyTotalAmount() {
        return penaltyTotalAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPenaltyTotalAmount_JsonNullable() {
    return penaltyTotalAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_AMOUNT)
  public void setPenaltyTotalAmount_JsonNullable(JsonNullable<String> penaltyTotalAmount) {
    this.penaltyTotalAmount = penaltyTotalAmount;
  }

  public void setPenaltyTotalAmount(String penaltyTotalAmount) {
    this.penaltyTotalAmount = JsonNullable.<String>of(penaltyTotalAmount);
  }


  public OrderChangeOffer penaltyTotalCurrency(String penaltyTotalCurrency) {
    this.penaltyTotalCurrency = JsonNullable.<String>of(penaltyTotalCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;penalty_total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return penaltyTotalCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GBP", value = "The currency of the `penalty_total_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation's billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). ")
  @JsonIgnore

  public String getPenaltyTotalCurrency() {
        return penaltyTotalCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPenaltyTotalCurrency_JsonNullable() {
    return penaltyTotalCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_PENALTY_TOTAL_CURRENCY)
  public void setPenaltyTotalCurrency_JsonNullable(JsonNullable<String> penaltyTotalCurrency) {
    this.penaltyTotalCurrency = penaltyTotalCurrency;
  }

  public void setPenaltyTotalCurrency(String penaltyTotalCurrency) {
    this.penaltyTotalCurrency = JsonNullable.<String>of(penaltyTotalCurrency);
  }


  public OrderChangeOffer refundTo(RefundToEnum refundTo) {
    
    this.refundTo = refundTo;
    return this;
  }

   /**
   * Where the refund, once confirmed, will be sent. &#x60;card&#x60; is currently a restricted feature. &#x60;awaiting_payment&#x60; is for pay later orders where no payment has been made yet. 
   * @return refundTo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "arc_bsp_cash", value = "Where the refund, once confirmed, will be sent. `card` is currently a restricted feature. `awaiting_payment` is for pay later orders where no payment has been made yet. ")
  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundToEnum getRefundTo() {
    return refundTo;
  }


  @JsonProperty(JSON_PROPERTY_REFUND_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundTo(RefundToEnum refundTo) {
    this.refundTo = refundTo;
  }


  public OrderChangeOffer slices(OrderChangeSlices slices) {
    
    this.slices = slices;
    return this;
  }

   /**
   * Get slices
   * @return slices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderChangeSlices getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(OrderChangeSlices slices) {
    this.slices = slices;
  }


  public OrderChangeOffer updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChangeOffer orderChangeOffer = (OrderChangeOffer) o;
    return Objects.equals(this.changeTotalAmount, orderChangeOffer.changeTotalAmount) &&
        equalsNullable(this.changeTotalCurrency, orderChangeOffer.changeTotalCurrency) &&
        Objects.equals(this.createdAt, orderChangeOffer.createdAt) &&
        Objects.equals(this.expiresAt, orderChangeOffer.expiresAt) &&
        Objects.equals(this.id, orderChangeOffer.id) &&
        Objects.equals(this.liveMode, orderChangeOffer.liveMode) &&
        equalsNullable(this.newTotalAmount, orderChangeOffer.newTotalAmount) &&
        Objects.equals(this.newTotalCurrency, orderChangeOffer.newTotalCurrency) &&
        Objects.equals(this.orderChangeId, orderChangeOffer.orderChangeId) &&
        equalsNullable(this.penaltyTotalAmount, orderChangeOffer.penaltyTotalAmount) &&
        equalsNullable(this.penaltyTotalCurrency, orderChangeOffer.penaltyTotalCurrency) &&
        Objects.equals(this.refundTo, orderChangeOffer.refundTo) &&
        Objects.equals(this.slices, orderChangeOffer.slices) &&
        Objects.equals(this.updatedAt, orderChangeOffer.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeTotalAmount, hashCodeNullable(changeTotalCurrency), createdAt, expiresAt, id, liveMode, hashCodeNullable(newTotalAmount), newTotalCurrency, orderChangeId, hashCodeNullable(penaltyTotalAmount), hashCodeNullable(penaltyTotalCurrency), refundTo, slices, updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChangeOffer {\n");
    sb.append("    changeTotalAmount: ").append(toIndentedString(changeTotalAmount)).append("\n");
    sb.append("    changeTotalCurrency: ").append(toIndentedString(changeTotalCurrency)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    newTotalAmount: ").append(toIndentedString(newTotalAmount)).append("\n");
    sb.append("    newTotalCurrency: ").append(toIndentedString(newTotalCurrency)).append("\n");
    sb.append("    orderChangeId: ").append(toIndentedString(orderChangeId)).append("\n");
    sb.append("    penaltyTotalAmount: ").append(toIndentedString(penaltyTotalAmount)).append("\n");
    sb.append("    penaltyTotalCurrency: ").append(toIndentedString(penaltyTotalCurrency)).append("\n");
    sb.append("    refundTo: ").append(toIndentedString(refundTo)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

