/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderChangeOffer;
import com.duffel.sdk.model.OrderChangeRequestSlices;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An order change request represents a request to change slices in an existing paid order
 */
@ApiModel(description = "An order change request represents a request to change slices in an existing paid order")
@JsonPropertyOrder({
  OrderChangeRequest.JSON_PROPERTY_CREATED_AT,
  OrderChangeRequest.JSON_PROPERTY_ID,
  OrderChangeRequest.JSON_PROPERTY_LIVE_MODE,
  OrderChangeRequest.JSON_PROPERTY_ORDER_CHANGE_OFFERS,
  OrderChangeRequest.JSON_PROPERTY_ORDER_ID,
  OrderChangeRequest.JSON_PROPERTY_SLICES,
  OrderChangeRequest.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Order_Change_Request")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OrderChangeRequest {
  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_ORDER_CHANGE_OFFERS = "order_change_offers";
  private List<OrderChangeOffer> orderChangeOffers = null;

  public static final String JSON_PROPERTY_ORDER_ID = "order_id";
  private String orderId;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private OrderChangeRequestSlices slices;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public OrderChangeRequest() { 
  }

  public OrderChangeRequest createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change request was created
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change request was created")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public OrderChangeRequest id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of your order change request
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ocr_0000A3bQP9RLVfNUcdpLpw", value = "The ID of your order change request")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderChangeRequest liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the order was created in live mode. This field will be set to &#x60;true&#x60; if the order was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Whether the order was created in live mode. This field will be set to `true` if the order was created in live mode, or `false` if it was created in test mode.")
  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public OrderChangeRequest orderChangeOffers(List<OrderChangeOffer> orderChangeOffers) {
    
    this.orderChangeOffers = orderChangeOffers;
    return this;
  }

  public OrderChangeRequest addOrderChangeOffersItem(OrderChangeOffer orderChangeOffersItem) {
    if (this.orderChangeOffers == null) {
      this.orderChangeOffers = new ArrayList<>();
    }
    this.orderChangeOffers.add(orderChangeOffersItem);
    return this;
  }

   /**
   * The list of the offers available to perform change on the order.
   * @return orderChangeOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The list of the offers available to perform change on the order.")
  @JsonProperty(JSON_PROPERTY_ORDER_CHANGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderChangeOffer> getOrderChangeOffers() {
    return orderChangeOffers;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_CHANGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderChangeOffers(List<OrderChangeOffer> orderChangeOffers) {
    this.orderChangeOffers = orderChangeOffers;
  }


  public OrderChangeRequest orderId(String orderId) {
    
    this.orderId = orderId;
    return this;
  }

   /**
   * The order ID that you want to change
   * @return orderId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ord_0000A3bQ8FJIQoEfuC07n6", value = "The order ID that you want to change")
  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOrderId() {
    return orderId;
  }


  @JsonProperty(JSON_PROPERTY_ORDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }


  public OrderChangeRequest slices(OrderChangeRequestSlices slices) {
    
    this.slices = slices;
    return this;
  }

   /**
   * Get slices
   * @return slices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderChangeRequestSlices getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(OrderChangeRequestSlices slices) {
    this.slices = slices;
  }


  public OrderChangeRequest updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change request was last updated
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2020-01-17T10:12:14.545Z", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the order change request was last updated")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChangeRequest orderChangeRequest = (OrderChangeRequest) o;
    return Objects.equals(this.createdAt, orderChangeRequest.createdAt) &&
        Objects.equals(this.id, orderChangeRequest.id) &&
        Objects.equals(this.liveMode, orderChangeRequest.liveMode) &&
        Objects.equals(this.orderChangeOffers, orderChangeRequest.orderChangeOffers) &&
        Objects.equals(this.orderId, orderChangeRequest.orderId) &&
        Objects.equals(this.slices, orderChangeRequest.slices) &&
        Objects.equals(this.updatedAt, orderChangeRequest.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, id, liveMode, orderChangeOffers, orderId, slices, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChangeRequest {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    orderChangeOffers: ").append(toIndentedString(orderChangeOffers)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

