/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Aircraft2;
import com.duffel.sdk.model.Airline2;
import com.duffel.sdk.model.Airline3;
import com.duffel.sdk.model.Airport3;
import com.duffel.sdk.model.OrderChangeSlicesSliceSegmentsInnerDestination;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderChangeSlicesSliceSegmentsInner
 */
@JsonPropertyOrder({
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_AIRCRAFT,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_ARRIVING_AT,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_DEPARTING_AT,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_DESTINATION,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_DESTINATION_TERMINAL,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_DISTANCE,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_DURATION,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_ID,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_MARKETING_CARRIER,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_OPERATING_CARRIER,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_ORIGIN,
  OrderChangeSlicesSliceSegmentsInner.JSON_PROPERTY_ORIGIN_TERMINAL
})
@JsonTypeName("Order_Change_Slices_Slice_segments_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OrderChangeSlicesSliceSegmentsInner {
  public static final String JSON_PROPERTY_AIRCRAFT = "aircraft";
  private JsonNullable<Aircraft2> aircraft = JsonNullable.<Aircraft2>undefined();

  public static final String JSON_PROPERTY_ARRIVING_AT = "arriving_at";
  private String arrivingAt;

  public static final String JSON_PROPERTY_DEPARTING_AT = "departing_at";
  private String departingAt;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private OrderChangeSlicesSliceSegmentsInnerDestination destination;

  public static final String JSON_PROPERTY_DESTINATION_TERMINAL = "destination_terminal";
  private JsonNullable<String> destinationTerminal = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private JsonNullable<String> distance = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DURATION = "duration";
  private JsonNullable<String> duration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MARKETING_CARRIER = "marketing_carrier";
  private Airline2 marketingCarrier;

  public static final String JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER = "marketing_carrier_flight_number";
  private String marketingCarrierFlightNumber;

  public static final String JSON_PROPERTY_OPERATING_CARRIER = "operating_carrier";
  private Airline3 operatingCarrier;

  public static final String JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER = "operating_carrier_flight_number";
  private JsonNullable<String> operatingCarrierFlightNumber = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Airport3 origin;

  public static final String JSON_PROPERTY_ORIGIN_TERMINAL = "origin_terminal";
  private JsonNullable<String> originTerminal = JsonNullable.<String>undefined();

  public OrderChangeSlicesSliceSegmentsInner() { 
  }

  public OrderChangeSlicesSliceSegmentsInner aircraft(Aircraft2 aircraft) {
    this.aircraft = JsonNullable.<Aircraft2>of(aircraft);
    
    return this;
  }

   /**
   * Get aircraft
   * @return aircraft
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public Aircraft2 getAircraft() {
        return aircraft.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Aircraft2> getAircraft_JsonNullable() {
    return aircraft;
  }
  
  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  public void setAircraft_JsonNullable(JsonNullable<Aircraft2> aircraft) {
    this.aircraft = aircraft;
  }

  public void setAircraft(Aircraft2 aircraft) {
    this.aircraft = JsonNullable.<Aircraft2>of(aircraft);
  }


  public OrderChangeSlicesSliceSegmentsInner arrivingAt(String arrivingAt) {
    
    this.arrivingAt = arrivingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see &#x60;destination.timezone&#x60;)
   * @return arrivingAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2020-06-13T16:38:02", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see `destination.timezone`)")
  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArrivingAt() {
    return arrivingAt;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivingAt(String arrivingAt) {
    this.arrivingAt = arrivingAt;
  }


  public OrderChangeSlicesSliceSegmentsInner departingAt(String departingAt) {
    
    this.departingAt = departingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see &#x60;origin.timezone&#x60;)
   * @return departingAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2020-06-13T16:38:02", value = "The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see `origin.timezone`)")
  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDepartingAt() {
    return departingAt;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartingAt(String departingAt) {
    this.departingAt = departingAt;
  }


  public OrderChangeSlicesSliceSegmentsInner destination(OrderChangeSlicesSliceSegmentsInnerDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OrderChangeSlicesSliceSegmentsInnerDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(OrderChangeSlicesSliceSegmentsInnerDestination destination) {
    this.destination = destination;
  }


  public OrderChangeSlicesSliceSegmentsInner destinationTerminal(String destinationTerminal) {
    this.destinationTerminal = JsonNullable.<String>of(destinationTerminal);
    
    return this;
  }

   /**
   * The terminal at the &#x60;destination&#x60; airport where the segment is scheduled to arrive
   * @return destinationTerminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5", value = "The terminal at the `destination` airport where the segment is scheduled to arrive")
  @JsonIgnore

  public String getDestinationTerminal() {
        return destinationTerminal.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDestinationTerminal_JsonNullable() {
    return destinationTerminal;
  }
  
  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  public void setDestinationTerminal_JsonNullable(JsonNullable<String> destinationTerminal) {
    this.destinationTerminal = destinationTerminal;
  }

  public void setDestinationTerminal(String destinationTerminal) {
    this.destinationTerminal = JsonNullable.<String>of(destinationTerminal);
  }


  public OrderChangeSlicesSliceSegmentsInner distance(String distance) {
    this.distance = JsonNullable.<String>of(distance);
    
    return this;
  }

   /**
   * The distance of the segment in kilometres
   * @return distance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "424.2", value = "The distance of the segment in kilometres")
  @JsonIgnore

  public String getDistance() {
        return distance.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDistance_JsonNullable() {
    return distance;
  }
  
  @JsonProperty(JSON_PROPERTY_DISTANCE)
  public void setDistance_JsonNullable(JsonNullable<String> distance) {
    this.distance = distance;
  }

  public void setDistance(String distance) {
    this.distance = JsonNullable.<String>of(distance);
  }


  public OrderChangeSlicesSliceSegmentsInner duration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
    
    return this;
  }

   /**
   * The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PT02H26M", value = "The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
  @JsonIgnore

  public String getDuration() {
        return duration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDuration_JsonNullable() {
    return duration;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION)
  public void setDuration_JsonNullable(JsonNullable<String> duration) {
    this.duration = duration;
  }

  public void setDuration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
  }


  public OrderChangeSlicesSliceSegmentsInner id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the segment. It identifies the segment of an order (i.e. the same segment across orders will have different &#x60;id&#x60;s.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "seg_00009htYpSCXrwaB9Dn456", value = "Duffel's unique identifier for the segment. It identifies the segment of an order (i.e. the same segment across orders will have different `id`s.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderChangeSlicesSliceSegmentsInner marketingCarrier(Airline2 marketingCarrier) {
    
    this.marketingCarrier = marketingCarrier;
    return this;
  }

   /**
   * Get marketingCarrier
   * @return marketingCarrier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Airline2 getMarketingCarrier() {
    return marketingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingCarrier(Airline2 marketingCarrier) {
    this.marketingCarrier = marketingCarrier;
  }


  public OrderChangeSlicesSliceSegmentsInner marketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
    return this;
  }

   /**
   * The flight number assigned by the marketing carrier
   * @return marketingCarrierFlightNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1234", value = "The flight number assigned by the marketing carrier")
  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMarketingCarrierFlightNumber() {
    return marketingCarrierFlightNumber;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
  }


  public OrderChangeSlicesSliceSegmentsInner operatingCarrier(Airline3 operatingCarrier) {
    
    this.operatingCarrier = operatingCarrier;
    return this;
  }

   /**
   * Get operatingCarrier
   * @return operatingCarrier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Airline3 getOperatingCarrier() {
    return operatingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperatingCarrier(Airline3 operatingCarrier) {
    this.operatingCarrier = operatingCarrier;
  }


  public OrderChangeSlicesSliceSegmentsInner operatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = JsonNullable.<String>of(operatingCarrierFlightNumber);
    
    return this;
  }

   /**
   * The flight number assigned by the operating carrier. This may not be present, in which case you should display the &#x60;marketing_carrier&#x60;&#39;s information and the &#x60;marketing_carrier_flight_number&#x60;, and simply state the name of the &#x60;operating_carrier&#x60;.
   * @return operatingCarrierFlightNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4321", value = "The flight number assigned by the operating carrier. This may not be present, in which case you should display the `marketing_carrier`'s information and the `marketing_carrier_flight_number`, and simply state the name of the `operating_carrier`.")
  @JsonIgnore

  public String getOperatingCarrierFlightNumber() {
        return operatingCarrierFlightNumber.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOperatingCarrierFlightNumber_JsonNullable() {
    return operatingCarrierFlightNumber;
  }
  
  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  public void setOperatingCarrierFlightNumber_JsonNullable(JsonNullable<String> operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = operatingCarrierFlightNumber;
  }

  public void setOperatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = JsonNullable.<String>of(operatingCarrierFlightNumber);
  }


  public OrderChangeSlicesSliceSegmentsInner origin(Airport3 origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Airport3 getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(Airport3 origin) {
    this.origin = origin;
  }


  public OrderChangeSlicesSliceSegmentsInner originTerminal(String originTerminal) {
    this.originTerminal = JsonNullable.<String>of(originTerminal);
    
    return this;
  }

   /**
   * The terminal at the &#x60;origin&#x60; airport from which the segment is scheduled to depart
   * @return originTerminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "B", value = "The terminal at the `origin` airport from which the segment is scheduled to depart")
  @JsonIgnore

  public String getOriginTerminal() {
        return originTerminal.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOriginTerminal_JsonNullable() {
    return originTerminal;
  }
  
  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  public void setOriginTerminal_JsonNullable(JsonNullable<String> originTerminal) {
    this.originTerminal = originTerminal;
  }

  public void setOriginTerminal(String originTerminal) {
    this.originTerminal = JsonNullable.<String>of(originTerminal);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChangeSlicesSliceSegmentsInner orderChangeSlicesSliceSegmentsInner = (OrderChangeSlicesSliceSegmentsInner) o;
    return equalsNullable(this.aircraft, orderChangeSlicesSliceSegmentsInner.aircraft) &&
        Objects.equals(this.arrivingAt, orderChangeSlicesSliceSegmentsInner.arrivingAt) &&
        Objects.equals(this.departingAt, orderChangeSlicesSliceSegmentsInner.departingAt) &&
        Objects.equals(this.destination, orderChangeSlicesSliceSegmentsInner.destination) &&
        equalsNullable(this.destinationTerminal, orderChangeSlicesSliceSegmentsInner.destinationTerminal) &&
        equalsNullable(this.distance, orderChangeSlicesSliceSegmentsInner.distance) &&
        equalsNullable(this.duration, orderChangeSlicesSliceSegmentsInner.duration) &&
        Objects.equals(this.id, orderChangeSlicesSliceSegmentsInner.id) &&
        Objects.equals(this.marketingCarrier, orderChangeSlicesSliceSegmentsInner.marketingCarrier) &&
        Objects.equals(this.marketingCarrierFlightNumber, orderChangeSlicesSliceSegmentsInner.marketingCarrierFlightNumber) &&
        Objects.equals(this.operatingCarrier, orderChangeSlicesSliceSegmentsInner.operatingCarrier) &&
        equalsNullable(this.operatingCarrierFlightNumber, orderChangeSlicesSliceSegmentsInner.operatingCarrierFlightNumber) &&
        Objects.equals(this.origin, orderChangeSlicesSliceSegmentsInner.origin) &&
        equalsNullable(this.originTerminal, orderChangeSlicesSliceSegmentsInner.originTerminal);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(aircraft), arrivingAt, departingAt, destination, hashCodeNullable(destinationTerminal), hashCodeNullable(distance), hashCodeNullable(duration), id, marketingCarrier, marketingCarrierFlightNumber, operatingCarrier, hashCodeNullable(operatingCarrierFlightNumber), origin, hashCodeNullable(originTerminal));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChangeSlicesSliceSegmentsInner {\n");
    sb.append("    aircraft: ").append(toIndentedString(aircraft)).append("\n");
    sb.append("    arrivingAt: ").append(toIndentedString(arrivingAt)).append("\n");
    sb.append("    departingAt: ").append(toIndentedString(departingAt)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationTerminal: ").append(toIndentedString(destinationTerminal)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    marketingCarrier: ").append(toIndentedString(marketingCarrier)).append("\n");
    sb.append("    marketingCarrierFlightNumber: ").append(toIndentedString(marketingCarrierFlightNumber)).append("\n");
    sb.append("    operatingCarrier: ").append(toIndentedString(operatingCarrier)).append("\n");
    sb.append("    operatingCarrierFlightNumber: ").append(toIndentedString(operatingCarrierFlightNumber)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originTerminal: ").append(toIndentedString(originTerminal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

