/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderDocument
 */
@JsonPropertyOrder({
  OrderDocument.JSON_PROPERTY_PASSENGER_IDS,
  OrderDocument.JSON_PROPERTY_TYPE,
  OrderDocument.JSON_PROPERTY_UNIQUE_IDENTIFIER
})
@JsonTypeName("Order_Document")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class OrderDocument {
  public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
  private List<String> passengerIds = null;

  /**
   * The type of document
   */
  public enum TypeEnum {
    TICKET("electronic_ticket"),
    
    MISCELLANEOUS_DOCUMENT_ASSOCIATED("electronic_miscellaneous_document_associated"),
    
    MISCELLANEOUS_DOCUMENT_STANDALONE("electronic_miscellaneous_document_standalone");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_UNIQUE_IDENTIFIER = "unique_identifier";
  private String uniqueIdentifier;

  public OrderDocument() { 
  }

  public OrderDocument passengerIds(List<String> passengerIds) {
    
    this.passengerIds = passengerIds;
    return this;
  }

  public OrderDocument addPassengerIdsItem(String passengerIdsItem) {
    if (this.passengerIds == null) {
      this.passengerIds = new ArrayList<>();
    }
    this.passengerIds.add(passengerIdsItem);
    return this;
  }

   /**
   * The list of passenger &#x60;id&#x60;s the document applies to
   * @return passengerIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"pas_00009hj8USM7Ncg31cBCLL\"]", value = "The list of passenger `id`s the document applies to")
  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPassengerIds() {
    return passengerIds;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerIds(List<String> passengerIds) {
    this.passengerIds = passengerIds;
  }


  public OrderDocument type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of document
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "electronic_ticket", value = "The type of document")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public OrderDocument uniqueIdentifier(String uniqueIdentifier) {
    
    this.uniqueIdentifier = uniqueIdentifier;
    return this;
  }

   /**
   * The identifier for the document, in the case of electronic tickets this string represents the payment or the entitlement to fly.
   * @return uniqueIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1252106312810", value = "The identifier for the document, in the case of electronic tickets this string represents the payment or the entitlement to fly.")
  @JsonProperty(JSON_PROPERTY_UNIQUE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUniqueIdentifier() {
    return uniqueIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueIdentifier(String uniqueIdentifier) {
    this.uniqueIdentifier = uniqueIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderDocument orderDocument = (OrderDocument) o;
    return Objects.equals(this.passengerIds, orderDocument.passengerIds) &&
        Objects.equals(this.type, orderDocument.type) &&
        Objects.equals(this.uniqueIdentifier, orderDocument.uniqueIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(passengerIds, type, uniqueIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderDocument {\n");
    sb.append("    passengerIds: ").append(toIndentedString(passengerIds)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uniqueIdentifier: ").append(toIndentedString(uniqueIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

